<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }
        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }
        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }
        .tabla {
            border: 1px solid black;
        }
        .num {
            mso-number-format: General;
        }
        .text {
            mso-number-format: "\@"; /*force text*/
        }
    </style>
    <?php 
}

if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8"/>
    <div class="head">
        <table>
            <tr>
                <td rowspan="2">
                    <img src="<?php echo base_url(); ?>media/imagenes/sistema/<?php echo $this->gsatelite->get_parametro('SYS_LOGOTIPO') ?>.png" width="108px" height="48">
                </td>
                <td align="center" colspan="5">
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
                        <br/>
                        <span>Reporte de Cumplimiento <?= $reporte[0]['poa_nombre'] ?></span>
                    </h4>
                </td>
            </tr>
            <tr>
                <td align="center" colspan="5">Unidad: <?= $are_nombre ?></td>
            </tr>
        </table>
    </div>
<?php } ?>

<table class="tabla <?php echo ($tipo_reporte == null) ? "responsive table table-bordered contenedor" : ""; ?>" <?= ($tipo_reporte == 'excel') ? "border='1'" : ""; ?>>
    <thead>
        <tr style="font-weight: bold;">
            <th style="vertical-align: middle; text-align: center;" rowspan="2">Objetivo Operativo</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="2">Indicador Operativo</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="2">Forma de Cálculo</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="2">Frecuencia de Medición</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="2">Meta</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="2">Responsable(s)</th>
            <th colspan="12" style="text-align: center;">Cumplimiento</th>
            <th style="vertical-align: middle; text-align: center;" rowspan="2">Total</th>
        </tr>
        <tr style="font-weight: bold;">
            <th style="text-align: center;">Ene</th>
            <th style="text-align: center;">Feb</th>
            <th style="text-align: center;">Mar</th>
            <th style="text-align: center;">Abr</th>
            <th style="text-align: center;">May</th>
            <th style="text-align: center;">Jun</th>
            <th style="text-align: center;">Jul</th>
            <th style="text-align: center;">Ago</th>
            <th style="text-align: center;">Sep</th>
            <th style="text-align: center;">Oct</th>
            <th style="text-align: center;">Nov</th>
            <th style="text-align: center;">Dic</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $obo_v= 0;
        $ver_obo = true;
        $row_obo = array_count_values(array_column($reporte, 'obo_id'));
        if (count($reporte) > 0) {
            foreach ($reporte as $met) {
                //Se obtiene la programación acumulada de los otros meses
                $programacion = $this->plan_operativo_model->get_cumplimiento_ino(array('met_id_ino' => $met['ino_id']), 'per_codigo ASC');
                $responsables = $this->plan_operativo_model->get_plz_responsables_ino(array('ino_id' => $met['ino_id']))[0];
                $total_programacion = $total_ejecucion = 0;
                if (count($programacion) > 0) {
                    foreach ($programacion as $prog) {
                        $total_programacion += $prog['prm_programa'];
                        $total_ejecucion += $prog['sgm_ejecutado'];
                    }
                }
                $porc_color = (($total_ejecucion / $total_programacion) * 100);
                $estado = $this->gsatelite->get_tabla('evp_evaluacion_meta_poa', array('evp_rango_inicio <= ' => $porc_color, 'evp_rango_fin >= ' => $porc_color));
                ?>
                <tr>
                    <?php if ($ver_obo) {
                        ?>
                        <td style="vertical-align: middle;" rowspan="<?= ($row_obo[$met['obo_id']]) ?>"><?php echo $met['obo_codigo'] . ' - ' . $met['obo_nombre']; ?></td>
                        <?php 
                        $obo_v++;
                        if ($obo_v < $row_obo[$met['obo_id']]) {
                            $ver_obo = false;
                        }else{
                            $ver_obo = true;
                            $obo_v = 0;
                        }
                    } else { 
                        $obo_v++;
                        if ($obo_v < $row_obo[$met['obo_id']]) {
                            $ver_obo = false;
                        } else {
                            $ver_obo = true;
                            $obo_v = 0;
                        }
                    } ?>
                    <td style="vertical-align: middle;"><?php echo $met['ino_nombre']; ?></td>
                    <td style="vertical-align: middle;"><?php echo $met['ino_forma_calculo']; ?></td>
                    <td style="vertical-align: middle;"><?php echo $met['ino_frecuencia_medicion']; ?></td>
                    <td style="vertical-align: middle;"><?php echo $met['ino_meta']; ?></td>
                    <td style="vertical-align: middle;"><?php echo $responsables['responsables']; ?></td>
                    <?php if (count($programacion) > 0) {
                        foreach ($programacion as $prm) {
                            $porc_row = (($prm['sgm_ejecutado'] / $prm['prm_programa']) * 100); ?>
                            <td style="vertical-align: middle;"><?php echo number_format($porc_row,2,'.',''); ?>%</td>
                        <?php }
                    } else {
                        for ($i = 0; $i < 12 ; $i++) { ?>
                            <td style="vertical-align: middle;">--</td>
                            <?php 
                        } 
                    } ?>
                    <td style="background-color: <?php echo $estado[0]['evp_color'] ?>;"><?php echo number_format($porc_color, 2, '.', ''); ?>%</td>
                </tr>
                <?php
            }
        } ?>
    </tbody>
</table>
