<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@"; /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8"/>
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br/>
                        Reporte de Formulación POA
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<table class="tabla <?php echo ($tipo_reporte == null) ? "responsive table table-bordered contenedor" : ""; ?>">
    <thead>
    <tr style="vertical-align: middle;">
        <th rowspan="2">Linea Estrategica</th>
        <th rowspan="2">Obj. Estratégico</th>
        <th rowspan="2">Acción Estratégica</th>
        <th rowspan="2">Acción Operativa</th>
        <th rowspan="2">Responsables</th>
        <!--<th rowspan="2">Actividades sustantivas</th>-->
        <th rowspan="2">Participantes</th>
        <th rowspan="2">Entregable de la acción</th>
        <th rowspan="2">Fecha de inicio</th>
        <th rowspan="2">Fecha de cierre</th>
        <th colspan="<?php echo (count($periodos) > 0) ? count($periodos) : 1; ?>">Programación</th>
        <th rowspan="2">Total</th>
        <th rowspan="2">Estado</th>
    </tr>
    <tr>
        <?php if(count($periodos) > 0){ 
            foreach($periodos as $per){ ?>
            <th><?php echo $per['per_codigo'] ?></th>
        <?php } } else{ ?>
            <th></th>
        <?php } ?>
    </tr>
    </thead>
    <tbody>


    <?php
    //Si la variable tipo reporte existe se declara la tabla

    foreach ($reporte as $row) {

        //Se obtiene la programación de la meta
        $this->db->order_by('per_codigo ASC');
        $programacion = $this->plan_estrategico_model->get_programacion_accion_operativa(array('pxn_id_aco' => $row['aco_id']));

        $total_programacion = 0.00;//(count($programacion) > 0) ? array_sum(array_column($programacion, 'pxn_programa')) : 0;
        $estado_evaluacion_meta = $this->plan_estrategico_model->get_evaluacion_meta($total_programacion);
//        print_r($this->db->last_query());
        $estado_meta = "No Programada";
        $color_evaluacion = "";
        if(count($estado_evaluacion_meta) > 0){
            $estado_meta = $estado_evaluacion_meta[0]['evs_nombre'];
            $color_evaluacion = $estado_evaluacion_meta[0]['evs_color'];
        }

        //Se obtienen los responsables y participantes;
        $responsables = $this->plan_estrategico_model->get_responsables_plan_estrategico(array('aco_id' => $row['aco_id']), null, "GROUP_CONCAT(CONCAT_WS(' ',emp_nombre, emp_apellido)) as empleado");
        $participantes = $this->plan_estrategico_model->get_participantes_plan_estrategico(array('aco_id' => $row['aco_id']), null, "GROUP_CONCAT(CONCAT_WS(' ',emp_nombre, emp_apellido)) as empleado");
        ?>
        <tr>
            <td><?php echo $row['pie_nombre']; ?></td>
            <td><?php echo $row['obe_nombre']; ?></td>
            <td><?php echo $row['aca_nombre']; ?></td>
            <td><?php echo $row['aco_nombre']; ?></td>
            <td><?php echo $responsables[0]['empleado']; ?></td>
            <!--<td></td>-->
            <td><?php echo $participantes[0]['empleado'];?></td>
            <td><?php echo $row['aco_entregable'];?></td>
            <td><?php echo formatear_fecha('d/m/Y',$row['aco_fecha_inicio']);?></td>
            <td><?php echo formatear_fecha('d/m/Y',$row['aco_fecha_fin']);?></td>
                <?php 
              if(count($periodos) > 0){ 
            foreach($periodos as $per){ 
                if (count($programacion) > 0) {
                    $per_id = $per['per_id'];
                    $progra_periodo = array_filter($programacion, function($prm) use($per_id){
                        return ($prm['pxn_id_per'] == $per_id);
                    });
                }
                $monto_programado = number_format(0.0,2);//array_sum(array_column($progra_periodo, 'pxn_programa'));
                ?>
                <td><?php echo $monto_programado; ?>%</td>
            <?php } } else{ ?>
                <td></td>
            <?php } ?>
            <td><?php echo $total_programacion; ?></td>
            <td style="<?php echo ($color_evaluacion!='') ? "background-color:".$color_evaluacion : ""; ?>">
                <b><?php echo $estado_meta; ?></b>
            </td>
        </tr>
    <?php } ?>
    </tbody>
</table>
