<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@"; /*force text*/
        }
    </style>
    <?php 
}
if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8"/>
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br/>
                        Reporte de Formulación PEI   <?php echo mb_strtoupper($reporte[0]['pes_nombre'], 'UTF-8'); ?>
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php 
} ?>
<table border="1" class="tabla <?php echo ($tipo_reporte == null) ? "responsive table table-bordered contenedor" : ""; ?>">
    <thead>
        <tr style="vertical-align: middle;">
            <th rowspan="2">Linea Estrategica</th>
            <th rowspan="2">Obj. Estratégico</th>
            <th rowspan="2">Acción Estratégica</th>
            <th rowspan="2">Acción Operativa</th>
            <th rowspan="2">Responsables</th>
            <th rowspan="2">Participantes</th>
            <th rowspan="2">Entregable de la acción</th>
            <th rowspan="2">Fecha de inicio</th>
            <th rowspan="2">Fecha de cierre</th>
            <th colspan="<?php echo (count($periodos) > 0) ? count($periodos) : 1; ?>">Programación</th>
            <th rowspan="2">Total programación</th>
            <th colspan="<?php echo (count($periodos) > 0) ? count($periodos) : 1; ?>">Ejecución</th>
            <th rowspan="2">Total ejecución (%)</th>
            <th rowspan="2">Estado</th>
        </tr>
        <tr>
            <?php if(count($periodos) > 0){ 
                foreach($periodos as $per){ ?>
                    <th><?php echo $per['per_codigo'] ?>(%)</th>
                <?php }
            } else{ ?>
                <th></th>
                <?php
            }
            if(count($periodos) > 0){
                foreach($periodos as $per){ ?>
                    <th><?php echo $per['per_codigo'] ?>(%)</th>
                <?php } 
            } else{ ?>
                <th></th>
                <?php 
            } ?>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($reporte) > 0) {
            $pie_v = $obe_v = $aca_v = 0;
            $ver_pie = $ver_obe = $ver_aca = true;
            $row_pie = array_count_values(array_column($reporte, 'pie_id'));
            $row_obe = array_count_values(array_column($reporte, 'obe_id'));
            $row_aca = array_count_values(array_column($reporte, 'aca_id'));
            foreach ($reporte as $k => $row) {
                //Se obtiene la programación de la meta
                                $this->db->order_by('per_codigo ASC');
                $programacion = $this->plan_estrategico_model->get_programacion_accion_operativa(array('pxn_id_aco' => $row['aco_id']));
                $total_programacion = (count($programacion) > 0) ? array_sum(array_column($programacion, 'pxn_programa')) : 0;

                //Se obtiene la ejecucion de la meta
                             $this->db->order_by('per_codigo ASC');
                $ejecucion = $this->plan_estrategico_model->get_ejecucion_accion_operativa(array('aco_id' => $row['aco_id']));
                $total_ejecucion = (count($ejecucion) > 0) ? (array_sum(array_column($ejecucion, 'ejecucion_anio')) * 100) : 0;
                $total_ejecucion = ($total_ejecucion > 100) ? 100 : $total_ejecucion;
                $porcn_ejecucion = ($total_ejecucion > 100) ? 100 : $total_ejecucion;

                //Se obtienen los responsables y participantes;
                $responsables = $this->plan_estrategico_model->get_responsables_plan_estrategico(array('aco_id'=>$row['aco_id']),null,"GROUP_CONCAT(DISTINCT(plz_nombre) SEPARATOR ', ') AS empleado");
                $participantes = $this->plan_estrategico_model->get_participantes_plan_estrategico(array('aco_id'=>$row['aco_id']),null,"GROUP_CONCAT(DISTINCT(plz_nombre) SEPARATOR ', ') AS empleado");
                $estado = $this->gsatelite->get_tabla('evs_evaluacion_meta_estrategica', array('evs_rango_inicio <= ' => $porcn_ejecucion, 'evs_rango_fin >= ' => $porcn_ejecucion));
                ?>
                <tr>
                    <?php 
                    if ($ver_pie) {
                        ?>
                        <td style="vertical-align: middle;" rowspan="<?php echo $row_pie[$row['pie_id']] ?>"><?php echo $row['pie_nombre']; ?></td>
                        <?php 
                        $pie_v++;
                        if ($pie_v < $row_pie[$row['pie_id']]) {
                            $ver_pie = false;
                        }else{
                            $ver_pie = true;
                            $pie_v = 0;
                        }
                    } else {
                        $pie_v++;
                        if ($pie_v < $row_pie[$row['pie_id']]) {
                            $ver_pie = false;
                        } else {
                            $ver_pie = true;
                            $pie_v = 0;
                        }
                    }
                    if ($ver_obe) {
                        ?>
                        <td style="vertical-align: middle;" rowspan="<?php echo $row_obe[$row['obe_id']] ?>"><?php echo $row['obe_nombre']; ?></td>
                        <?php 
                        $obe_v++;
                        if ($obe_v < $row_obe[$row['obe_id']]) {
                            $ver_obe = false;
                        }else{
                            $ver_obe = true;
                            $obe_v = 0;
                        }
                    } else {
                        $obe_v++;
                        if ($obe_v < $row_obe[$row['obe_id']]) {
                            $ver_obe = false;
                        } else {
                            $ver_obe = true;
                            $obe_v = 0;
                        }
                    }
                    if ($ver_aca) {
                        ?>
                        <td style="vertical-align: middle;" rowspan="<?php echo $row_aca[$row['aca_id']] ?>"><?php echo $row['aca_nombre']; ?></td>
                        <?php 
                        $aca_v++;
                        if ($aca_v < $row_aca[$row['aca_id']]) {
                            $ver_aca = false;
                        }else{
                            $ver_aca = true;
                            $aca_v = 0;
                        }
                    } else {
                        $aca_v++;
                        if ($aca_v < $row_aca[$row['aca_id']]) {
                            $ver_aca = false;
                        } else {
                            $ver_aca = true;
                            $aca_v = 0;
                        }
                    } ?>
                    <td style="vertical-align: middle;"><?php echo $row['aco_nombre']; ?></td>
                    <td style="vertical-align: middle;"><?php echo $responsables[0]['empleado']; ?></td>
                    <td style="vertical-align: middle;"><?php echo $participantes[0]['empleado'];?></td>
                    <td style="vertical-align: middle;"><?php echo $row['aco_entregable'];?></td>
                    <td style="vertical-align: middle;"><?php echo formatear_fecha('d/m/Y',$row['aco_fecha_inicio']);?></td>
                    <td style="vertical-align: middle;"><?php echo formatear_fecha('d/m/Y',$row['aco_fecha_fin']);?></td>
                    <?php
                    if(count($periodos) > 0){
                        foreach($periodos as $per){
                            if (count($programacion) > 0) {
                                $per_id = $per['per_id'];
                                $progra_periodo = array_filter($programacion, function($prm) use($per_id){
                                    return ($prm['pxn_id_per'] == $per_id);
                                });
                            }
                            $monto_programado = array_sum(array_column($progra_periodo, 'pxn_programa'));
                            $porcentaje = (($monto_programado * 100) / $total_programacion); 
                            ?>
                            <td style="vertical-align: middle;"><?php echo number_format($porcentaje, 2); ?></td>
                        <?php } 
                    } else{ ?>
                        <td></td>
                    <?php } ?>
                    <td style="vertical-align: middle;"><?php echo $total_programacion; ?></td>
                    <?php
                    if(count($periodos) > 0){
                        foreach($periodos as $per){
                            if (count($ejecucion) > 0) {
                                $per_id = $per['per_id'];
                                $progra_periodo = array_filter($ejecucion, function($prm) use($per_id){
                                    return ($prm['pxn_id_per'] == $per_id);
                                });
                            }
                            $monto_ejecutado = array_sum(array_column($progra_periodo, 'ejecucion_anio'));
                            $porcent = (($monto_ejecutado * 100) > 100) ? 100 : ($monto_ejecutado * 100);
                            ?>
                            <td style="vertical-align: middle;"><?php echo $porcent; ?></td>
                        <?php } 
                    } else{ ?>
                        <td></td>
                    <?php } ?>
                    <td style="vertical-align: middle;"><?php echo $total_ejecucion; ?></td>
                    <?php if (count($estado) > 0) { ?>
                        <td style="vertical-align: middle; background-color: <?php echo $estado[0]['evs_color']; ?>;"><?php echo mb_strtoupper($estado[0]['evs_nombre'], 'UTF-8'); ?></td>
                    <?php } else { ?>
                        <td>NO PROGRAMADA</td>
                    <?php } ?>
                </tr>
            <?php }
        } else { ?>
            <tr><td colspan="16" style="font-weight: bold; text-align: center;">No se encontraron registros con los filtros aplicados</td></tr>
            <?php
        } ?>
    </tbody>
</table>
