<?php 
$url = ($ver) ? "" : 'modulo_planificacion/pla_plan_operativo/edit_obj_opera/' . $plan_id . '/' . $area_id . '/'  . $datos['obo_id'];
 ?>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span class="icon16 icomoon-icon-equalizer-2"></span>
                    <span><?=($ver) ? "Ver" : "Editar"; ?> Objetivo Operativo</span>
                </h4>
            </div>
            <form method="POST" id="form_add" action="<?= base_url($url) ?>">
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">POA: <b style="color:red;">*</b></label>
                                    <div class="span7 controls labels-info">
                                        <select id="slc_poa" name="slc_poa" class="nostyle" placeholder="Seleccione" onchange="$('#slc_poa_error').html('');" <?= ($ver) ? "disabled" : ""; ?>>
                                            <option value=""></option>
                                            <?php echo $plan_operativo; ?>
                                        </select>
                                        <div id="slc_poa_error" style="color:red;padding-top:1%;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Área: <b style="color:red;">*</b></label>
                                    <div class="span7 controls labels-info">
                                        <select id="slc_are" name="slc_are" class="nostyle" placeholder="Seleccione" onchange="$('#slc_are_error').html('');" <?= ($ver) ? "disabled" : ""; ?>>
                                            <option value=""></option>
                                            <?php echo $areas_poa; ?>
                                        </select>
                                        <div id="slc_are_error" style="color:red;padding-top:1%;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Código:<span style="color:red;">*</span></label>
                                    <div class="span7 controls">
                                        <input type="text" name="codigo" id="codigo" value="<?= $datos['obo_codigo'] ?>" maxlength="100" <?= ($ver) ? "readonly" : ""; ?> />
                                        <br>
                                        <div id="codigo_error" style="color:red;padding-top:1%;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Nombre:<span style="color:red;">*</span></label>
                                    <div class="span7 controls">
                                        <textarea name="nombre" id="nombre" maxlength="999" <?= ($ver) ? "readonly" : ""; ?>><?= $datos['obo_nombre'] ?></textarea>
                                        <br>
                                        <div id="nombre_error" style="color:red;padding-top:1%;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Estado:</label>
                                    <div class="span7 controls">
                                        <select class="nostyle" name="estado" id="estado" placeholder="Seleccione" <?= ($ver) ? "disabled" : ""; ?> >
                                            <option value=""></option>
                                            <option value="1" <?=($datos['obo_estado'] == 1) ? "selected" : "";?>>Activo</option>
                                            <option value="0" <?=($datos['obo_estado'] == 0) ? "selected" : "";?> >Inactivo</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions" style="text-align: center;">
                        <?php if ($ver) { ?>
                             <a href="<?= base_url('modulo_planificacion/pla_plan_operativo/obj_operativo/' . $plan_id . '/' . $area_id) ?>" class="btn btn-info">
                                <span class="icomoon-icon-undo-2 white"> Regresar</span>
                            </a>
                        <?php } else { ?>
                            <input type="hidden" id="obo_id" name="obo_id" value="<?= $datos['obo_id'] ?>">
                            <button class="btn btn-success" type="submit" value="0" name="btnCrear"><span class="icomoon-icon-checkmark white"> Guardar</span></button>
                            <button class="btn btn-success" type="submit" value="1" name="btnCrear"><span class="icomoon-icon-checkmark white"> Guardar y volver a la lista</span></button>
                            <a href="<?= base_url('modulo_planificacion/pla_plan_operativo/obj_operativo/' . $plan_id . '/' . $area_id) ?>" class="btn btn-danger btn-cancelar">
                                <span class="icomoon-icon-cancel-2 white"> Cancelar</span>
                            </a>
                            <div>
                                <br>
                                Campos con asterisco en <font color='FE2E2E'>rojo</font> son requeridos
                            </div> 
                        <?php } ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function(){
        $("select").select2();

        $("#slc_poa").change(function() {
            var poa = $(this).val();
            if (poa > 0) {
                $.ajax({
                    type:'POST',
                    url: urlj + 'modulo_planificacion/pla_plan_operativo/areas_by_poa',
                    data:{
                        poa_id: poa
                    },
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(data){
                        $("#slc_are").html(data);
                        $("#slc_are").select2();
                        wait.close();
                    }
                });
            } else {
                $("#slc_are").html('<option value=""></option>');
                $("#slc_are").select2();
            }
        });

        $("#codigo").blur(function(){
            codigo_valido();
        });

        $(document).on('focus','#codigo',function(){
            $("#codigo_error").html("");
        });

        $(document).on('focus','#nombre',function(){
            $("#nombre_error").html("");
        });

        $("#form_add").validate({
            ignore:"",
            rules: {
                slc_poa:{ required:true},
                slc_are:{ required:true},
                codigo:{ required:true},
                nombre:{ required:true}
            }, 
            ignore: ".select2-container",
            errorPlacement: function (error, element) {
                var nombre=$(element).attr("id");
                $('#'+nombre+'_error').text('Campo requerido');
            },
            submitHandler: function(form) {
                if (codigo_valido()) {
                    form.submit();
                }
            }
        });

    });

    function codigo_valido() {
        var code = $("#codigo").val();
        var poa = $("#slc_poa").val();
        var are = $("#slc_are").val();
        var obo = $("#obo_id").val();
        var respuesta = true;
        if ($.trim(code) != "" && poa != "" && are != "") {
            $.ajax({
                type:'POST',
                async: false,
                url: urlj + 'modulo_planificacion/pla_plan_operativo/validar_codigo_obj',
                data:{
                    codigo: $.trim(code),
                    poa_id: poa,
                    are_id: are,
                    obo_id: obo
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    wait.close();
                    if(data > 0){
                        crear_alerta("error", "Código debe ser único", "Por favor ingrese un nuevo código");
                        $("#codigo").val("");
                        respuesta = false;
                    }else{
                        respuesta = true;
                    }
                }
            });
        } else {
            respuesta = false;
        }
        return respuesta;
    }
</script>