<?php
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("content-disposition: attachment;filename=export-" . date("Y-m-d_H:i:s") . ".xls");
header("Pragma: no-cache");
header("Expires: 0");
?>
<style type="text/css">
    .tabla th {
        vertical-align: middle;
        text-align: center;
    }
    .tabla td {
        vertical-align: middle;
        text-align: center;
    }
    .num {
        mso-number-format: General;
    }
    .text {
        mso-number-format: "\@"; /*force text*/
    }
    .dec{
        mso-number-format: '#,##0.00';
    }
    .coin{
        mso-number-format: currency;
    }
</style>
<meta charset="utf-8"/>
<table class="tabla">
    <tbody>
        <tr>
            <td>Nombre</td>
            <td>Inicio Rango</td>
            <td>Final Rango</td>
            <td>Estado</td>
        </tr>
        <?php
        if (count($tabla) > 0) {
            foreach ($tabla as $key => $val) {
                ?>
                <tr>
                    <td><?php echo $val['evs_nombre']; ?></td>
                    <td class="dec"><?php echo $val['evs_rango_inicio']; ?></td>
                    <td class="dec"><?php echo $val['evs_rango_fin']; ?></td>
                    <td><?php echo ($val['evs_estado'] > 0) ? "Activo" : "Inactivo"; ?></td>
                </tr>
                <?php
            }
        }?>
    </tbody>
</table>
