<?php
$paciente = $seguimientos[0]['epp_numero_expediente'] . ' ' . $seguimientos[0]['epp_nombre'] . ' ' . $seguimientos[0]['epp_apellido'] . ' ' . $seguimientos[0]['epp_apellido_casada'];
switch ($seguimientos[0]['cim_estado']) {
    case 0:
    $estado = "Cancelada";
    break;
    case 1:
    $estado = "Pendiente";
    break;
    case 2:
    $estado = "Confirmada";
    break;
    case 3:
    $estado = "C/Consulta";
    break;
}?>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>Seguimientos a Consulta </h4>
            </div>
            <div class="content" style="border:0px solid red;">
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Estado:</label>
                                <div class="span7 controls">
                                    <input type="text" name="estado_consulta" id="estado_consulta" value="<?= $estado ?>" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4">Paciente:</label>
                                <div class="span7 controls">
                                    <input  type="text" name="paciente" id="paciente" value="<?= $paciente ?>" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span4" >Observaciones:</label>
                                <div class="span7 controls">
                                    <textarea readonly id="txaobservacion" name="txaobservacion" class="nostyle"><?php echo $seguimientos[0]['cim_observacion']; ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="box">
                            <div class="title"  style="border:0px;"></div>
                            <div class="content" style="border:0px;">
                                <div class="form-row row-fluid">
                                    <div class="span12">
                                        <div class="row-fluid">
                                            <table class="responsive table table-bordered contenedor" id='data_table'>
                                                <thead>
                                                    <tr>
                                                        <th>Fecha/Hora</th>
                                                        <th>Comentario</th>
                                                        <th>Anexo</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="seguimiento_table">
                                                    <?php if (count($seguimientos) > 0) { ?>
                                                        <?php foreach ($seguimientos as $key => $value) { ?>
                                                            <tr>
                                                                <td>
                                                                    <label><?php echo formatear_fecha('d-m-Y', $value['sgt_fecha']) . ' ' . $value['sgt_hora'] ?></label>
                                                                </td>
                                                                <td>
                                                                    <input type="text" name="txtcomentario[]" id="txtcomentario" value="<?php echo $value['sgt_comentario']?>" class="text tables-input-show tables-input selects-text">
                                                                </td>
                                                                <td>
                                                                    <label><a class="verAnexo" href="<?php echo base_url("uploads/anexos_medicos/" . $value['sgt_url_anexo']);?>"><?php echo $value['sgt_url_anexo']; ?></a></label>
                                                                </td>
                                                            </tr>
                                                        <?php } ?>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="form-actions" style="text-align: center;">
                        <button class="btn btn-info iconic-icon-undo white" onclick="event.preventDefault();parent.$.fancybox.close();"> Regresar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $(".verAnexo").fancybox({
            openEffect  : 'elastic',
            closeEffect : 'elastic',
            href: $(this).attr('href'),
            type: 'iframe',
            width:'100%',
            height: '100%',
            closeBtn: true,
            maxHeight : 900,
            autoSize: false,
            helpers : {
                title : {
                    type : 'inside'
                }
            }
        });
    });    
</script>
