<table class="responsive dynamicTable display table table-bordered dataTable" id="tbl_contenedor">
    <thead>
        <th>No. Procedimiento</th>
        <th>Nombre paciente</th>
        <th>Tipo Procedimiento</th>
        <th>Fecha </th>
        <th>Hora</th>
        <th>Estado</th>
        <th>Acciones</th>
    </thead>
    <tbody id="tb_contenedor">
        <?php 
        $html = '';
        if ( count($destalles) > 0) {
            foreach ($destalles as $key => $detalle) {
                $estado = "";
                switch ($detalle['pgp_estado_programacion']) {
                    case 0:
                        $estado = "Cancelado";
                        break;
                    case 1:
                        $estado = "Pendiente";
                        break;
                    case 2:
                        $estado = "Confirmado";
                        break;
                    case 3:
                        $estado = "Ejecutado";
                        break;
                }
                $html .= '<tr>';
                    $html .= '<td>'.$detalle['pgp_numero'].'</td>';
                    $html .= '<td>'.$detalle['cli_nombre'].' '.$detalle['cli_apellido'].'</td>';
                    $html .= '<td>'.$detalle['pcm_nombre'].'</td>';
                    $html .= '<td><span style="display:none;">'.formatear_fecha('Ymd',$detalle['pgp_fecha_procedimiento']).'</span>'.formatear_fecha('d-m-Y',$detalle['pgp_fecha_procedimiento']).'</td>';
                    $html .= '<td>'.$detalle['pgp_hora_desde'].'</td>';
                    $html .= '<td>'.$estado.'</td>';
                    $html .= '<td>';
                        $html .= '<div class="tools">
                                    <div class="btn-group">
                                        <button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button>
                                        <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>';
                                            if ( $detalle['pgp_estado_programacion'] == 1) {
                                            $html .=                                            
                                            '<ul class="dropdown-menu">
                                                <li>
                                                    <a href="'.base_url('modulo_medico/med_procesos/editar_procedimiento/'.$detalle['pgp_id']).'">
                                                        <span aria-hidden="true" class="icomoon-icon-pencil-5"></span>
                                                        Editar
                                                    </a>
                                                </li>    
                                                <li>                                            
                                                    <a href="'.base_url("modulo_medico/med_procesos/seguimiento_programacion/".$detalle['pgp_id']).'" title="Seguimiento" class="fancybox_modal" >
                                                        <span class="minia-icon-calendar"></span>
                                                        Seguimiento
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="'.base_url("modulo_medico/med_procesos/confirmar_programacion/".$detalle['pgp_id']).'" title="Confirmar procedimiento" class="fancybox_modal" >
                                                        <span class="icomoon-icon-checkmark-2"></span>
                                                        Confirmar
                                                    </a>
                                                </li>
                                            </ul>';
                                            }                                                                                    
                            $html .= '</div>
                                </div>';                                      
                    $html .= '</td>';
                $html .= '</tr>'; 
            }
        }
        echo $html;
    ?>
    </tbody>
</table>