<?php $p = ($tipo_repo == 'pdf') ? true : false;
if ($tipo_repo == 'exc'){
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=listado_citas.xls");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="0">
            <tr>
                <td colspan="4" style="text-align: center;" >
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
                        <br />
                        <span>Listado de citas medicas agendadas</span>
                    </h4>
                </td>
            </tr>
            <tr><td colspan="4"><?php echo $periodo; ?></td></tr>
        </table>
    </div>
    <br>
<?php } ?>
<table border="1" class="responsive table table-bordered table-condensed" cellpadding="1.5" >
    <thead>
        <tr nobr="true" style="font-weight: bold;">
            <th <?=($p)?'width="4%"':'';?>>#</th>
            <th <?=($p)?'width="33%"':'';?>>Nombre paciente</th>
            <th <?=($p)?'width="22%"':'';?>>Tipo consulta</th>
            <th <?=($p)?'width="10%"':'';?>>Fecha </th>
            <th <?=($p)?'width="10%"':'';?>>Hora desde</th>
            <th <?=($p)?'width="10%"':'';?>>Hora hasta</th>
            <th <?=($p)?'width="11%"':'';?>>Estado</th>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($registro) > 0) {
            foreach ($registro as $k => $value) {
                switch ($value['cim_estado_cita']) {
                    case 1:
                        $estado = "Pendiente";
                        break;
                    case 2:
                        $estado = "Confirmada";
                        break;
                    case 3:
                        $estado = "Con Consulta";
                        break;
                    default:
                        $estado = "Cancelada";
                        break;
                }        
                ?>
                <tr nobr="true">
                    <td <?=($p)?'width="4%"':'';?>><?= ($k + 1) ?></td>
                    <td <?=($p)?'width="33%"':'';?>><?= $value['nombre_paciente'] ?></td>
                    <td <?=($p)?'width="22%"':'';?>><?= $value['tcm_nombre'] ?></td>
                    <td <?=($p)?'width="10%"':'';?>><?= formatear_fecha('d-m-Y', $value['cim_fecha_cita']) ?></td>
                    <td <?=($p)?'width="10%"':'';?>><?= formatear_fecha('h:i A', $value['cim_hora_desde']) ?></td>
                    <td <?=($p)?'width="10%"':'';?>><?= formatear_fecha('h:i A', $value['cim_hora_hasta']) ?></td>
                    <td <?=($p)?'width="11%"':'';?>><?= $estado ?></td>
                </tr>
                <?php
            }
        } else {
            ?>
            <tr><td colspan="7" style="text-align: center;">No se encontraron registros</td></tr>
            <?php
        } ?>
    </tbody>
</table>
