<?php foreach ($cita_medica as $key => $value) {
    switch ($value['cim_estado_cita']) {
        case 0:
        $estado = "Cancelada";
        break;
        case 1:
        $estado = "Pendiente";
        break;
        case 2:
        $estado = "Confirmada";
        break;
        case 3:
        $estado = "C/Consulta";
        break;
    }
    ?>
    <tr>
        <td><?php echo $value['nombre_paciente']; ?></td>
        <td><?php echo $value['tcm_nombre']; ?></td>
        <td><span style="display: none;"><?php echo formatear_fecha('Ymd',$value['cim_fecha_cita']); ?></span><?php echo formatear_fecha('d-m-Y',$value['cim_fecha_cita']); ?></td>
        <td><?php echo date_format(date_create($value['cim_hora_desde']),'H:i'); ?></td>
        <td><?php echo date_format(date_create($value['cim_hora_hasta']),'H:i'); ?></td>
        <td><?php echo $estado; ?></td>
        <td>
            <div class="tools">
                <div class="btn-group">
                    <button class="btn">Acciones</button>
                    <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                    <ul class="dropdown-menu">
                        <?php if ($value['cim_estado_cita'] == 1): ?>
                            <li>
                                <a href="<?=base_url("modulo_medico/med_procesos/editar_cita/" . $value['cim_id'])?>" title="Editar">
                                    <span class="icon16 icon16 icon16 icomoon-icon-pencil-5"> Editar</span>
                                </a>
                            </li>
                            <li>
                                <a href="<?=base_url("modulo_medico/med_procesos/confirmar_cita/".$value['cim_id'])?>" title="Confirmar cita" class="fancybox_modal" >
                                    <span class="icomoon-icon-checkmark-2"> Confirmar</span>
                                    
                                </a>
                            </li>
                        <?php endif ?>
                        <li>
                            <a href="<?=base_url("modulo_medico/med_procesos/ver_cita/" . $value['cim_id']) ?>" title="Ver">
                                <span class="icon16 icomoon-icon-search-3"> Ver</span>
                            </a>
                        </li>
                        <?php if ($value['cim_estado_cita'] == 2): ?>
                            <li>
                                <a href="<?=base_url("modulo_medico/med_procesos/confirmar_cita/".$value['cim_id'])?>" title="Cancelar cita" class="fancybox_modal" >
                                    <span class="icomoon-icon-checkmark-2"></span>
                                    Cancelar cita
                                </a>
                            </li>
                            <li>
                                <a href="<?=base_url("modulo_medico/med_procesos/seguimiento/".$value['cim_id'])?>" title="Seguimiento" class="fancybox_modal" >
                                    <span class="minia-icon-calendar"></span>
                                    Seguimiento
                                </a>
                            </li>
                            <li>
                                <a href="<?=base_url("modulo_medico/med_procesos/agregar_consulta/".$value['cim_id'])?>" title="Consulta">
                                    <span class="entypo-icon-add"></span>
                                    Consulta
                                </a>
                            </li>
                        <?php endif ?>
                    </ul>
                </div>
            </div>
        </td>
    </tr>
    <?php
} ?>