<?php
$dias = array("","Lunes","Martes","Miercoles","Jueves","Viernes","Sábado","Domingo");
$meses = array("","Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");     
$fecha_larga = $dias[date('N')] . ' ' . date('d') . ' de ' . $meses[date('n')] . ' de ' . date('Y');

$url_post = base_url("modulo_medico/med_procesos/agregar_consulta/".$cita_medica[0]['cim_id']);

if($modulo > 0) {
    $url_post = base_url("modulo_medico/med_procesos/agregar_consulta/".$cita_medica[0]['cim_id']."/".$modulo); 
}

?>
<form id="form_add" method='POST' action="<?= $url_post ?>" >
    <input type="hidden" name="input_ping" id="input_ping" value="<?= base_url("modulo_medico/med_procesos/ping_backend") ?>">
    <input type="hidden" name="cnm_id" id="cnm_id" value="<?php echo $cnm_id; ?>">
    <input type="hidden" name="action" id="action" value="save_final">
    <input type="hidden" name="modulo" id="modulo" value="<?= $modulo ?>">
    <input type="hidden" name="clp_id" id="clp_id" value="<?= $clp_id ?>">
    <input type="hidden" id="bodega_consultorio" value="<?= $bodega_consultorio ?>">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4>Datos de la cita</h4>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Cita No.</label>
                                    <div class="span7 controls">
                                        <input type="text" name="txtnocita" id="txtnocita" class="nostyle" readonly value="<?php echo $cita_medica[0]['cim_numero']?>">
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Fecha Consulta:</label>
                                    <div class="span7 controls">
                                        <input type="text" name="txtnofecha" id="txtnofecha" class="nostyle" readonly value="<?php echo formatear_fecha("d-m-Y", $cita_medica[0]['cim_fecha_cita']) ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Paciente.</label>
                                    <div class="span7 controls">
                                        <input type="text" name="txtnoepp" id="txtnoepp" class="nostyle" readonly value="<?php echo $cita_medica[0]['nombre_paciente']?>">
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Hora desde:</label>
                                    <div class="span7 controls">
                                        <input type="text" name="txtnohoradesde" id="txtnohoradesde" class="nostyle" readonly value="<?php echo formatear_fecha('h:i A', $cita_medica[0]['cim_hora_desde'])?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Edad:</label>
                                    <div class="span7 controls">
                                        <input type="text" id="txtEdad" name="txtEdad" class="nostyle" readonly>
                                        <input type="hidden" id="txtFechaNacimiento" value="<?= formatear_fecha('d-m-Y', $cita_medica[0]['epp_fecha_nacimiento'])?>">
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Hora hasta:</label>
                                    <div class="span7 controls">
                                        <input type="text" name="txtnoh_hasta" id="txtnoh_hasta" class="nostyle" readonly value="<?php echo formatear_fecha('h:i A', $cita_medica[0]['cim_hora_hasta'])?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Médico:</label>
                                    <div class="span7 controls">
                                        <input type="text" name="txtnomed" id="txtnomed" class="nostyle" readonly value="<?php echo $cita_medica[0]['med_nombre']?>">
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Lugar</label>
                                    <div class="span7 controls">
                                        <input type="text" name="txtnolugar" id="txtnolugar" class="nostyle" readonly value="<?php echo $cita_medica[0]['luc_nombre']?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Tipo consulta:</label>
                                    <div class="span7 controls">
                                        <input type="text" name="txtnoconsult" id="txtnoconsult" class="nostyle" readonly value="<?php echo $cita_medica[0]['tcm_nombre']?>">
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span4">Observaciones.</label>
                                    <div class="span7 controls">
                                        <textarea rows="4" id="txtcomentario_cita" readonly style="width: 90%;margin-left: 10%;"><?php echo $cita_medica[0]['cim_observacion']?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="row-fluid">
                                <button type="button" class="btn fancy_modal" href="<?php echo base_url("modulo_medico/med_procesos/consultas_anteriores/".$cita_medica[0]['cim_id_epp'])?>"><span class="icon16 minia-icon-search"></span>Consultas anteriores</button>
                                <span>&nbsp;</span>
                                <button type="button" class="btn fancy_modal" href="<?= base_url("modulo_medico/med_procesos/notas_seguimiento/" . $cita_medica[0]['cim_id'])?>"><span class="icon16 icomoon-icon-history"></span>Ver Seguimientos</button>
                                <span>&nbsp;</span>
                                <button type="button" class="btn fancy_modal" href="<?= base_url("modulo_medico/med_procesos/anexos_seguimiento/" . $cita_medica[0]['cim_id_epp'])?>"><span class="icon16 icomoon-icon-file"></span>Anexos Expediente</button>
                                <?php if ($cita_medica[0]['epp_url_fotografia'] != ""): ?>
                                    <button type="button" class="btn modal_imagen" href="<?= base_url($cita_medica[0]['epp_url_fotografia']) ?>"><span class="icon16 icomoon-icon-file"></span>Fotografia</button>                            
                                <?php endif ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="span12">
        <h3>Consulta No.<?php echo $correlativo;?></h3>
        <input type="hidden" name="correlativo" value="<?php echo $correlativo;?>">
    </div>

    <div class="span12" style="margin: -34px 0px 0px 23px;"><hr style="background-color: black; height: 1px;"></div>
    <div class="row-fluid">
        <div class="span12">
            <div class="box" id="tabs">
                <div style="margin-bottom: 10px;">
                    <ul id="mytab" class="nav nav-tabs">
                        <li class="active"><a href="#chekeo_historial" data-toggle="tab" id="tab_gchekeo">Chequeo/Historial</a></li>
                        <?php if (is_null($es_chequeo)): ?>
                        <li><a href="#diagnostico" data-toggle="tab" id="tab_adiagnostico">Diagnóstigo/Plan</a></li>
                        <li><a href="#receta" data-toggle="tab" id="tab_receta">Recetas</a></li>
                        <li><a href="#examenes" data-toggle="tab" id="tab_examenes">Examenes/Anexos</a></li>
                        <li><a href="#constancia" data-toggle="tab" id="tab_constancia">Constancia/Incapacidad</a></li>
                        <?php endif ?>
                    </ul>
                    <div class="tab-content" id="principal">
                        <!-- //////////////////////////////////inicio pestaña principal//////////////////////////////////////////////////////////// -->
                        <div id="chekeo_historial" class="tab-pane fade active in">
                            <div class="row-fluid">
                                <div class="span12">
                                    <div class="box">
                                        <div class="title"  style="border:0px;"></div>
                                        <div class="content" style="border:0px solid silver;">
                                            <div class="row-fluid">
                                                <div class="span12">
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4">Peso lbs.:</label>
                                                            <div class="span3 controls">
                                                                <input onkeydown="return validardosdecimales(event, this)" type="text" extras="." name="txtpeso" id="txtpeso" class="nostyle soloDecimales" value="<?php echo is_object($draft_data) ? $draft_data->cnm_peso : ''; ?>">
                                                            </div>
                                                            <div class="span1 controls"></div>
                                                            <div class="span3 controls" <?= ($modulo > 0) ? '' : 'style="margin: 0px 0px 0px 22px;"'; ?>>
                                                                <input readonly="readonly" type="text" name="txtpesokg" id="txtpesokg" class="nostyle" value="<?php echo is_object($draft_data) && $draft_data->cnm_peso > 0 ? round($draft_data->cnm_peso / 2.20462262, 2) . ' Kg' : ''; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4" >Respiración por min.:</label>
                                                            <div class="span7 controls">
                                                                <input onkeydown="return validardosenteros(event, this)" type="text" name="txtrespiracion" id="txtrespiracion" class="nostyle soloNumeros" value="<?php echo is_object($draft_data) ? $draft_data->cnm_respiracion : ''; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row-fluid">
                                                <div class="span12">
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4">Temperatura (&deg;C):</label>
                                                            <div class="span7 controls">
                                                                <input onkeydown="return validardecimal(event, this)" type="text" extras="." name="txttemperatura" id="txttemperatura" class="nostyle soloDecimales" value="<?php echo is_object($draft_data) ? $draft_data->cnm_temperatura : ''; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4" >Saturación oxig. %:</label>
                                                            <div class="span7 controls">
                                                                <input onkeydown="return validarentero(event, this)" onblur="justnum($(this).val(),'txtsatoxig');" type="text" name="txtsatoxig" id="txtsatoxig" class="nostyle soloNumeros" value="<?php echo is_object($draft_data) ? number_format($draft_data->cnm_saturacion_oxigeno) : ''; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row-fluid">
                                                <div class="span12">
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4" >Talla mts:</label>
                                                            <div class="span7 controls">
                                                                <input onkeydown="return validardosdecimales(event, this)" type="text" name="txttalla" id="txttalla" class="nostyle soloDecimales" value="<?php echo is_object($draft_data) ? $draft_data->cnm_talla : ''; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4" >Tensión art mmHg:</label>
                                                            <div class="span7 controls">
                                                                <div class="span7">
                                                                    <select name="sentido" id="sentido" class="nostyle">
                                                                        <?php echo $condicion_medida; ?>
                                                                    </select> 
                                                                </div>
                                                                <?php $tn = is_object($draft_data) && $draft_data->cnm_tension_arterial != "" ? explode("/", $draft_data->cnm_tension_arterial) : ["",""]; ?>
                                                                <div class="span2" style="margin-left: 10px;">
                                                                    <input type="text" name="txttension_syst" id="txttension_syst" class="nostyle" maxlength="3" placeholder="sbp" value="<?php echo $tn[0]; ?>">
                                                                </div>
                                                                <div class="span1"><input type="text" class="text tables-input-show tables-input" readonly value="/" style="font-size: 18pt;"></div>
                                                                <div class="span2" >
                                                                    <input type="text" name="txttension_dias" id="txttension_dias" class="nostyle" maxlength="3" placeholder="dbp" value="<?php echo $tn[1]; ?>">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row-fluid">
                                                <div class="span12">
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4" >Cintura abdominal cm:</label>
                                                            <div class="span7 controls">
                                                                <input onkeydown="return validarentero(event, this)"  type="text" name="txtcintura" id="txtcintura" class="nostyle" value="<?php echo is_object($draft_data) ? $draft_data->cnm_cintura_abdominal : ''; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4" >Frec. por min.:</label>
                                                            <div class="span7 controls">
                                                                <input onkeydown="return validarentero(event, this)" type="text" name="txtcardiaca" id="txtcardiaca" class="nostyle" value="<?php echo is_object($draft_data) ? $draft_data->cnm_frecuencia_cardiaca : ''; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row-fluid">
                                                <div class="span12">
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4" >IMC:</label>
                                                            <div class="span7 controls">
                                                                <input onkeydown="return validardosdecimales(event, this)" type="text" name="txtimpc" id="txtimpc" class="nostyle soloDecimales" value="<?php echo is_object($draft_data) ? $draft_data->cnm_imc : ''; ?>">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row-fluid">
                                                <div class="span12">
                                                    <hr style="background-color: silver; height: 1px;">
                                                </div>
                                            </div>
                                            <div class="row-fluid">
                                                <div class="span12">
                                                    <div class="row-fluid">
                                                        <label class="form-label span4" id="label_historial">Historia clínica:</label>
                                                        <div class="span12 controls" style="margin-left: 0px;">
                                                            <textarea rows="9" id="txahistorial" name="txahistorial" style="width: 100%;" class="nostyle"><?php echo (is_object($draft_data) && $draft_data->cnm_historial_clinico) ? $draft_data->cnm_historial_clinico : $fecha_larga . ":\n"; ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php if ($es_chequeo): ?>
                                <div class="form-actions" style="text-align:center;margin-top: 7%;">
                                    <button class="btn btn-success iconic-icon-checkmark white" id="btn_guardar_chequeo"> Guardar y volver a la lista</button>                            
                                </div>                                
                            <?php else: ?>
                            <button type="button" style="float:right; display:inline-block;" class="btn iconic-icon-arrow-right" id="boton_siguiente" onclick="saltar_tab('tab_adiagnostico', 100);"> Continuar</button>
                            <?php endif ?>
                            <br><br>
                        </div>
                        <!-- //////////////////////////////////fin pestaña principal//////////////////////////////////////////////////////////// -->
                        <!-- //////////////////////////////////inicio pestaña segunda//////////////////////////////////////////////////////////// -->
                        <div id="diagnostico" class="tab-pane fade iframe" style="margin-left:20px;" iframe="0">
                            <div class="row-fluid">
                                <div class="span12">
                                    <div class="box">
                                        <div class="title"  style="border:0px;"></div>
                                        <div class="content" style="border:0px solid red;">
                                            <div class="form-row row-fluid">
                                                <div class="span12">
                                                    <div class="row-fluid">
                                                        <label class="span12">Diagnóstico y Plan a seguir</label>
                                                    </div>
                                                </div>
                                                <div class="span12">
                                                    <hr style="background-color: silver; height: 1px;">
                                                </div>
                                                <div class="span12">
                                                    <div class="row-fluid">
                                                        <label class="form-label span4" id="label_diagnostico">Diagnóstico: (2000)</label>
                                                        <div class="span12 controls">
                                                            <textarea rows="6" name="txadiagnostico" id="txadiagnostico" maxlength="2000"><?php echo is_object($draft_data) ? $draft_data->cnm_diagnostico : ''; ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="span12">
                                                    <div class="row-fluid">
                                                        <label class="form-label span4" id="label_plan">Plan a seguir:</label>
                                                        <div class="span12 controls">
                                                            <textarea rows="6" name="txaplan" id="txaplan" ><?php echo is_object($draft_data) ? $draft_data->cnm_plan_seguir : ''; ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>                                                
                                                <div class="span12">
                                                    <div class="row-fluid">
                                                        <label class="span12" id="label_preautorizacion">Pre-autorización de examenes y estudios de gabinete: (2000)</label>
                                                        <div class="span12 controls">
                                                            <textarea rows="6" name="txtpreautorizacion" id="txtpreautorizacion" maxlength="2000"><?php echo is_object($draft_data) ? $draft_data->cnm_pre_autorizacion_examen : ''; ?></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>                            
                            <button type="button" style="float:right; display:inline-block;" class="btn iconic-icon-arrow-right" id="boton_siguiente" onclick="saltar_tab('tab_receta', 100);"> Continuar</button>                            
                            <button type="button" id="regreso1" style="float:left; display:inline-block;" class="btn iconic-icon-arrow-left" onclick="saltar_tab('tab_gchekeo', 100);"> Anterior</button>
                            <br><br>
                        </div> 
                        <!-- //////////////////////////////////fin pestaña segunda//////////////////////////////////////////////////////////// -->
                        <!-- //////////////////////////////////inicio pestaña tercera//////////////////////////////////////////////////////////// -->
                        <div id="receta" class="tab-pane fade iframe" style="margin-left:20px;" iframe="0">
                            <div class="row-fluid">
                                <div class="span12">
                                    <div class="box">
                                        <div class="title"  style="border:0px;"></div>
                                        <div class="content" style="border:0px solid red;">
                                            <div class="form-row row-fluid">
                                                <div class="row-fluid">
                                                    <label>Recetas</label>
                                                </div>
                                                <div class="span12"><hr style="background-color: silver; height: 1px;"></div>
                                                <div class="span12">
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4">Medicamento:</label>
                                                            <div class="span7 controls" style="margin-left: 3%;">
                                                                <input type="hidden" name="slcmedicamento" id="slcmedicamento" class="nostyle">
                                                                <input type="hidden" name="medicamento_nombre" id="medicamento_nombre" value="">
                                                            </div>&nbsp;&nbsp;&nbsp;
                                                            <button class="btn plus fancy_modal" type="button" id="agregar_medicamento" href="<?= base_url("modulo_medico/med_mantenimientos/agregar_medicamentos/1"); ?>">+</button>
                                                        </div>
                                                    </div>                                            
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4">Dosis:</label>
                                                            <div class="span7 controls" style="margin-left: 3%;">
                                                                <textarea id="dosis" name="dosis"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="span12">
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4">Presentación:</label>
                                                            <div class="span7 controls" style="margin-left: 3%;">
                                                                <input type="text" name="presentacion" id="presentacion" value="" readonly>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4">Comentarios:</label>
                                                            <div class="span7 controls" style="margin-left: 3%;">
                                                                <textarea id="comentarios" name="comentarios"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="span12">
                                                    <div class="span6">
                                                        <div class="row-fluid">
                                                            <label class="form-label span4">Cantidad:</label>
                                                            <div class="span7 controls" style="margin-left: 3%;">
                                                                <input type="text" name="cantidad" id="cantidad" class="soloDecimales">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="span12">
                                                    <button class="btn btn-success agregar_medicamento" type="button">Agregar</button>
                                                </div>
                                            </div>
                                            <div class="span12"></div>
                                            <div class="row-fluid">
                                                <table class="responsive table table-bordered contenedor">
                                                    <thead>
                                                        <th>Medicamentos</th>
                                                        <th>Presentación</th>
                                                        <th>Cantidad</th>
                                                        <th>Dosis</th>
                                                        <th>Comentarios</th>
                                                        <th>Acciones</th>
                                                    </thead>
                                                    <tbody id ="table_medicamentos">
                                                        <?php if (is_array($draft_recetas) && count($draft_recetas) > 0): ?>
                                                                <?php foreach ($draft_recetas as $receta): ?>
                                                                    <tr>
                                                                        <td>
                                                                            <label><?php echo $receta["art_nombre"]; ?></label>
                                                                            <input type="hidden" name="txtmedicamento[]" value="<?php echo $receta["rct_id_art"]; ?>" class="txtmedicamento">
                                                                        </td>
                                                                        <td>
                                                                            <label><?= isset($receta["ppr_nombre"]) ? $receta["ppr_nombre"]: '' ; ?></label>
                                                                            <input type="hidden" name="txtpresentacion[]" value="<?php echo $receta["ppr_nombre"]; ?>" class="text tables-input-show tables-input selects-text">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="txtcantidad[]" value="<?php echo $receta["rct_cantidad"]; ?>" class="text tables-input-show tables-input selects-text">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="txtdosis[]" value="<?php echo $receta["rct_dosis"]; ?>" class="text tables-input-show tables-input selects-text">
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="txtcomentariomed[]" value="<?php echo $receta["rct_comentario"]; ?>" class="text tables-input-show tables-input selects-text">
                                                                        </td>
                                                                        <td>
                                                                            <button type="button" class="btn btn-danger btn-mini eliminar_tr2" style="float:left;height:30px;width:50px;"><span class="wpzoom-trashcan"></span></button>
                                                                        </td>
                                                                    </tr>
                                                                <?php endforeach; ?>
                                                        <?php endif; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="row-fluid"><label id="medicamentos_agregados" style="color:blue" value=""></label></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="button" style="float:right; display:inline-block;" class="btn iconic-icon-arrow-right" id="boton_siguiente" onclick="saltar_tab('tab_examenes', 100);"> Continuar</button>                            
                            <button type="button" id="regreso1" style="float:left; display:inline-block;" class="btn iconic-icon-arrow-left" onclick="saltar_tab('tab_adiagnostico', 100);"> Anterior</button>
                            <br><br>
                        </div> 
                        <!-- //////////////////////////////////fin pestaña tercera//////////////////////////////////////////////////////////// -->
                        <!-- //////////////////////////////////inicio pestaña cuartas//////////////////////////////////////////////////////////// -->
                        <div id="examenes" class="tab-pane fade iframe" style="margin-left:20px;" iframe="0">
                            <div class="row-fluid">
                                <div class="span12">
                                    <div class="box">
                                        <div class="title"  style="border:0px;"></div>
                                        <div class="content" style="border:0px solid red;">
                                            <div class="form-row row-fluid">
                                                <div class="row-fluid">
                                                    <label>Examenes y anexos</label>
                                                </div>
                                                <div class="span12"><hr style="background-color: silver; height: 1px;"></div>
                                                <div class="span12">
                                                    <div class="span6">
                                                        <label class="form-label span3">Comentario:</label>
                                                        <div class="row-fluid">
                                                            <div class="span8 controls">
                                                                <textarea rows="6" name="txtcomentario" id="txtcomentario"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="span6">
                                                        <div class="form-field-box odd  span12">
                                                            <label class="form-label span3" >
                                                                <!-- Fotografía:          -->
                                                            </label>
                                                            <input name="files" id="files" class="file_text" type="hidden" readonly="readonly"> 
                                                            <input type="hidden" value="assets" name="nombreCarpeta" id="foto_add" >
                                                            <div id="upload-foto" class="centrar_div" style="width:30% !important; position: relative; margin-top: -11px;" value="archivos">
                                                                <p class='file'>
                                                                    <div id='ingrese_nombre' style='display:none;'></div>
                                                                    <button type='button'  id='btn_foto_inventario'  class='files btn' style="position:relative;"><span class="icomoon-icon-picture"></span> Agregar Fotografía</button>
                                                                    <div id='ingrese_imagen' style='display:none;'>
                                                                    </div>
                                                                    <input type='hidden' id='id_actu' name='id_actu'>
                                                                </p>
                                                            </div>
                                                            <table id="previews_foto" style="width:auto!important;" class="centrar"></table><br>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="span12">
                                                    <a class="btn btn-info" id="agregar">Agregar</a>
                                                </div>
                                                <div class="span12"></div>
                                                <div class="class12">
                                                    <table class="responsive table table-bordered contenedor">
                                                        <thead>
                                                            <th>Fecha/Hora</th>
                                                            <th>Comentario</th>
                                                            <th>Anexo</th>
                                                            <th>Acciones</th>
                                                        </thead>
                                                        <tbody id="anexo_previews">
                                                            <?php if (is_array($draft_anexos) && count($draft_anexos) > 0): ?>
                                                                <?php foreach ($draft_anexos as $anexo): ?>
                                                                    <tr>
                                                                        <td>
                                                                            <label><?php echo formatear_fecha('d/m/Y H:i', $anexo["aci_fecha_registro"]); ?></label>
                                                                            <input type="hidden" name="AnexoCot[]" value="<?php echo $anexo["aci_id"]; ?>" />
                                                                            <input type="hidden" name="txtruta[]" value="<?php echo $anexo["aci_url"]; ?>" />
                                                                            <input type="hidden" name="txtfecha[]" value="<?php echo $anexo["aci_fecha_registro"]; ?>" />
                                                                            <input type="hidden" name="txtcomentarioanex[]" value="<?php echo $anexo["aci_comentario"]; ?>" />
                                                                        </td>
                                                                        <td>
                                                                            <input type="text" name="txtcomentario[]" value="<?php echo $anexo["aci_comentario"]; ?>" class="text tables-input-show tables-input selects-text">
                                                                        </td>
                                                                        <td>
                                                                            <label><a class="fancy_modal" href="<?php echo base_url($anexo["aci_url"]); ?>"><?php echo $anexo["aci_nombre"]; ?></a></label>
                                                                            <input type="hidden" name="txtnombreanex[]" value="<?php echo $anexo["aci_nombre"]; ?>" class="txtnombreanex">
                                                                        </td>
                                                                        <td>
                                                                            <button type="button" class="btn btn-danger btn-mini eliminar_imagen" custom="<?php echo $anexo["aci_url"]; ?>" style="float:left;height:30px;width:50px;"><span class="wpzoom-trashcan"></span></button>
                                                                        </td>
                                                                    </tr>
                                                                <?php endforeach; ?>
                                                            <?php endif; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="button" style="float:right; display:inline-block;" class="btn iconic-icon-arrow-right" id="boton_siguiente" onclick="saltar_tab('tab_constancia', 100);"> Continuar</button>                            
                            <button type="button" id="regreso1" style="float:left; display:inline-block;" class="btn iconic-icon-arrow-left" onclick="saltar_tab('tab_receta', 100);"> Anterior</button>
                            <br><br>
                        </div> 
                        <!-- //////////////////////////////////fin pestaña cuarta//////////////////////////////////////////////////////////// -->
                        <!-- //////////////////////////////////inicio pestaña quinta//////////////////////////////////////////////////////////// -->
                        <div id="constancia" class="tab-pane fade iframe" style="margin-left:20px;" iframe="0">
                            <div class="row-fluid">
                                <div class="span12">
                                    <div class="box">
                                        <div class="title"  style="border:0px;"></div>
                                        <div class="content" style="border:0px solid red;">
                                            <div class="form-row row-fluid">
                                                <div class="span12">
                                                    <div class="row-fluid">
                                                        <label class="span12">Incapacidad / Constancia</label>
                                                    </div>
                                                </div>
                                                <div class="span12">
                                                    <hr style="background-color: silver; height: 1px;">
                                                </div>
                                                <div class="span12">
                                                    <div class="row-fluid">
                                                        <div class="span6">
                                                            <label class="form-label span4" >Nombre:</label>
                                                            <div class="span10 controls">
                                                                <input type="text" name="txtNombreConstancia" value="<?php echo is_object($draft_data) && $draft_data->cnm_nombre_constancia ? $draft_data->cnm_nombre_constancia : $cita_medica[0]['nombre_paciente']; ?>" id="txtNombreConstancia" maxlength="100">
                                                            </div>
                                                        </div>
                                                        <div class="span6">
                                                            <label class="form-label span4" >Fecha:</label>
                                                            <div class="span10 controls">
                                                                <input type="text" name="txtFechaConstancia" id="txtFechaConstancia"  value="<?php echo is_object($draft_data) && $draft_data->cnm_fecha_constancia ? formatear_fecha('d-m-Y', $draft_data->cnm_fecha_constancia) : date('d-m-Y'); ?>" maxlength="15">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="span12">
                                                    <div class="row-fluid">
                                                        <label>Detalle de constancia/incapacidad:</label>
                                                        <div class="span12 controls">
                                                            <textarea rows="10" name="txtConstancia" id="txtConstancia" maxlength="5000"><?php echo is_object($draft_data) ? $draft_data->cnm_detalle_constancia : ''; ?></textarea>
                                                        </div>
                                                    </div>
                                                </div> 
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="button" id="regreso1" style="float:left; display:inline-block;" class="btn iconic-icon-arrow-left" onclick="saltar_tab('tab_examenes', 100);"> Anterior</button>
                            <div class="form-actions" style="text-align:center;margin-top: 7%;">
                                <?php if ($modulo > 0) { ?>
                                    <button class="btn btn-success iconic-icon-checkmark white btnmodalguardar" type="button" id="btnmodalguardar" value="1"> Guardar y volver a la lista</button>
                                <?php } else { ?>
                                    <button class="btn btn-success iconic-icon-checkmark white btn_enviar" type="submit" name="btnCrear" value="1"> Guardar y volver a la lista</button>
                                <?php } ?>
                                <!-- <button class="btn btn-success iconic-icon-checkmark white btn_enviar" type="submit" name="btnCrear" value="2"> Guardar y volver a la lista</button>
                                <button type="button" id="cancelar" class="btn btn-danger icomoon-icon-cancel white" onclick="javascript:window.history.back();" > Cancelar</button> -->
                                <br><br>
                                <div style="width:94%">
                                    <p>Campos con asterisco en <font color='FE2E2E'>rojo</font> son requeridos</p>
                                </div>
                            </div>
                        </div> 
                        <!-- //////////////////////////////////fin pestaña quinta//////////////////////////////////////////////////////////// -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<script type="text/javascript">
    function validardosdecimales(e, field) {
        key = e.keyCode ? e.keyCode : e.which
        // backspace
        if (key == 8 || key == 9 || key == 46 || key == 37 || key == 38 || key == 39 || key == 40) {
            return true;
        }
        // 0-9
        if ((key >= 48 && key <= 57) || (key >= 96 && key <= 105)) {
            if (field.value == "") return true
                regexp = /.[0-9]{2}$/
            return !(regexp.test(field.value))
        }
        // .
        if (key == 110 || key == 190) {
            if (field.value == "") return false
                regexp = /^[0-9]+$/
            return regexp.test(field.value)
        }
        // other key
        return false        
    }

    function validardecimal(e, field) {
        key = e.keyCode ? e.keyCode : e.which
        // backspace
        if (key == 8 || key == 9 || key == 46 || key == 37 || key == 38 || key == 39 || key == 40) {
            return true;
        }
        // 0-9
        if ((key >= 48 && key <= 57) || (key >= 96 && key <= 105)) {
            if (field.value == "") return true
                regexp = /.[0-9]{1}$/
            return !(regexp.test(field.value))
        }
        // .
        if (key == 110 || key == 190) {
            if (field.value == "") return false
                regexp = /^[0-9]+$/
            return regexp.test(field.value)
        }
        // other key
        return false 
    }

    function validarentero(e, field) {
        key = e.keyCode ? e.keyCode : e.which
        // backspace
        if (key == 8 || key == 9 || key == 46 || key == 37 || key == 38 || key == 39 || key == 40) {
            return true;
        }
        // 0-9
        if ((key >= 48 && key <= 57) || (key >= 96 && key <= 105)) {
            if (field.value == "") return true
                regexp = /.[0-9]{2}$/
            return !(regexp.test(field.value))
        }
        // other key
        return false
    }

    function validardosenteros(e, field) {
        key = e.keyCode ? e.keyCode : e.which
        // backspace
        if (key == 8 || key == 9 || key == 46 || key == 37 || key == 38 || key == 39 || key == 40) {
            return true;
        }
        // 0-9
        if ((key >= 48 && key <= 57) || (key >= 96 && key <= 105)) {
            if (field.value == "") return true
                regexp = /.[0-9]{1}$/
            return !(regexp.test(field.value))
        }
        // other key
        return false
    }

    jQuery(function($){
        // $("#txttension").mask("999/99?9");  //LO QUE VA DESPUES DEL "?" ES OPCIONAL PUEDE IR O NO
        $("#txttension_syst").mask("99?9", { completed:function(){ $( "#txttension_dias" ).focus().select(); } });
        $("#txttension_dias").mask("99?9");
    });

    function justnum(valor, idfield) {
        nv = valor.replace(/[^0-9]/g,'');
        $("#"+idfield).val(nv);
    }
</script>
<script type="text/javascript" src="<?= base_url() ?>js/modulo_medico/med_procesos/agregar_consulta.js" ></script>
<?php if (isset($existe_borrador) && $existe_borrador): ?>
    <script type="text/javascript">
        $(document).ready(function() {
            crear_alerta('success', 'Datos Restaurados', 'Hemos restaurado los datos que dejaste sin enviar.');

            <?php if (is_array($draft_recetas) && count($draft_recetas) > 0): ?>
                obtenerNumFilas();
            <?php endif; ?>
            // Actualizar contadores de caracteres
            var cantidad = 2000 - $('#txadiagnostico').val().length;
            $("#label_diagnostico").text('Diagnóstico: ('+cantidad+')');
            var cantidad = 2000 - $('#txtpreautorizacion').val().length;
            $("#label_preautorizacion").text('Pre-autorización de examenes y estudios de gabinete: ('+cantidad+')');
            // Actualizar select sentido
            <?php if (is_object($draft_data) && $draft_data->cnm_id_cdm): ?>
                $('#sentido').val('<?php echo $draft_data->cnm_id_cdm; ?>');
            <?php endif; ?>
        });
    </script>
<?php endif; ?>