<?php
if (count($archivos) > 0):
    foreach ($archivos as $row):
        $creador = (!empty($row['emp_nombre'])) ? $row['emp_nombre'] . ' ' . $row['emp_apellido'] : "Empleado no relacionado";
        ?>
        <tr>
            <td><?php echo $row['arh_codigo']; ?></td>
            <td><?php echo $row['arh_nombre']; ?></td>
            <td><?php echo $row['tpa_nombre']; ?></td>
            <td><?php echo $creador; ?></td>
            <td><?php echo formatear_fecha('d-m-Y H:i a', $row['arh_fecha']); ?></td>
            <td><?php echo ($row['arh_estado'] == 1) ? "Activo" : "Inactivo"; ?></td>
            <td>
                <div class="tools">
                    <div class="btn-group">
                        <button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button>
                        <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                        <ul class="dropdown-menu">
                            <?php if ($permisos['permite_editar']) { ?>
                                <li>
                                    <a href="<?php echo base_url(); ?>modulo_gestion_documental/procesos/editar_archivo/<?php echo $row['arh_id']; ?>">
                                        <span aria-hidden="true" class="icomoon-icon-pencil-5"></span>Editar
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($permisos['permite_eliminar'] && $row['arh_estado'] == 1) { ?>
                                <li>
                                    <a href="<?php echo base_url(); ?>modulo_gestion_documental/procesos/cambiar_estado_archivo/<?php echo $row['arh_id']; ?>/0" class="ver-accion-modales">
                                        <span aria-hidden="true" class="icomoon-icon-arrow-down-3"></span>Desactivar
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($permisos['permite_eliminar'] && $row['arh_estado'] == 0) { ?>
                                <li>
                                    <a href="<?php echo base_url(); ?>modulo_gestion_documental/procesos/cambiar_estado_archivo/<?php echo $row['arh_id']; ?>/1" class="ver-accion-modales">
                                        <span aria-hidden="true" class="icomoon-icon-arrow-up-3"></span>Activar
                                    </a>
                                </li>
                            <?php } ?>
                            <?php if ($permisos['permite_ver']) { ?>
                                <li>
                                    <a href="<?php echo base_url(); ?>modulo_gestion_documental/procesos/bitacora_archivo/<?php echo $row['arh_id']; ?>" class="ver-accion-modal">
                                        <span aria-hidden="true" class="icomoon-icon-search-3"></span>Bitacora
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                </div>
            </td>
        </tr>
        <?php
    endforeach;
else:
    ?>
<?php endif; ?>