<!-- Estilos FilePond -->
<link href="<?= base_url() ?>libraries/filepond/filepond.css" rel="stylesheet">
    <!-- Estilos personalizados -->
<style>
        /* Contenedor del uploader */
        #uploader {
            height: 100px;
            max-width: 100%;
            margin: 20px auto;
            padding: 20px;
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            border: 2px dashed #007bff;
        }

        .uploader{
            display: none;
        }

        .filepond--root {
            border-radius: 10px;
            background: #f9f9f9;
            transition: all 0.3s ease-in-out;
        }

        .filepond--root:hover {
            border-color: #0056b3;
            background: #eef6ff;
        }

        .filepond--panel-root {
            background-color: transparent;
        }

        .filepond--drop-label {
            font-size: 1rem;
            color: #333;
            font-weight: 500;
        }

        .filepond--label-action {
            color: #007bff;
            font-weight: 800;
            text-decoration: none;
        }

        .filepond--file {
            border-radius: 8px;
        }

        .filepond--item {
            position: relative;
            z-index: 1; 
        }

        .filepond--panel {
            border-radius: 8px;
        }


        .filepond--file-action-button {
            color: white !important;
        }

        .overlay-box {
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: #C4C6C799;
            z-index: 999;
            display: none;
            justify-content: center;
            align-items: center;
            font-weight: bold;
            font-size: 18px;
            color: #007bff;
            text-align: center;
        }

        .box-wrapper {
            position: relative;
        }

        #tiempoProceso {
            font-size: 14px;
            margin-top: 15px;
            font-style: italic;
            color: #444;
        }
        /* Colores del box dinámicos según carga */
.estado-bajo {
  border: 2px solid #28a745 !important;
}

.estado-moderado {
  border: 2px solid #ffc107 !important;
}

.estado-alto {
  border: 2px solid #dc3545 !important;
}

.estado-header-bajo h4 {
  background: #28a745 !important;
  color: white;
}

.estado-header-moderado h4 {
  background: #ffc107 !important;
  color: black;
}

.estado-header-alto h4 {
  background: #dc3545 !important;
  color: white;
}

    </style>

    <!-- Gauge CSS & JS -->
<script src="https://cdn.jsdelivr.net/npm/raphael@2.3.0/raphael.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/justgage@1.3.5/justgage.min.js"></script>

<div class="row-fluid">
        <div class="span12">
 <div class="box" id="boxRecursos">
                    <div class="title" id="titleRecursos">
                        <h4>
                            <span>
                                 🖥️ Recursos del servidor (<strong id="os-name">Detectando...</strong>)
                            </span>
                        </h4>
                        <a class="minimize" href="#">
                            Minimize
                        </a>
                    </div>
                    <div class="content">


                    <div style="display: flex; justify-content: center; gap: 40px; margin-top: 20px;">
                      <div>
                        <div id="gaugeCPU" style="width: 200px; height: 160px;"></div>
                        <p style="text-align: center; font-weight: bold;">CPU</p>
                      </div>
                      <div>
                        <div id="gaugeRAM" style="width: 200px; height: 160px;"></div>
                        <p style="text-align: center; font-weight: bold;">MEMORIA RAM</p>
                      </div>
                    </div>
                    <div id="estado-carga" style="margin-top: 30px; text-align: center;">
                      <div id="mensaje-estado-carga" style="display: inline-block; font-size: 16px; font-weight: bold; padding: 10px 20px; border-radius: 10px; background-color: #e9ecef; color: #333;">
                        Analizando carga del sistema...
                      </div>
                    </div>

                    </div>
                    </div>
                </div>
            </div>



    <div class="row-fluid">
        <div class="span12">

            <form id="frm-archivo">
                <div class="form-row row-fluid">
                    <div class="span6">
                        <div id="progresoLogs">
                        </div>
                    </div>
                    <div class="span6 nshowbar" style="display:none;">
                        <div class="barra-progreso-texto" id="barraProgresoTexto"><b>Procesados 0 de N</b></div>
                        <div class="barra-progreso-visual" id="barraProgresoVisual">
                            <div class="barra-progreso" id="barraProgreso"></div>
                        </div>
                        <div id="tiempoProceso"></div>
                    </div>

                </div>
                
                <br><br>
                <div class="box-wrapper">
                <div class="overlay-box" id="overlayBox"><h1 style="color:white;background: #0069B1;padding: 10px;border-radius: 10px;">Procesando...</h1></div>
                <div class="box" >
                    <div class="title" >
                        <h4>
                            <span class="icon16 icomoon-icon-equalizer-2">
                            </span>
                            <span>
                                Carga Masiva de Archivos
                            </span>
                        </h4>
                        <a class="minimize" href="#" style="display: none;">
                            Minimize
                        </a>
                    </div>
                    <div class="content">
                        <div class="form-row row-fluid">
                            <p>
                                <div class="form-row row-fluid">
                                                    <div class="span12">

                                                        <div class="form-row row-fluid">
                                                        <p>
                                                            <div id="uploader">
                                                                <input class="filepond" type="file" data-type="file" data-ubication='#input_name' id="filepondGaleria" name="file[]" multiple/>
                                                            </div>
                                                        </p>

                                                        <input type="hidden" name="input_name" id="input_name">
                                                    </div>

                                                </div>
                                            </div>

                            </p>
                            <p>
                                <div class="span12">
                                  <div class="row-fluid">
                                    <label class="form-label span4" for="normal">Carpeta destino: <b style="color:red">*</b></label></label>
                                      <div class="controls span8">
                                          <select onchange="$('#slc_destino_error').text('');" id="slc_destino" name="slc_destino" placeholder="Seleccione" style="width:100%;"  class="nostyle" >
                                            <option></option>
                                            <?php foreach ($ubicaciones as $ubicacion): ?>
                                                <option value="<?= $ubicacion['uba_id']; ?>">
                                                    <?= $ubicacion['full_path']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                      </select>
                                      <small id="slc_destino_error" style="color:red;margin-top: 20px;display: block;"></small>
                                      </div>
                                    </div>
                                  </div>
                            </p>
                        </div>
                        <div align="left">
                            <br>
                                Campos con asterisco en
                                <font color="FE2E2E">
                                    rojo
                                </font>
                                son requeridos
                            </br>
                        </div>
                        <div class="form-actions" style="text-align: center;">
                            <button class="btn btn-success" name="btnCrear" type="submit" value="1">
                                <span class="icon16 icomoon-icon-checkmark white">
                                </span>
                                Iniciar proceso
                            </button>
                            <a class="btn btn-danger btn-cancelar" href="http://localhost/erp/modulo_gestion_documental/procesos/archivos" id="">
                                <span class="icon16 icomoon-icon-cancel-2 white">
                                </span>
                                Cancelar
                            </a>
                        </div>
                    </div>
                </div>
                </div>
                
            </form>
    
        </div>
    </div>

    <style>
    .log-item {
        display: flex;
        align-items: center;
        margin-bottom: 5px;
        font-size: 14px;
    }

    .log-spinner {
        width: 16px;
        height: 16px;
        margin-right: 8px;
        border: 2px solid #ccc;
        border-top: 2px solid #007bff;
        border-radius: 50%;
        animation: spin 0.7s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Estilo visual moderno para barra de progreso */
    .barra-progreso-texto {
        font-weight: bold;
        font-size: 16px;
        margin-bottom: 10px;
        color: #222;
    }

    .barra-progreso-visual {
        width: 100%;
        background: #e6e6e6;
        height: 25px;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: inset 0 1px 3px rgba(0,0,0,0.1);
        margin-bottom: 20px;
    }

    .barra-progreso {
        height: 100%;
        width: 0%;
        background: linear-gradient(90deg, #28a745 0%, #218838 100%);
        transition: width 0.4s ease-in-out;
    }

    .log-check {
        width: 16px;
        height: 16px;
        margin-right: 8px;
        color: green;
        font-size: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    #os-info strong {
      color: #007bff;
    }

</style>


    <script src="<?= base_url() ?>libraries/filepond/filepond.min.js"></script>
    <script src="<?= base_url() ?>libraries/filepond/filepond-plugin-file-validate-type.js"></script>

<script>
  let gaugeCPU = new JustGage({
    id: "gaugeCPU",
    value: 0,
    min: 0,
    max: 100,
    title: "CPU",
    label: "%",
    levelColors: ["#90ee90", "#ffc107", "#dc3545"]
  });

  let gaugeRAM = new JustGage({
    id: "gaugeRAM",
    value: 0,
    min: 0,
    max: 100,
    title: "RAM",
    label: "%",
    levelColors: ["#90ee90", "#ffc107", "#dc3545"]
  });

  const eventSource = new EventSource(urlj+"modulo_gestion_documental/procesos/stream_recursos");

  eventSource.onmessage = function(event) {
  try {
    const limpio = event.data.replace(/^\uFEFF/, '');
    const data = JSON.parse(limpio);

    gaugeCPU.refresh(data.cpu);
    gaugeRAM.refresh(data.ram);

    if (document.getElementById("os-name").innerText === "Detectando...") {
      document.getElementById("os-name").innerText = data.os;
    }

    const cpu = data.cpu;
    const ram = data.ram;
    const estadoDiv = document.getElementById("mensaje-estado-carga");

    if (cpu < 60 && ram < 60) {
      estadoDiv.innerText = "✅ Carga baja: seguro realizar otra carga de archivos.";
      estadoDiv.style.backgroundColor = "#d4edda";
      estadoDiv.style.color = "#155724";
    } else if (cpu < 80 && ram < 80) {
      estadoDiv.innerText = "🟡 Carga moderada: puedes cargar archivos, pero con precaución.";
      estadoDiv.style.backgroundColor = "#fff3cd";
      estadoDiv.style.color = "#856404";
    } else if (cpu >= 90 || ram >= 90) {
      estadoDiv.innerText = "❌ Carga alta: espera a que finalicen otros procesos antes de cargar archivos.";
      estadoDiv.style.backgroundColor = "#f8d7da";
      estadoDiv.style.color = "#721c24";
    } else {
      estadoDiv.innerText = "⚠️ Carga elevada: considera esperar un poco antes de subir.";
      estadoDiv.style.backgroundColor = "#ffeeba";
      estadoDiv.style.color = "#856404";
    }

    const box = document.getElementById("boxRecursos");
const title = document.getElementById("titleRecursos");

    box.classList.remove("estado-bajo", "estado-moderado", "estado-alto");
    title.classList.remove("estado-header-bajo", "estado-header-moderado", "estado-header-alto");

    if (cpu < 60 && ram < 60) {
      // ✅ Carga baja
      box.classList.add("estado-bajo");
      title.classList.add("estado-header-bajo");
    } else if (cpu < 80 && ram < 80) {
      // 🟡 Carga moderada
      box.classList.add("estado-moderado");
      title.classList.add("estado-header-moderado");
    } else if (cpu >= 90 || ram >= 90) {
      // ❌ Carga alta
      box.classList.add("estado-alto");
      title.classList.add("estado-header-alto");
    } else {
      // ⚠️ Carga intermedia (si no entra en los anteriores)
      box.classList.add("estado-moderado");
      title.classList.add("estado-header-moderado");
    }


  } catch (e) {
    console.error("Error al parsear el stream:", event.data);
  }
};


  eventSource.onerror = function(err) {
    console.error("Error en conexión SSE:", err);
    eventSource.close();
  };
</script>

<script type="text/javascript">


    $(document).on("change", "#input_name", function(){
         let input_name = $(this).val();

         if (input_name == '') {

            $("#uploader").css("border","4px dashed #EB0303");
            $(".filepond--label-action").css("color","#EB0303");


        }else{

            $("#uploader").css("border","2px dashed #007bff");
            $(".filepond--label-action").css("color","#007bff");


        }

    })

    $(document).on("submit", "#frm-archivo", function(e){
    e.preventDefault();
    e.stopPropagation();

    let input_name = $("#input_name").val();
    let slc_destino = $("#slc_destino").val();

    if (input_name === '') {
        $("#uploader").css("border","4px dashed #EB0303");
        $(".filepond--label-action").css("color","#EB0303");
        return false;
    }

    if (slc_destino === '') {
        $('#slc_destino_error').html("Campo requerido");
        return false;
    }

    const urlStream = urlj + "modulo_gestion_documental/procesos/procesarDocumentoMasivo";
    const formData = new FormData(this);

    $("#progresoLogs").show().html(`<p><b>Iniciando proceso...</b></p><br>`);
    $(".nshowbar").show();

    let horaInicio = new Date();
    let intervalCronometro;

    $("#overlayBox").fadeIn();

    $("#tiempoProceso").html(`🕓 Inicio: <b>${horaInicio.toLocaleTimeString()}</b><br>🕓 Duración total: <span id="cronometro">00:00:00</span>`);

    // Iniciar cronómetro
    intervalCronometro = setInterval(() => {
        const ahora = new Date();
        const diffMs = ahora - horaInicio;
        const duracionTexto = new Date(diffMs).toISOString().substr(11, 8);
        $("#cronometro").text(duracionTexto);
    }, 1000);

    fetch(urlStream, {
        method: "POST",
        body: formData
    })
    .then(response => {
        const reader = response.body.getReader();
        const decoder = new TextDecoder();
        let buffer = "";

        function leer() {
            reader.read().then(({ done, value }) => {
                if (done) {
                    clearInterval(intervalCronometro);
                    const horaFin = new Date();
                    const duracionSegundos = Math.floor((horaFin - horaInicio) / 1000);
                    const duracionTexto = new Date(horaFin - horaInicio).toISOString().substr(11, 8);

                    $("#overlayBox").fadeOut();

                    $("#progresoLogs .log-spinner").last().replaceWith('<div class="log-check">✅</div>');
                    $("#progresoLogs").append("<b style='color:green'>✅ Finalizado</b>");

                    $("#tiempoProceso").append(`<br>🕓 Finalizó: <b>${horaFin.toLocaleTimeString()}</b>`);
                    $("#tiempoProceso").append(`<br>🔚 Tiempo total: <b>${duracionTexto} (${duracionSegundos}s)</b>`);

                    FilePond.find(document.querySelector(".filepond")).removeFiles();
                    $("#input_name").val("");
                    $("#slc_destino").val("").change();
                    return;
                }

                buffer += decoder.decode(value, { stream: true });
                const partes = buffer.split("\n");
                buffer = partes.pop(); 

                partes.forEach(linea => {
                    if (!linea.trim()) return;
                    try {
                        const limpio = linea.replace(/^\uFEFF/, '').replace(/^data:\s*/, '');
                        const obj = JSON.parse(limpio);

                        if (obj.procesados) {
                            $("#barraProgresoTexto b").html(obj.procesados);
                            const match = obj.procesados.match(/(\d+)\s+de\s+(\d+)/);
                            if (match) {
                                const actual = parseInt(match[1], 10);
                                const total = parseInt(match[2], 10);
                                const porcentaje = Math.floor((actual / total) * 100);
                                $("#barraProgreso").css("width", porcentaje + "%");
                            }
                        } else if (obj.evento) {
                            $("#progresoLogs .log-spinner").each(function () {
                                $(this).replaceWith('<div class="log-check">✅</div>');
                            });

                            const logHtml = `
                                <div class="log-item">
                                    <div class="log-spinner"></div>
                                    <div>${obj.evento}</div>
                                </div>
                            `;
                            $("#progresoLogs").append(logHtml);
                            $("#progresoLogs").scrollTop($("#progresoLogs")[0].scrollHeight);
                        }
                    } catch (e) {
                        console.warn("No se pudo parsear:", linea);
                    }
                });

                leer();
            });
        }

        leer();
    })
    .catch(err => {
        clearInterval(intervalCronometro);
        $("#overlayBox").fadeOut();
        $("#progresoLogs").append("<br><b style='color:red'>❌ Error:</b> " + err.message);
    });
});



    $("select").select2();

    FilePond.setOptions({
    fileValidateTypeDetectType: (source, type) => new Promise((resolve, reject) => {
        const name = source.name.toLowerCase();
        if (name.endsWith('.rar')) {
            resolve('application/x-rar-compressed');
        } else if (name.endsWith('.zip')) {
            resolve('application/zip');
        } else {
            resolve(type); 
        }
    })
});

    FilePond.registerPlugin(FilePondPluginFileValidateType);

    document.querySelectorAll(".filepond").forEach(function (inputElement) {

        let ubication = inputElement.dataset.ubication;
        let type = inputElement.dataset.type;

        const options = {
            credits: false,
            allowMultiple: false,
            maxFiles: 1,
            server: {
                process: {
                    url: urlj+"modulo_gestion_documental/procesos/uploadGeneralFile",
                    method: 'POST',
                    onload: (response) => handleUploadSuccess(response),
                    onerror: handleUploadError
                },
                revert: {
                    url: urlj+"modulo_gestion_documental/procesos/deleteGeneralFile",
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    onload: (response) => handleRevertSuccess(response, ubication),
                    onerror: handleRevertError,
                    data: (uniqueFileId) => prepareRevertData(uniqueFileId)
                }
            },
            labelIdle: '<h1 class="filepond--label-action">¡Atencion! <small>Toma en cuenta que tu archivo archivo ZIP o RAR debe contener solo una carpeta con el nombre <b>Imagenes</b> y dentro de ella contener el archivo json con el nombre <b>Mapeo</b> con los datos delas imagenes contenidas.</small> <h1 class="filepond--label-action">Seleccionar Archivo </h1></h1>',
            labelFileProcessingError: 'Archivo inválido',
            onprocessfile: (error, file) => processFile(error, file, ubication)
        };

        // Crear la instancia de FilePond
        FilePond.create(inputElement, options);
    });

    // Función de éxito en subida
    function handleUploadSuccess(response) {
        try {
            let data = JSON.parse(response);
            return JSON.stringify({
                NombreTemporal: data.NombreTemporal,
                NombreReal: data.NombreReal
            });
        } catch (error) {
            console.error('Error parsing upload response:', error);
            return error.message;
        }
    }

    // Manejo de errores
    function handleUploadError(error) {
        console.error('Error during file upload:', error);
    }

    function handleRevertSuccess(response, selector) {
        try {
            let data = JSON.parse(response);
            if (data.status === 'success') {
                $(selector).val("");
                return data.message;
            } else {
                console.error(data.message);
                return data.message;
            }
        } catch (error) {
            console.error('Error parsing revert response:', error);
            return error.message;
        }
    }

    function handleRevertError(error) {
        console.error('Error during file revert:', error);
    }

    function prepareRevertData(uniqueFileId) {
        let file = FilePond.find(uniqueFileId);

        if (file && file.serverId) {
            let serverResponse = JSON.parse(file.serverId);

            return JSON.stringify({
                NombreTemporal: serverResponse.NombreTemporal
            });
        }
        return null;
    }

    function processFile(error, file, selector) {
        if (!error && file && file.serverId) {
            let serverResponse = JSON.parse(file.serverId);
            let nombreTemporal = serverResponse.NombreTemporal;
            let nombreReal = serverResponse.NombreReal;

            $(selector).val(nombreTemporal);

            $("#uploader").css("border","2px dashed #007bff");
            $(".filepond--label-action").css("color","#007bff");

        }
    }


</script>