<?php $colores = array("#1E90FF","#228B22","#2E8B57","#2F4F4F","#32CD32","#FF6347","#FF69B4","#FF7F50","#FF8C00","#FFA07A","#7FFF00","#800000","#800080","#808000","#808080","#8A2BE2","#8B0000","#8B008B","#8B4513","#9370DB","#9400D3","#9932CC","#9ACD32","#A0522D","#A52A2A","#ADFF2F","#B22222","#B8860B","#BA55D3","#BC8F8F","#C71585","#CD5C5C","#CD853F","#D2691E","#D2B48C","#DAA520","#DB7093","#DC143C","#DEB887","#E9967A","#F08080","#F4A460","#FA8072","#FF0000","#FF00FF","#FF00FF","#FF1493","#FF4500","#3CB371","#40E0D0","#4169E1","#4682B4","#483D8B","#48D1CC","#4B0082","#556B2F","#5F9EA0","#6495ED","#663399","#696969","#6A5ACD","#6B8E23","#708090","#778899","#7B68EE","#7B68EE","#7CFC00","#000080","#00008B","#0000CD","#0000FF","#008080","#006400","#008000","#008B8B","#00BFFF","#00CED1","#00FF00","#191970","#FFA500"); ?>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Filtrar Usuario(s)</span>
                </h4>
                <a href="#" class="maximize" >Maximize</a>
            </div>
            <div class="content" style="display: none;">
                <form id="consultores" class="horizontal" method="POST" action="<?= base_url('modulo_eventos/procesos/cartelera_eventos') ?>">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span8">
                                <div class="row-fluid">
                                    <label class="form-label span4">Consultor(es):</label>
                                    <div class="span8 controls">
                                        <select id="slcConsultor" name="slcConsultor[]" multiple placeholder="Seleccione" class="nostyle">
                                            <?php echo str_replace('<option value="0">Seleccione</option>', '<option value=""></option>', $slcConsultor); ?>
                                        </select>
                                    </div>
                                    <div style="color:red;" id="slcConsultor_error"></div>
                                </div> 
                            </div>
                            <div class="span4">
                                <div class="row-fluid">
                                    <div class="span2"><input type="hidden" name="user_jefe" id="user_jefe" value="<?= $es_jefe ?>"></div>
                                    <button class="btn"><span class="icomoon-icon-search-2"> Consultar</span></button>                                
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="box calendar">
            <div class="title">
                <h4>
                    <span class="icon16 icomoon-icon-calendar"></span>
                    <span>Calendario de eventos (<?php echo $datos_usuario["emp_nombre"]." ". $datos_usuario["emp_apellido"]; ?>)</span>
                </h4>
            </div>
            <div class="content noPad"> 
                <div id="calendar">
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    // document ready function
    $(document).ready(function() {

        $('select').select2();

        $("#consultores").validate({
            ignore:'',
            rules: {
                'slcConsultor[]': {
                    minlength: 1,
                    required: function (element) {
                        if (parseInt($("#user_jefe").val()) > 0) {
                            return false;
                        } else {
                            return true;
                        }
                    }
                }
            }, 
            messages: { 
                slcConsultor: "Campo requerido"    
            }, 
            ignore: ".select2-container",
            errorPlacement: function (error, element) {          
                wait.close();
                var nombre = $(element).attr("id");
                $('#'+nombre+'_error').html(error);
            },    
            submitHandler: function(form){
                wait.start();
                form.submit();
            } 
        });

        $(function () {
            var date = new Date();
            var d = date.getDate();
            var m = date.getMonth();
            var y = date.getFullYear();
            //alert(d);           alert(m);          alert(y);
            //front page calendar
            //#ED7A53 color no confirmados
            //#88BBC8 si confirmados
            $('#calendar').fullCalendar({
                //isRTL: true,
                //theme: true,
                header: {
                    left: 'title,today',
                    center: 'prev,next',
                    right: 'month,agendaWeek,agendaDay'
                },
                buttonText: {
                    prev: '<span class="icon24 icomoon-icon-arrow-left-2"></span>',
                    next: '<span class="icon24 icomoon-icon-arrow-right-2"></span>'
                },
                editable: false,
                droppable: false, // this allows things to be dropped onto the calendar !!!
                events: [
                    <?php 
                    $n = count($registros);
                    if ( $n > 0) {
                        $array_eventos = array();
                        $i = 0;
                        $k = 1;
                        $eve_id = $registros[0]['evn_id_usu'];
                        $rnd_color = $colores[0]; //PARA ALEATORIOS:// "#".str_pad(dechex(mt_rand(0, 0xFFFFFF)), 6, '0', STR_PAD_LEFT); // PERO SALEN ALGUNOS MUY CLAROS ///
                        foreach ($registros as $evento) {
                            $i++;
                            $asunto = str_replace(array("'",'"'), '', $evento["evn_asunto"] . ' (' . $evento["creador"] . ')'); // SE AGREGA QUIEN CREO EL EVENTO
                            // SE DEJA EL MISMO COLOR POR USUARIO QUE CREO EL EVENTO SI CAMBIAR DE USUARIO PASA AL SIGUIENTE COLOR DEL ARRAY //////////////
                            if ($evento['evn_id_usu'] != $eve_id) {
                                $eve_id = $evento['evn_id_usu']; //SUSTITUIR EL "USUARIO VIGENTE"//
                                $rnd_color = $colores[$k];//PARA ALEATORIOS: // "#".str_pad(dechex(mt_rand(0, 0xFFFFFF)), 6, '0', STR_PAD_LEFT); // PERO SALEN UNOS MUY CLAROS
                                $k++;
                            }
                            $color_evento = $rnd_color;//ANTES: // ($evento["usv_confirmado"] == 1) ? "#88BBC8" : "#ED7A53";// SOLO CAMBIABA SI LOS USUARIOS PARTICIPANTES CONFIRMABAN 
                            $array_fecha= explode("-", formatear_fecha("Y-m-d",$evento["evn_fecha_evento"]));
                            $array_fecha_fin= ($evento["evn_fecha_evento_fin"])? explode("-", formatear_fecha("Y-m-d",$evento["evn_fecha_evento_fin"])):explode("-", formatear_fecha("Y-m-d",$evento["evn_fecha_evento"]));
                            $link_evento = base_url("modulo_eventos/procesos/visualizar_evento/".$evento["evn_id"]);
                            $todo_eldia = (trim($evento["evn_hora_evento"]) != "" )? "false":"true";
                            if (trim($evento["evn_hora_evento"]) != "") {
                                $array_hora = explode(":", $evento["evn_hora_evento"]);
                                $fecha_evento = intval($array_fecha[0]).", ".intval($array_fecha[1]-1).", ".intval($array_fecha[2]).", ".intval($array_hora[0]).", ".intval($array_hora[1]); 
                            } else {
                                $fecha_evento = intval($array_fecha[0]).", ".intval($array_fecha[1]-1).", ".intval($array_fecha[2]);
                            }
                            if (trim($evento["evn_hora_evento_fin"]) != "") {
                                $array_hora = explode(":", $evento["evn_hora_evento_fin"]);
                                $fecha_evento_fin = intval($array_fecha_fin[0]).", ".intval($array_fecha_fin[1]-1).", ".intval($array_fecha_fin[2]).", ".intval($array_hora[0]).", ".intval($array_hora[1]); 
                            } else {
                                $fecha_evento_fin = intval($array_fecha_fin[0]).", ".intval($array_fecha_fin[1]-1).", ".intval($array_fecha_fin[2]);
                            }
                            ?>
                            {
                                title: ' <?php echo $asunto; ?>',
                                start: new Date(<?php echo $fecha_evento; ?>),
                                end: new Date(<?php echo $fecha_evento_fin; ?>),
                                color: '<?php echo $color_evento; ?>',
                                allDay: <?php echo $todo_eldia; ?>,
                                url: '<?php echo $link_evento; ?>'
                            }
                            <?php echo ($n!=$i) ? "," : "";
                        }
                    } ?>
                ]
            });
        });        

        $("body").on('click', '.fc-content a', function(event) {
            url_action = $(this).attr("href");
            id_evento = $(this).attr("href").split("/").pop();
            if (id_evento > 0 ) {
                //preguntar si corresponde a evento 
                event.preventDefault();
                $.fancybox({
                    'width': '90%',
                    'height' : '80%',
                    'autoScale': true,
                    openEffect  : 'elastic',
                    closeEffect : 'elastic',
                    'href':  $(this).attr('href'),
                    'title': "DETALLE DE EVENTO",
                    'type': 'iframe'
                });
            }
            //visualizar_evento(); //cargar el fancybox
        });
    });

    function verificar_eventos() {
        $(".fc-content a").addClass("ver_evento");
        $(".fc-content a").attr("target","_blank");
    }
</script>
<script type="text/javascript" src="<?= base_url() ?>js/modulo_eventos/procesos/cartelera_eventos.js" ></script>
