<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel' && $contador == 0) {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 100% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel' && $contador == 0) { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Estado de Cuenta Corriente
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
$periodo = "";
if ($fecha_inicio != null && $fecha_fin != null) {

    $fecha_inicio = $fecha_inicio;
    $fecha_fin = $fecha_fin;

    $periodo = $fecha_inicio . "/" . $fecha_fin;
}

//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$pagina = null;
$total_general = 0;
$total_cargos = 0;
$total_abonos = 0;
$saldo_actual = $saldo_inicial;

foreach ($reporte as $row) :
    if ($tipo_reporte != '') {
        if ($registros == 1) {
?>
            <table class="">
                <tr>
                    <td colspan="6"></td>
                </tr>
                <tr>
                    <td style="text-align: left;width: 12%;"><b>Proveedor:</b></td>
                    <td colspan="2" style="text-align: left;"><?php echo $proveedor; ?></td>
                    <td style="width: 10%;"><b>Período:</b></td>
                    <td colspan="2" style="text-align: left;"><?php echo $periodo; ?></td>
                </tr>
            </table>
            <div></div>
        <?php } ?>
        <?php if ($i == 1) {
        ?>
            <table class="tabla">
                <thead>
                    <tr>
                        <th>Fecha Doc.</th>
                        <th>Tipo Doc.</th>
                        <th>No. Doc.</th>
                        <!-- <th># Partida</th> -->
                        <th>Saldo</th>
                        <th>Pagos</th>
                        <th>Saldo</th>
                    </tr>
                </thead>
                <tbody>
                <?php
            }
        }

        $nombre = $row['prv_apellido'];
        if ($row['prv_tipo_pers'] == 1) {
            $nombre = $row['prv_nombre'] . " " . $row['prv_apellido'];
        }

        $total_general += $row['saldo'];

        if ($registros == 1) {
                ?>

                <?php if ($tipo_reporte == '') { ?>
                    <tr>
                        <td style="display:none;"><?php echo $registros; ?></td>
                        <td class="noborder-right"><b>Proveedor:</b></td>
                        <!-- <td class="noborder-right"></td> --><?php //Suprimir columna Partida  
                                                                    ?>
                        <td style="font-weight: bold;"><?php echo $proveedor; ?></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td></td>
                    </tr>
                <?php } ?>


                <tr>
                    <?php if ($tipo_reporte == '') : ?>
                        <td style="display:none;"><?php echo $registros; ?></td>
                    <?php endif; ?>
                    <?php if ($tipo_reporte == '') : ?>
                        <td class="noborder-right" style="font-weight: bold;">Balance Inicial</td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td class="noborder-right"></td>
                        <td></td><!-- <td></td> -->
                        <td><?php echo $simbolo . number_format($saldo_inicial, 2); ?></td>
                    <?php else : ?>
                        <td colspan="5" style="font-weight: bold;text-align: left;">Balance Inicial</td>
                        <td><?php echo $simbolo . number_format($saldo_inicial, 2); ?></td>
                    <?php endif; ?>
                </tr>
            <?php
        }

        /* Se valida el doc y el cheque que se haya generado para presentar la información
             * Tipo: 1 = Cargos (Docs), 2 = Abonos (Cheques)
             */
        $tipo = $row['tipo_doc'];
        $monto_cargo = null;
        $monto_abono = null;
        if ($row['tipo'] == 1) {
            $saldo_actual += $row['monto'];
            $monto_cargo = $row['monto'];
            $total_cargos += $monto_cargo;
        } else if ($row['tipo'] == 2) {
            $saldo_actual -= $row['monto'];
            $monto_abono = $row['monto'];
            $total_abonos += $monto_abono;
        } else if ($row['tipo'] == 3) {
            $saldo_actual -= $row['monto'];
            $monto_abono = $row['monto'];
            $total_abonos += $monto_abono;
        } else if ($row['tipo'] == 4) {
            $saldo_actual -= $row['monto'];
            $monto_abono = $row['monto'];
            $total_abonos += $monto_abono;
        }

        $total_general = $saldo_actual;
            ?>
            <tr>
                <?php if ($tipo_reporte == '') : ?>
                    <td style="display:none;"><?php echo $registros; ?></td>
                <?php endif; ?>
                <td><?php echo date('d-m-Y', strtotime($row['fecha_doc'])); ?></td>
                <td><?php echo $row['tipo_doc']; ?></td>
                <td><?php echo $row['num_doc']; ?></td>
                <!-- <td><?php // echo $row['']; //Suprimida Dic/2020
                            ?></td> -->
                <td><?php echo ($monto_cargo != null) ? '$' . number_format($monto_cargo, 2) : null; ?></td>
                <td><?php echo ($monto_abono != null) ? '$' . number_format($monto_abono, 2) : null; ?></td>
                <td><?php echo $simbolo . number_format($saldo_actual, 2); ?></td>
            </tr>
            <?php
            $i++;
            ?>
            <?php
            //Si la variable tipo reporte existe se declara la tabla
            if ($tipo_reporte != '' && $tipo_reporte == 'pdf') {
                if ($i == 33 && $pagina == null) {
                    $pagina = 1;
            ?>
                </tbody>
            </table>
            <br style="page-break-after: always;" />
        <?php
                    $i = 1;
                } else if ($i == 38 && $pagina != null) {
        ?>
            </tbody>
            </table>
            <br style="page-break-after: always;" />
        <?php
                    $i = 1;
                } else if ($registros == count($reporte)) {
        ?>
            <tr>
                <td colspan="3" style="font-weight: bold;text-align: right;">Total</td>
                <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_cargos, 2); ?></td>
                <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_abonos, 2); ?></td>
                <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_general, 2); ?></td>
            </tr>
            </tbody>
            </table>
    <?php
                }
            }
            $registros++;
        endforeach;
        //Se agrega el monto total al final de la tabla
        if ($tipo_reporte == '' && $registros > 1) {
    ?>
    <tr>
        <td style="display:none;"><?php echo $registros; ?></td>
        <td class="noborder-right"></td>
        <!-- <td class="noborder-right"></td> -->
        <td class="noborder-right"></td>
        <td style="font-weight: bold;text-align:right;">Total</td>
        <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_cargos, 2); ?></td>
        <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_abonos, 2); ?></td>
        <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_general, 2); ?></td>
    </tr>
<?php
        } else if ($tipo_reporte == 'excel' && $registros > 1) {
?>
    <tr>
        <td style="font-weight: bold;text-align: right;" colspan="3">Total</td>
        <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_cargos, 2); ?></td>
        <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_abonos, 2); ?></td>
        <td style="font-weight: bold;"><?php echo $simbolo . number_format($total_general, 2); ?></td>
    </tr>
<?php } ?>