<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .tabla .nostyle {
            border: 1px solid white !important;
        }

        .nostyle td {
            border: 1px solid white;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Cuentas por pagar detallado
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$pagina = null;
$proveedor_inicial = $reporte[0]['prv_id'];
$total_montos = 0;
$total_abonos = 0;
$total_saldos = 0;
$total_proveedor_monto = 0;
$total_proveedor_abono = 0;
$total_proveedor_saldo = 0;
foreach ($reporte as $key => $row) :
    if ($tipo_reporte != '') {
        if ($registros == 1) {
?>
            <table class="">
                <tr>
                    <td colspan="2"></td>
                </tr>
                <tr>
                    <td style="text-align: left;width: 12%;"><b>Proveedor:</b></td>
                    <td style="text-align: left;"><?php echo $proveedor; ?></td>
                </tr>
            </table>
            <div></div>
        <?php } ?>
        <?php if ($i == 1) {
        ?>
            <table class="tabla">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Proveedor</th>
                        <th>Tipo Doc.</th>
                        <th>Num. Doc.</th>
                        <th>Fecha Doc.</th>
                        <th>Fecha Vencimiento</th>
                        <th>Días Plazo</th>
                        <th>Días Vencido</th>
                        <th>Monto</th>
                        <th>Abono</th>
                        <th>Saldo</th>
                    </tr>
                </thead>
                <tbody>
            <?php
        }
    }

    $nombre = $row['prv_apellido'];
    if ($row['prv_tipo_pers'] == 1) {
        $nombre = $row['prv_nombre'] . " " . $row['prv_apellido'];
    }

    $total_proveedor_monto += $row['dpv_total'];
    $total_proveedor_abono += $row['dpv_monto_abono'];
    $total_proveedor_saldo += $row['dpv_monto_pendiente'];
            ?>
            <tr>
                <?php if ($tipo_reporte == '') : ?>
                    <td style="display:none;"><?php echo $registros; ?></td>
                <?php endif; ?>
                <td class="text"><?php echo $row['prv_codigo']; ?></td>
                <td><?php echo $nombre; ?></td>
                <td><?php echo $row['tipo_doc']; ?></td>
                <td><?php echo $row['dpv_numero_documento']; ?></td>
                <td><?php echo date('d-m-Y', strtotime($row['dpv_fecha_documento'])); ?></td>
                <td><?php echo date('d-m-Y', strtotime($row['dpv_fecha_vencimiento'])); ?></td>
                <td><?php echo intval($row['prv_dias_plazo']); ?></td>
                <td><?php echo intval($row['dias_vencido']); ?></td>
                <td><?php echo $simbolo . number_format($row['dpv_total'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['dpv_monto_abono'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['dpv_monto_pendiente'], 2); ?></td>
            </tr>
            <?php
            //Se valida el proveedor siguiente para agregar el total.
            //if (isset($reporte[$key + 1]['prv_id'])):
            if ($proveedor_inicial != $reporte[$key + 1]['prv_id'] || $reporte[$key + 1]['prv_id'] == null) :
            ?>
                <tr>
                    <?php
                    //Si es impresión se agrega colspan a total
                    if ($tipo_reporte != '') {
                    ?>
                        <td colspan="8" style="font-weight: bold;text-align: right;">Total Proveedor</td>
                    <?php } else { ?>
                        <?php if ($tipo_reporte == '') : ?>
                            <td style="display:none;"><?php echo $registros; ?></td>
                        <?php endif; ?>
                        <td colspans="8" class="noborder-right"></td>
                        <td colspans="8" class="noborder-right"></td>
                        <td colspans="8" class="noborder-right"></td>
                        <td colspans="8" class="noborder-right"></td>
                        <td colspans="8" class="noborder-right"></td>
                        <td colspans="8" class="noborder-right"></td>
                        <td colspans="8" class="noborder-right"></td>
                        <td colspans="8" style="font-weight: bold;text-align: right;">Total Proveedor</td>
                    <?php } ?>
                    <td><?php echo $simbolo . number_format($total_proveedor_monto, 2); ?></td>
                    <td><?php echo $simbolo . number_format($total_proveedor_abono, 2); ?></td>
                    <td><?php echo $simbolo . number_format($total_proveedor_saldo, 2); ?></td>
                </tr>

                <?php if ($tipo_reporte != '' && $tipo_reporte == 'pdf' && $registros != count($reporte)) { ?>
                    <tr class="nostyle">
                        <td class="nostyle" style="border: 1px solid white;border-left:1px solid black;" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white" colspans="8"></td>
                        <td class="nostyle" style="border: 1px solid white;border-right:1px solid black;" colspans="8"></td>
                    </tr>
                    <tr class="nostyle">
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;border-left:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;"></td>
                        <td colspans="8" style="border: 1px solid white;border-bottom:1px solid black;border-right:1px solid black;"></td>
                    </tr>

                <?php } ?>
            <?php
                $proveedor_inicial = $reporte[$key + 1]['prv_id'];


                $total_montos += $total_proveedor_monto;
                $total_abonos += $total_proveedor_abono;
                $total_saldos += $total_proveedor_saldo;

                $total_proveedor_monto = 0;
                $total_proveedor_abono = 0;
                $total_proveedor_saldo = 0;
                $i += 3;
            endif;
            //endif;
            $i++;
            ?>
            <?php
            //Si la variable tipo reporte existe se declara la tabla
            if ($tipo_reporte != '' && $tipo_reporte == 'pdf') {
                if ($i == 25 && $pagina == null) {
                    $pagina = 1;
            ?>
                </tbody>
            </table>
            <br style="page-break-after: always;" />
        <?php
                    $i = 1;
                } else if ($i == 30 && $pagina != null) {
        ?>
            </tbody>
            </table>
            <br style="page-break-after: always;" />
        <?php
                    $i = 1;
                } else if ($registros == count($reporte)) {
        ?>
            <tr>
                <td colspan="8" style="font-weight: bold;text-align: right;">Total Cartera</td>
                <td><?php echo $simbolo . number_format($total_montos, 2); ?></td>
                <td><?php echo $simbolo . number_format($total_abonos, 2); ?></td>
                <td><?php echo $simbolo . number_format($total_saldos, 2); ?></td>
            </tr>
            </tbody>
            </table>
    <?php
                }
            }
            $registros++;
        endforeach;
        //Se agrega el monto total al final de la tabla
        if ($tipo_reporte == '') {
    ?>
    <tr>
        <?php if ($tipo_reporte == '') : ?>
            <td style="display:none;"><?php echo $registros; ?></td>
        <?php endif; ?>
        <td class="noborder-right"></td>
        <td class="noborder-right"></td>
        <td class="noborder-right"></td>
        <td class="noborder-right"></td>
        <td class="noborder-right"></td>
        <td class="noborder-right"></td>
        <td class="noborder-right"></td>
        <td style="font-weight: bold;text-align: right">Total Cartera</td>
        <td><?php echo $simbolo . number_format($total_montos, 2); ?></td>
        <td><?php echo $simbolo . number_format($total_abonos, 2); ?></td>
        <td><?php echo $simbolo . number_format($total_saldos, 2); ?></td>
    </tr>
<?php
        } else if ($tipo_reporte == 'excel') {
?>
    <tr>
        <td colspan="8" style="font-weight: bold;text-align: right;">Total Cartera</td>
        <td><?php echo $simbolo . number_format($total_montos, 2); ?></td>
        <td><?php echo $simbolo . number_format($total_abonos, 2); ?></td>
        <td><?php echo $simbolo . number_format($total_saldos, 2); ?></td>
    </tr>
<?php } ?>