<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Antigüedad de saldos
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>



<?php
//Si la variable tipo reporte existe se declara la tabla
$i = 1;
$registros = 1;
$pagina = null;
$total_monto_sin_vencer     = 0;
$total_monto_rango_uno      = 0;
$total_monto_rango_dos      = 0;
$total_monto_rango_tres     = 0;
$total_monto_rango_cuatro   = 0;
$total_monto_rango_cinco    = 0;
$total_monto_total          = 0;

foreach ($reporte as $row) :
    if ($tipo_reporte != '' && $registros == 1) {
?>
        <table class="">
            <tr>
                <td colspan="2"></td>
            </tr>
            <tr>
                <td style="text-align: left;width: 12%;"><b>Proveedor:</b></td>
                <td style="text-align: left;"><?php echo $proveedor; ?></td>
            </tr>
        </table>
        <div></div>

        <table class="tabla">
            <thead>
                <tr>
                    <th>Código</th>
                    <th>Proveedor</th>
                    <th>Sin vencer</th>
                    <th>0 - 30</th>
                    <th>31 - 60</th>
                    <th>61 - 90</th>
                    <th>91 - 120</th>
                    <th> > 120</th>
                    <th>Saldo</th>
                </tr>
            </thead>
            <tbody>
            <?php
        }
        $nombre = $row['prv_apellido'];

        if ($row['prv_tipo_pers'] == 1) {
            $nombre = $row['prv_nombre'] . " " . $row['prv_apellido'];
        }
        $vencido = ($row['vencidos'] > 0 && $tipo_reporte == "") ? ' style="background-color: #ff8080;" ' : '';

        if ($row['monto_total'] <> 0) :
            ?>
                <tr noBr="true" <?php echo $vencido; ?>>
                    <td class="text"><?php echo $row['prv_codigo']; ?></td>
                    <td><?php echo $nombre; ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($row['monto_sin_vencer'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($row['monto_rango_uno'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($row['monto_rango_dos'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($row['monto_rango_tres'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($row['monto_rango_cuatro'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($row['monto_rango_cinco'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($row['monto_total'], 2); ?></td>
                </tr>
            <?php
            $total_monto_sin_vencer     += $row['monto_sin_vencer'];
            $total_monto_rango_uno      += $row['monto_rango_uno'];
            $total_monto_rango_dos      += $row['monto_rango_dos'];
            $total_monto_rango_tres     += $row['monto_rango_tres'];
            $total_monto_rango_cuatro   += $row['monto_rango_cuatro'];
            $total_monto_rango_cinco    += $row['monto_rango_cinco'];
            $total_monto_total          += $row['monto_total'];
        endif;

        $registros++;
    endforeach;
    if ($tipo_reporte != '') {
            ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="2">TOTAL</td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($total_monto_sin_vencer, 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($total_monto_rango_uno, 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($total_monto_rango_dos, 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($total_monto_rango_tres, 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($total_monto_rango_cuatro, 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($total_monto_rango_cinco, 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($total_monto_total, 2); ?></td>
                </tr>
            </tfoot>
        </table>
    <?php
    }
    ?>