<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Agenda de Pago
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: center;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 10;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <th>Proveedor</th>
                <th>Tipo Doc.</th>
                <th>Num. Doc.</th>
                <th>Monto</th>
                <th>Abono</th>
                <th>Saldo</th>
                <th>A Pagar</th>
                <th>Fecha de Vencimiento</th>
                <th>Dias Plazo</th>
                <th>Dias Vencido</th>
                <th>Tipo de Pago</th>
            </tr>
        </thead>
        <tbody id="tbl_contenedor">
            <?php
            if (count($reporte_agenda) > 0) {
                foreach ($reporte_agenda as $key => $value) {
                    $dias_vencido   = 0;
                    $tipoPago       = '';
                    if (formatear_fecha('Y-m-d', $value['dpv_fecha_vencimiento']) < date('Y-m-d')) {
                        $fecha_1    = new DateTime(formatear_fecha('Y-m-d', $value['dpv_fecha_vencimiento']));
                        $fecha_2    = new DateTime(date('Y-m-d'));
                        $diferencia = $fecha_1->diff($fecha_2);
                        $dias_vencido = $diferencia->days;
                    }

                    if ($value['frp_nombre'] == '') {
                        $tipoPago = ($value['agp_tipo']  == 1) ? "Cheque" : "Nota de Abono";
                    } else {
                        $tipoPago = $value['frp_nombre'];
                    }
            ?>
                    <tr>
                        <td>
                            <?php echo ($value['prv_tipo_pers'] == 1) ? $value['prv_nombre'] . ' ' . $value['prv_apellido'] : $value['prv_apellido']; ?>
                        </td>

                        <td>
                            <?php echo $value['tif_nombre']; ?>
                        </td>

                        <td>
                            <?php echo $value['dpv_numero_documento']; ?>
                        </td>

                        <td>
                            <?php echo $simbolo . number_format($value['dpv_total'], 2); ?>
                        </td>

                        <td>
                            <?php echo $simbolo . number_format($value['dpv_monto_abono'], 2); ?>
                        </td>

                        <td>
                            <?php echo $simbolo . number_format($value['dpv_monto_pendiente'], 2); ?>
                        </td>

                        <td>
                            <?php echo $simbolo . number_format($value['agp_apagar'], 2); ?>
                        </td>

                        <td>
                            <?php echo date('d-m-Y', strtotime($value['dpv_fecha_vencimiento'])); ?>
                        </td>

                        <td>
                            <?php echo intval($value['prv_dias_plazo']); ?>
                        </td>

                        <td>
                            <?php echo $dias_vencido; ?>
                        </td>

                        <td>
                            <?php echo $tipoPago; ?>
                        </td>
                    </tr>
            <?php  }
            } else {
                echo '
        <tr>
            <td style="text-align: center;" colspan="11">No se encontraron registros</td>
        </tr>';
            }
            ?>
        </tbody>
        </table>