<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=rpt_seg_ctas_cobrar.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
?>
    <meta charset="utf-8" />
    <table>
        <tr>
            <td align="center" colspan="7">
                <h4><?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h4>
            </td>
            <td></td>
        </tr>
        <tr>
            <td align="center" colspan="7"><b>Reporte de Seguimiento de Cuentas por Cobrar</b></td>
            <td style="text-align: right;"><?php echo $this->tank_auth->get_username(); ?></td>
        </tr>
        <tr>
            <td style="text-align: right;" colspan="8">
                <?php echo $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y H:i:s a'); ?>
            </td>
        </tr>
    </table>
<?php
}
$p = ($tipo == 'pdf') ? true : false;
?>
<table class="responsive dynamicTable display table table-bordered dataTable" cellpadding="1" id="datagried" name="datagried" border="1" <?= ($p) ? 'style="font-size: 7pt;"' : ''; ?>>
    <thead id="cabezera">
        <tr style="font-weight: bold; text-align: center;">
            <th <?= ($p) ? 'width="9%"' : ''; ?>>Cliente</th>
            <th <?= ($p) ? 'width="8%"' : ''; ?>>Vendedor</th>
            <th <?= ($p) ? 'width="8%"' : ''; ?>>Cobrador</th>
            <th <?= ($p) ? 'width="6%"' : ''; ?>>Tipo Factura</th>
            <th <?= ($p) ? 'width="6%"' : ''; ?>>Núm. Factura</th>
            <th <?= ($p) ? 'width="6%"' : ''; ?>>Fecha Factura</th>
            <th <?= ($p) ? 'width="6%"' : ''; ?>><?= ($p) ? "Fecha Vcto." : "Fecha Vencimiento"; ?></th>
            <th <?= ($p) ? 'width="4%"' : ''; ?>>Días Plazo</th>
            <th <?= ($p) ? 'width="5%"' : ''; ?>>Días Vencido</th>
            <th <?= ($p) ? 'width="6%"' : ''; ?>><?= ($p) ? "Fecha Seguimto." : "Fecha Seguimiento"; ?></th>
            <th <?= ($p) ? 'width="9%"' : ''; ?>>Observaciones</th>
            <th <?= ($p) ? 'width="6%"' : ''; ?>><?= ($p) ? "Fecha Pmo. Pago" : "Fecha Próximo Pago"; ?></th>
            <th <?= ($p) ? 'width="7%"' : ''; ?>>Monto <?= $simbolo ?></th>
            <th <?= ($p) ? 'width="7%"' : ''; ?>>Abono <?= $simbolo ?></th>
            <th <?= ($p) ? 'width="7%"' : ''; ?>>Saldo <?= $simbolo ?></th>
        </tr>
    </thead>
    <tbody id="contenedor">
        <?php
        $saldos = $abonos = $total = 0;
        if (count($registros) > 0) {
            foreach ($registros as $f) {
                $saldos += $f['fac_total'];
                $abonos += $f['fac_monto_abono'];
                $total += $f['saldo_pendiente'];
                $fff = ($tipo != '') ? '' : '<span style="display: none;">' . formatear_fecha('Ymd', $f['fac_fecha_fact']) . '</span>';
                $ffv = ($tipo != '') ? '' : '<span style="display: none;">' . formatear_fecha('Ymd', $f['fac_fecha_vencimiento']) . '</span>';
                $ffs = ($tipo != '') ? '' : '<span style="display: none;">' . formatear_fecha('Ymd', $f['fac_fecha_seguimiento_cobro']) . '</span>';
                $ffp = ($tipo != '') ? '' : '<span style="display: none;">' . formatear_fecha('Ymd', $f['fac_fecha_prox_cobro']) . '</span>';
        ?>
                <tr nobr="true">
                    <td <?= ($p) ? 'width="9%"' : ''; ?>><?php echo $f['cli_codigo'] . ' - ' . $f['cliente']; ?></td>
                    <td <?= ($p) ? 'width="8%"' : ''; ?>><?php echo (trim($f['vendedor']) != "") ? $f['ven_codigo'] . ' - ' . $f['vendedor'] : ''; ?></td>
                    <td <?= ($p) ? 'width="8%"' : ''; ?>><?php echo trim($f['cobrador'], ', '); ?></td>
                    <td <?= ($p) ? 'width="6%"' : ''; ?>><?php echo $f['tif_abreviacion']; ?></td>
                    <td <?= ($p) ? 'width="6%"' : ''; ?>><?php echo $f['serie'] . ' - ' . $f['fac_numero']; ?></td>
                    <td <?= ($p) ? 'width="6%"' : ''; ?>><?php echo $fff . formatear_fecha('d-m-Y', $f['fac_fecha_fact']); ?></td>
                    <td <?= ($p) ? 'width="6%"' : ''; ?>><?php echo $ffv . formatear_fecha('d-m-Y', $f['fac_fecha_vencimiento']); ?></td>
                    <td <?= ($p) ? 'width="4%"' : ''; ?> style="text-align: right;"><?php echo ($f['plazo_pago'] < 0) ? '' : $f['plazo_pago']; ?></td>
                    <td <?= ($p) ? 'width="5%"' : ''; ?> style="text-align: right;"><?php echo ($f['dias_vencido'] < 0) ? '' : $f['dias_vencido']; ?></td>
                    <td <?= ($p) ? 'width="6%"' : ''; ?>><?php echo $ffs . formatear_fecha('d-m-Y', $f['fac_fecha_seguimiento_cobro']); ?></td>
                    <td <?= ($p) ? 'width="9%"' : ''; ?>><?php echo trim($f['fac_comentario_seguimiento']); ?></td>
                    <td <?= ($p) ? 'width="6%"' : ''; ?>><?php echo $ffp . formatear_fecha('d-m-Y', $f['fac_fecha_prox_cobro']); ?></td>
                    <td <?= ($p) ? 'width="7%"' : ''; ?> style="text-align: right;"><?php echo $f['fac_total']; ?></td>
                    <td <?= ($p) ? 'width="7%"' : ''; ?> style="text-align: right;"><?php echo $f['fac_monto_abono']; ?></td>
                    <td <?= ($p) ? 'width="7%"' : ''; ?> style="text-align: right;"><?php echo $f['saldo_pendiente']; ?></td>
                </tr>
            <?php  } ?>
            <?php } else {
            if ($tipo != '') {
            ?>
                <tr>
                    <td colspan="15" align="center" style="text-align: center;">No se encontraron registros</td>
                </tr>
        <?php
            }
        } ?>
    </tbody>
    <tfoot>
        <tr>
            <th colspan="12" style="text-align: right; font-weight: bold;">Totales</th>
            <th style="text-align: right; font-weight: bold;"><?= $simbolo ?><?php echo number_format($saldos, 2); ?></th>
            <th style="text-align: right; font-weight: bold;"><?= $simbolo ?><?php echo number_format($abonos, 2); ?></th>
            <th style="text-align: right; font-weight: bold;"><?= $simbolo ?><?php echo number_format($total, 2); ?></th>
        </tr>
    </tfoot>
</table>

<?php if ($tipo == "") { ?>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#datagried').dataTable({
                "bAutoWidth": false,
                "aLengthMenu": [
                    [10, 25, 50, -1],
                    [10, 25, 50, "Todos"]
                ]
            });
        });
    </script>
<?php } ?>