<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("content-disposition: attachment;filename=" . $filename . ".xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}
$total_efectivo = 0;
$total_cheque 	= 0;
$total_tarjeta 	= 0;
$total_transfer	= 0;
$total_otras 	= 0;
$total_general 	= 0;
$maximo = $this->gsatelite->get_parametro('SYS_MONTO_LAVADO_DINERO', 10000);
$font = ($tipo_reporte == 'pdf') ? 'style="font-size: 7px;"' : 'style="font-size: 12px;"';
$height = ($tipo_reporte == 'pdf') ? 'height="12px"' : '';

if ($tipo_reporte == 'excel') { //Datos del encabezado en excel
?>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="3">
					<h4>
						<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
						<br />
						Reporte de Lavado de Dinero
					</h4>
				</td>
			</tr>
		</table>
	</div>
<?php
}

if (count($clientes) > 0) :
	$i = 0;
?>
	<style type="text/css">
		.display {
			table-layout: fixed;
		}

		.esconder {
			overflow: hidden;
			white-space: nowrap;
			text-overflow: ellipsis;

		}

		.esconder:hover {
			overflow: visible;
			white-space: initial;
			cursor: pointer;
		}
	</style>
	<table class="responsive dynamicTable table table-bordered dataTable" id="datagried" <?= ($tipo_reporte != '') ? 'cellpadding="1"' : ''; ?> name="datagried" border="<?= ($tipo_reporte != '') ? 1 : 0; ?>" <?= $font ?>>
		<thead>
			<?php if ($tipo_reporte != '') : ?>
				<tr <?= $font ?>>
					<th colspan="2" width="30%" style="text-align: center;"><b>Codigo Cliente</b></th>
					<th colspan="7" width="70%" style="text-align: center;"><b>Acumulado</b></th>
				</tr>
			<?php endif ?>
			<tr>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="5%"' : ''; ?> style="text-align: center;"><b>Codigo</b></th>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="25%"' : ''; ?> style="text-align: center;"><b>Nombre</b></th>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="15%"' : ''; ?> style="text-align: center;"><b>Documento</b></th>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: center;"><b>Efectivo</b></th>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: center;"><b>Cheque</b></th>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: center;"><b>Tarjeta</b></th>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: center;"><b>Transferencias</b></th>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: center;"><b>Otras formas de pago</b></th>
				<th <?= ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?> style="text-align: center;"><b>Total</b></th>
			</tr>
		</thead>
		<tbody id="contenedor">
			<?php
			foreach ($clientes as $key => $value) :
				$fila_cheques  = ($value['cheque'] != '') ? $value['cheque'] : 0;
				$fila_transfe  = ($value['transferencia'] != '') ? $value['transferencia'] : 0;
				$fila_efectivo = ($value['efectivo'] != '') ? $value['efectivo'] : 0;
				$fila_tarjeta  = ($value['tarjetas'] != '') ? $value['tarjetas'] : 0;
				$fila_otras    = ($value['otros'] != '') ? $value['otros'] : 0;
				$fila_otras    += ($value['sin_detalle'] != '') ? $value['sin_detalle'] : 0;
				$total_fila    = $fila_efectivo + $fila_cheques + $fila_tarjeta + $fila_transfe + $fila_otras;
				if ($total_fila > $maximo) {
					$i++;
			?>
					<tr nobr="true">
						<td <?= ($tipo_reporte == 'pdf') ? 'width="5%"' : ''; ?> <?= $height ?>><?= $value['cli_codigo'] ?></td>
						<td <?= ($tipo_reporte == 'pdf') ? 'width="25%"' : ''; ?> class="esconder"><?= $value['cli_nombre'] ?></td>
						<td <?= ($tipo_reporte == 'pdf') ? 'width="15%"' : ''; ?> class="esconder"><?php echo $value["facturas"]; ?></td>
						<td <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: right;"><?php echo $simbolo . number_format($fila_efectivo, 2); ?></td>
						<td <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: right;"><?php echo $simbolo . number_format($fila_cheques, 2); ?></td>
						<td <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: right;"><?php echo $simbolo . number_format($fila_tarjeta, 2); ?></td>
						<td <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: right;"><?php echo $simbolo . number_format($fila_transfe, 2); ?></td>
						<td <?= ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?> style="text-align: right;"><?php echo $simbolo . number_format($fila_otras, 2); ?></td>
						<td <?= ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?> style="text-align: right;"><?php echo $simbolo . number_format($total_fila, 2); ?></td>
					</tr>
				<?php
					$total_efectivo += $fila_efectivo;
					$total_cheque 	+= $fila_cheques;
					$total_tarjeta 	+= $fila_tarjeta;
					$total_transfer	+= $fila_transfe;
					$total_otras 	+= $fila_otras;
					$total_general 	+= $total_fila;
				}
				?>
			<?php endforeach ?>
			<?php if ($i == 0) : ?>
				<tr>
					<td colspan="9" align="center" style="text-align: center;">No se encontraron registros</td>
				</tr>
			<?php endif ?>
		</tbody>
		<tfoot>
			<?php if ($i != 0) : ?>
				<tr style="font-weight: bold;">
					<td colspan="3" style="text-align: right;">TOTALES</td>
					<td style="text-align: right;"><?php echo $simbolo . number_format($total_efectivo, 2); ?></td>
					<td style="text-align: right;"><?php echo $simbolo . number_format($total_cheque, 2); ?></td>
					<td style="text-align: right;"><?php echo $simbolo . number_format($total_tarjeta, 2); ?></td>
					<td style="text-align: right;"><?php echo $simbolo . number_format($total_transfer, 2); ?></td>
					<td style="text-align: right;"><?php echo $simbolo . number_format($total_otras, 2); ?></td>
					<td style="text-align: right;"><?php echo $simbolo . number_format($total_general, 2); ?></td>
				</tr>
			<?php endif ?>
		</tfoot>
	</table>
<?php else : ?>
	<table class="responsive dynamicTable display table table-bordered dataTable" id="datagried" name="datagried" border="1">
		<thead>
			<?php if ($tipo_reporte != '') : ?>
				<tr style="text-align: center;font-size: 9px; font-weight: bold;">
					<th colspan="2">Codigo Cliente</th>
					<th colspan="6">Acumulado</th>
				</tr>
			<?php endif ?>
			<tr style="font-weight: bold; text-align: center;">
				<th>Codigo</th>
				<th>Nombre</th>
				<th>Efectivo</th>
				<th>Cheque</th>
				<th>Tarjeta</th>
				<th>Transferencias</th>
				<th>Otras formas de pago</th>
				<th>Total</th>
			</tr>
		</thead>
		<tbody id="contenedor">
			<tr>
				<td colspan="8" align="center" style="text-align: center;">No se encontraron registros</td>
			</tr>
		</tbody>
	</table>
<?php endif ?>