<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'pdf') {
?>
	<!DOCTYPE html>
	<html>

	<head>
		<title>REPORTE DE COMPOSICION DE SALDOS</title>
	</head>

	<body>
		<script type="text/javascript">
			document.title = "<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> - REPORTE DE COMPOSICION DE SALDOS";
			window.print();
		</script>
	<?php
}

if ($tipo_reporte == 'excel') {
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header("content-disposition: attachment;filename=" . $filename . ".xls");
	header("Pragma: no-cache");
	header("Expires: 0");
}

$font = ($tipo_reporte == 'pdf') ? 'style="font-size: 8px;"' : '';
$height = ($tipo_reporte == 'pdf') ? 'height="12px"' : '';

if ($tipo_reporte == 'excel') { //Datos del encabezado en excel
	?>
		<meta charset="utf-8" />
		<div class="head">
			<table>
				<tr>
					<td align="center" colspan="3">
						<h4>
							<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
							<br />
							Reporte de Composicion de Saldos
						</h4>
					</td>
				</tr>
			</table>
		</div>
	<?php
}

if (count($informacion) > 0) {
	$saler_id = $informacion[0]['ven_id'];
	$saler_name = $informacion[0]['ven_nombre'];
	$cliente_id = $informacion[0]['cli_id'];
	$cliente_name = $informacion[0]['cli_codigo'] . ' - ' . $informacion[0]['cli_nombre'];
	$sucursal = ($informacion[0]['scl_codigo'] != '' && $informacion[0]['scl_nombre'] != '') ? $informacion[0]['scl_codigo'] . ' - ' . $informacion[0]['scl_nombre'] : '';
	$monto_tabla = 0;
	$saldo_tabla = 0;
	$reten_tabla = 0;
	$monto_saler = 0;
	$saldo_saler = 0;
	$reten_saler = 0;
	$monto_total = 0;
	$saldo_total = 0;
	$reten_total = 0;
	$salers = 1;
	?>
		<table width="100%" cellpadding="1" class="responsive dynamicTable table table-bordered dataTable" id="datagried" name="datagried" border="0" <?php echo $font; ?>>
			<thead>
				<tr style="font-weight: bold; color: black;" nobr="true">
					<th width="30%" style="border: 1px solid silver;">Vendedor</th>
					<th colspan="6" width="70%" style="border: 1px solid silver;"><?php echo ($saler_name != '') ? $saler_name : ' --'; ?></th>
				</tr>
				<tr style="font-weight: bold; color: black;" nobr="true">
					<th width="30%" style="border: 1px solid silver;">Cliente</th>
					<th colspan="6" width="70%" style="border: 1px solid silver;"><?php echo $cliente_name; ?></th>
				</tr>
				<?php if ($sucursal) : ?>
					<tr style="font-weight: bold; color: black;" nobr="true">
						<th width="30%" style="border: 1px solid silver;">Sucursal</th>
						<th colspan="6" width="70%" style="border: 1px solid silver;"><?php echo $sucursal; ?></th>
					</tr>
				<?php endif ?>
				<tr style="font-weight: bold; color: black;" nobr="true">
					<th width="25%" style="text-align: center;border: 1px solid silver;">Documento</th>
					<th width="12%" style="text-align: center;border: 1px solid silver;">Fecha</th>
					<th width="12%" style="text-align: center;border: 1px solid silver;">Vencimiento</th>
					<th width="10%" style="text-align: center;border: 1px solid silver;">Dias V.</th>
					<th width="14%" style="text-align: center;border: 1px solid silver;">Monto</th>
					<th width="12%" style="text-align: center;border: 1px solid silver;">Retenciones</th>
					<th width="15%" style="text-align: center;border: 1px solid silver;">Saldo</th>
				</tr>
			</thead>
			<tbody>
				<?php
				foreach ($informacion as $key => $value) {
					$saldo_nuevo = ($value['saldo_actual'] != $value['fac_monto_pendiente']) ? $value['saldo_actual'] : $value['fac_monto_pendiente'];
					$saldo_nuevo = ($saldo_nuevo < 0) ? 0 : $saldo_nuevo;
					if ($value['ven_id'] == $saler_id) {
						if ($value['cli_id'] == $cliente_id) {
							//Primer vendedor, primer cliente
				?>
							<tr nobr="true">
								<td width="25%"><?php echo $value['tif_nombre'] . ' #' . $value['fac_numero']; ?></td>
								<td width="12%" style="text-align: center;"><?php echo date("d-m-Y", strtotime($value['fac_fecha_fact'])); ?></td>
								<td width="12%" style="text-align: center;"><?php echo date("d-m-Y", strtotime($value['fac_fecha_vencimiento'])); ?></td>
								<td width="10%" style="text-align: center;"><?php echo ($value['dias_vencido'] > 0 && $value['fac_monto_pendiente'] > 0) ? $value['dias_vencido'] : '-'; ?></td>
								<td width="14%" style="text-align: right;"><?php echo $simbolo . number_format($value['fac_total'], 2); ?></td>
								<td width="12%" style="text-align: right;"><?php echo $simbolo . number_format($value['fac_total_retencion'], 2); ?></td>
								<td width="15%" style="text-align: right;"><?php echo $simbolo . number_format($saldo_nuevo, 2); ?></td>
							</tr>
						<?php
							$monto_tabla += $value['fac_total'];
							$reten_tabla += $value['fac_total_retencion'];
							$saldo_tabla += $saldo_nuevo;
						} else {
							//mismo vendedor, otro cliente 
						?>
							<tr nobr="true">
								<th colspan="4" style="text-align: right;border: 1px solid silver;">TOTAL CLIENTE</th>
								<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($monto_tabla, 2); ?></th>
								<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($reten_tabla, 2); ?></th>
								<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($saldo_tabla, 2); ?></th>
							</tr>
							<?php
							$monto_saler += $monto_tabla;
							$reten_saler += $reten_tabla;
							$saldo_saler += $saldo_tabla;
							$cliente_id = $value['cli_id'];
							$cliente_name = $value['cli_codigo'] . ' - ' . $value['cli_nombre'];
							$monto_tabla = 0;
							$reten_tabla = 0;
							$saldo_tabla = 0;
							?>
							<tr>
								<td colspan="7" height="2px"></td>
							</tr>
							<tr style="font-weight: bold;" nobr="true">
								<th width="30%" style="border: 1px solid silver;">Cliente</th>
								<th colspan="6" width="70%" style="border: 1px solid silver;"><?php echo $cliente_name; ?></th>
							</tr>
							<?php if ($value['scl_codigo'] != '' && $value['scl_nombre'] != '') : ?>
								<tr style="font-weight: bold;">
									<th width="30%" style="border: 1px solid silver;">Sucursal</th>
									<th colspan="6" width="70%" style="border: 1px solid silver;"><?php echo $value['scl_codigo'] . ' - ' . $value['scl_nombre']; ?></th>
								</tr>
							<?php endif ?>
							<tr style="font-weight: bold;" nobr="true">
								<th width="25%" style="text-align: center;border: 1px solid silver;">Documento</th>
								<th width="12%" style="text-align: center;border: 1px solid silver;">Fecha</th>
								<th width="12%" style="text-align: center;border: 1px solid silver;">Vencimiento</th>
								<th width="10%" style="text-align: center;border: 1px solid silver;">Dias V.</th>
								<th width="14%" style="text-align: center;border: 1px solid silver;">Monto</th>
								<th width="12%" style="text-align: center;border: 1px solid silver;">Retenciones</th>
								<th width="15%" style="text-align: center;border: 1px solid silver;">Saldo</th>
							</tr>
							<tr nobr="true">
								<td width="25%"><?php echo $value['tif_nombre'] . ' #' . $value['fac_numero']; ?></td>
								<td width="12%" style="text-align: center;"><?php echo date("d-m-Y", strtotime($value['fac_fecha_fact'])); ?></td>
								<td width="12%" style="text-align: center;"><?php echo date("d-m-Y", strtotime($value['fac_fecha_vencimiento'])); ?></td>
								<td width="10%" style="text-align: center;"><?php echo ($value['dias_vencido'] > 0 && $value['fac_monto_pendiente'] > 0) ? $value['dias_vencido'] : '-'; ?></td>
								<td width="14%" style="text-align: right;"><?php echo $simbolo . number_format($value['fac_total'], 2); ?></td>
								<td width="12%" style="text-align: right;"><?php echo $simbolo . number_format($value['fac_total_retencion'], 2); ?></td>
								<td width="15%" style="text-align: right;"><?php echo $simbolo . number_format($saldo_nuevo, 2); ?></td>
							</tr>
						<?php
							$monto_tabla += $value['fac_total'];
							$reten_tabla += $value['fac_total_retencion'];
							$saldo_tabla += $saldo_nuevo;
						}
					} else {
						//otro vendedor, primer cliente
						$salers++;
						$saler_id = $value['ven_id'];
						$saler_name = $value['ven_nombre'];
						$cliente_id = $value['cli_id'];
						$cliente_name = $value['cli_codigo'] . ' - ' . $value['cli_nombre'];
						?>
						<tr nobr="true">
							<th colspan="4" style="text-align: right;border: 1px solid silver;">TOTAL CLIENTE</th>
							<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($monto_tabla, 2); ?></th>
							<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($reten_tabla, 2); ?></th>
							<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($saldo_tabla, 2); ?></th>
						</tr>
						<?php
						$monto_saler += $monto_tabla;
						$reten_saler += $reten_tabla;
						$saldo_saler += $saldo_tabla;
						?>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="7" height="2px"></td>
				</tr>
				<tr nobr="true">
					<th colspan="4" style="text-align: right;border: 1px solid silver;">TOTAL POR VENDEDOR</th>
					<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($monto_saler, 2); ?></th>
					<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($reten_saler, 2); ?></th>
					<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($saldo_saler, 2); ?></th>
				</tr>
			</tfoot>
		</table>
		<div class="clear"><br><br><br></div>
		<?php
						$monto_total += $monto_saler;
						$reten_total += $reten_saler;
						$saldo_total += $saldo_saler;
						$monto_tabla = 0;
						$reten_tabla = 0;
						$saldo_tabla = 0;
						$monto_saler = 0;
						$reten_saler = 0;
						$saldo_saler = 0;
		?>
		<table cellpadding="1" width="100%" class="responsive dynamicTable table table-bordered dataTable" id="datagried" name="datagried" border="0" <?php echo $font; ?>>
			<thead>
				<tr style="font-weight: bold;" nobr="true">
					<th width="30%" style="border: 1px solid silver;">Vendedor</th>
					<th colspan="6" width="70%" style="border: 1px solid silver;"><?php echo $saler_name; ?></th>
				</tr>
				<tr style="font-weight: bold;" nobr="true">
					<th width="30%" style="border: 1px solid silver;">Cliente</th>
					<th colspan="6" width="70%" style="border: 1px solid silver;"><?php echo $cliente_name; ?></th>
				</tr>
				<?php if ($value['scl_codigo'] != '' && $value['scl_nombre'] != '') : ?>
					<tr style="font-weight: bold;" nobr="true">
						<th width="30%" style="border: 1px solid silver;">Sucursal</th>
						<th colspan="6" width="70%" style="border: 1px solid silver;"><?php echo $value['scl_codigo'] . ' - ' . $value['scl_nombre']; ?></th>
					</tr>
				<?php endif ?>
				<tr style="font-weight: bold;" nobr="true">
					<th width="25%" style="text-align: center;border: 1px solid silver;">Documento</th>
					<th width="12%" style="text-align: center;border: 1px solid silver;">Fecha</th>
					<th width="12%" style="text-align: center;border: 1px solid silver;">Vencimiento</th>
					<th width="10%" style="text-align: center;border: 1px solid silver;">Dias V.</th>
					<th width="14%" style="text-align: center;border: 1px solid silver;">Monto</th>
					<th width="12%" style="text-align: center;border: 1px solid silver;">Retenciones</th>
					<th width="15%" style="text-align: center;border: 1px solid silver;">Saldo</th>
				</tr>
			</thead>
			<tbody>
				<tr nobr="true">
					<td width="25%"><?php echo $value['tif_nombre'] . ' #' . $value['fac_numero']; ?></td>
					<td width="12%" style="text-align: center;"><?php echo date("d-m-Y", strtotime($value['fac_fecha_fact'])); ?></td>
					<td width="12%" style="text-align: center;"><?php echo date("d-m-Y", strtotime($value['fac_fecha_vencimiento'])); ?></td>
					<td width="10%" style="text-align: center;"><?php echo ($value['dias_vencido'] > 0 && $value['fac_monto_pendiente'] > 0) ? $value['dias_vencido'] : '-'; ?></td>
					<td width="14%" style="text-align: right;"><?php echo $simbolo . number_format($value['fac_total'], 2); ?></td>
					<td width="12%" style="text-align: right;"><?php echo $simbolo . number_format($value['fac_total_retencion'], 2); ?></td>
					<td width="15%" style="text-align: right;"><?php echo $simbolo . number_format($saldo_nuevo, 2); ?></td>
				</tr>
		<?php
						$monto_tabla += $value['fac_total'];
						$reten_tabla += $value['fac_total_retencion'];
						$saldo_tabla += $saldo_nuevo;
					} //end else
				} //endforeach  	
		?>
		<tr nobr="true">
			<th colspan="4" style="text-align: right;border: 1px solid silver;">TOTAL CLIENTE</th>
			<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($monto_tabla, 2); ?></th>
			<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($reten_tabla, 2); ?></th>
			<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($saldo_tabla, 2); ?></th>
		</tr>
			</tbody>
			<?php
			$monto_saler += $monto_tabla;
			$saldo_saler += $saldo_tabla;
			$reten_saler += $reten_tabla;
			$monto_total += $monto_saler;
			$reten_total += $reten_saler;
			$saldo_total += $saldo_saler;
			?>
			<tfoot>
				<tr>
					<td colspan="7" height="2px"></td>
				</tr>
				<tr nobr="true">
					<th colspan="4" style="text-align: right;border: 1px solid silver;">TOTAL POR VENDEDOR</th>
					<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($monto_saler, 2); ?></th>
					<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($reten_saler, 2); ?></th>
					<th style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($saldo_saler, 2); ?></th>
				</tr>
				<?php if ($salers > 1) : ?>
					<tr>
						<td colspan="7"></td>
					</tr>
					<tr nobr="true">
						<th width="59%" colspan="4" style="text-align: right;border: 1px solid silver;">TOTAL GENERAL</th>
						<th width="14%" style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($monto_total, 2); ?></th>
						<th width="12%" style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($reten_total, 2); ?></th>
						<th width="15%" style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($saldo_total, 2); ?></th>
					</tr>
				<?php endif ?>
			</tfoot>
		</table>
		<!-- <div class="clear"><br></div> -->
		<!-- <table cellpadding="1" class="responsive dynamicTable display table table-bordered dataTable" id="datagried" name="datagried" border="0" <?php echo $font; ?> > -->
		<!-- <thead> -->
		<!-- <tr> -->
		<!-- <th width="61%" style="text-align: right;border: 1px solid silver;">TOTAL GENERAL</th> -->
		<!-- <th width="13%" style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($monto_total, 2); ?></th> -->
		<!-- <th width="11%" style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($saldo_total, 2); ?></th> -->
		<!-- <th width="15%" style="text-align: right;border: 1px solid silver;"><?php echo $simbolo . number_format($saldo_total, 2); ?></th> -->
		<!-- </tr> -->
		<!-- </thead> -->
		<!-- </table> -->
	<?php
} else {
	?>
		<table width="100%" class="responsive dynamicTable display table dataTable" border="1">
			<tr>
				<th style="text-align: center;">No se encontraron registros</th>
			</tr>
		</table>
	<?php
}
//  endif ppal


if ($tipo_reporte == 'pdf') {
	?>
	</body>

	</html>
<?php
} ?>