<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=rpt_comisiones_cxc.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
?>
    <meta charset="utf-8" />
    <table>
        <tr>
            <td align="center" colspan="7">
                <h4><?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?></h4>
            </td>
            <td></td>
        </tr>
        <tr>
            <td align="center" colspan="7"><b>Reporte de Comisiones por Recuperación de Cuentas por Cobrar</b></td>
            <td style="text-align: right;"><?php echo $this->tank_auth->get_username(); ?></td>
        </tr>
        <tr>
            <td style="text-align: right;" colspan="8">
                <?php echo $this->gsatelite->get_parametro('SYS_DEPARTAMENTO') . ', ' . date('d-m-Y H:i:s a'); ?>
            </td>
        </tr>
    </table>
<?php
}
$p = ($tipo == 'pdf') ? true : false;
?>
<table class="responsive table table-bordered" cellpadding="2" id="datagried" name="datagried" border="1" style="font-size: <?= ($p) ? ' 7pt;' : ' 9pt;'; ?>">
    <thead id="cabezera">
        <tr style="font-weight: bold; text-align: center;">
            <th <?= ($p) ? 'width="10%"' : ''; ?>>Fecha Facturación</th>
            <th <?= ($p) ? 'width="10%"' : ''; ?>>Factura</th>
            <th <?= ($p) ? 'width="24%"' : ''; ?>>Cliente</th>
            <th <?= ($p) ? 'width="10%"' : ''; ?>>Fecha Cobro</th>
            <th <?= ($p) ? 'width="10%"' : ''; ?>>Días</th>
            <th <?= ($p) ? 'width="12%"' : ''; ?>>Valor Factura</th>
            <th <?= ($p) ? 'width="12%"' : ''; ?>>Monto Abono</th>
            <th <?= ($p) ? 'width="12%"' : ''; ?>>Comisión</th>
        </tr>
    </thead>
    <tbody id="contenedor">
        <?php
        $total_saldos = $total_abonos = $total_coms = 0;
        $facturas_emp = $cobros_emp = $comision_emp = 0;
        $fact_bloque = $pago_bloque = $com_bloque = 0;
        if (count($registros) > 0) {
            $emp_actual = $registros[0]['ven_cob'];
            $com_actual = $registros[0]['porcn_ctdad'];
            $vencob = explode('&&', $emp_actual);
            $valpor = explode('##', $com_actual);
            $gestor_cobro = ($vencob[0] == 'C') ? $registros[0]['cobrador'] : $registros[0]['vendedor'];
        ?>
            <tr style="font-weight: bold;">
                <td colspan="8">Asesor: <?= mb_strtoupper($gestor_cobro, 'UTF-8') ?></td>
            </tr>
            <tr>
                <td colspan="8">Comisión <?= ($valpor[0] == 1) ? 'de $' : 'al'; ?> <?= $valpor[1] ?> <?= ($valpor[0] == 1) ? '' : '%'; ?></td>
            </tr>
            <?php
            foreach ($registros as $f) {
                if ($f['ven_cob'] == $emp_actual) {
                    if ($f['porcn_ctdad'] == $com_actual) {
                        $comision_fila = ($valpor[0] == 1) ? $valpor[1] : $f['porc_com_estimado'];
                        $com_bloque += number_format($comision_fila, 2, '.', '');
                        $pago_bloque += number_format($f['abf_monto'], 2, '.', '');
                        $fact_bloque += number_format($f['total_fact'], 2, '.', '');
            ?>
                        <tr nobr="true">
                            <td <?= ($p) ? 'width="10%"' : ''; ?>><?php echo formatear_fecha('d-m-Y', $f['fecha_comp']); ?></td>
                            <td <?= ($p) ? 'width="10%"' : ''; ?>><?php echo $f['serie'] . ' - ' . $f['fac_numero']; ?></td>
                            <td <?= ($p) ? 'width="24%"' : ''; ?>><?php echo $f['cliente']; ?></td>
                            <td <?= ($p) ? 'width="10%"' : ''; ?>><?php echo formatear_fecha('d-m-Y', $f['fecha_pago']); ?></td>
                            <td style="text-align: right;" <?= ($p) ? 'width="10%"' : ''; ?>><?php echo $f['dias']; ?></td>
                            <td style="text-align: right;" <?= ($p) ? 'width="12%"' : ''; ?>><?php echo number_format($f['total_fact'], 2); ?></td>
                            <td style="text-align: right;" <?= ($p) ? 'width="12%"' : ''; ?>><?php echo number_format($f['abf_monto'], 2); ?></td>
                            <td style="text-align: right;" <?= ($p) ? 'width="12%"' : ''; ?>><?php echo number_format($comision_fila, 2); ?></td>
                        </tr>
                    <?php
                    } else {
                        $facturas_emp += $fact_bloque;
                        $cobros_emp += $pago_bloque;
                        $comision_emp += $com_bloque;
                    ?>
                        <tr>
                            <td colspan="5" style="font-weight: bold; text-align: right;">Total <?= ($valpor[0] == 1) ? 'valor $' : 'al'; ?> <?= $valpor[1] ?> <?= ($valpor[0] == 1) ? '' : '%'; ?></td>
                            <td style="text-align: right;"><?= number_format($fact_bloque, 2) ?></td>
                            <td style="text-align: right;"><?= number_format($pago_bloque, 2) ?></td>
                            <td style="text-align: right;"><?= number_format($com_bloque, 2) ?></td>
                        </tr>
                        <?php
                        $com_actual = $f['porcn_ctdad'];
                        $valpor = explode('##', $com_actual);
                        $fact_bloque = $pago_bloque = $com_bloque = 0;
                        $comision_fila = ($valpor[0] == 1) ? $valpor[1] : $f['porc_com_estimado'];
                        $com_bloque += number_format($comision_fila, 2, '.', '');
                        $pago_bloque += number_format($f['abf_monto'], 2, '.', '');
                        $fact_bloque += number_format($f['total_fact'], 2, '.', '');
                        ?>
                        <tr>
                            <td colspan="8">Comisión <?= ($valpor[0] == 1) ? 'de $' : 'al'; ?> <?= $valpor[1] ?> <?= ($valpor[0] == 1) ? '' : '%'; ?></td>
                        </tr>
                        <tr nobr="true">
                            <td><?php echo formatear_fecha('d-m-Y', $f['fecha_comp']); ?></td>
                            <td><?php echo $f['serie'] . ' - ' . $f['fac_numero']; ?></td>
                            <td><?php echo $f['cliente']; ?></td>
                            <td><?php echo formatear_fecha('d-m-Y', $f['fecha_pago']); ?></td>
                            <td style="text-align: right;"><?php echo $f['dias']; ?></td>
                            <td style="text-align: right;"><?php echo number_format($f['total_fact'], 2); ?></td>
                            <td style="text-align: right;"><?php echo number_format($f['abf_monto'], 2); ?></td>
                            <td style="text-align: right;"><?php echo number_format($comision_fila, 2); ?></td>
                        </tr>
                    <?php
                    }
                } else {
                    $facturas_emp += $fact_bloque;
                    $cobros_emp += $pago_bloque;
                    $comision_emp += $com_bloque;
                    ?>
                    <tr>
                        <td colspan="5" style="font-weight: bold; text-align: right;">Total <?= ($valpor[0] == 1) ? 'valor $' : 'al'; ?> <?= $valpor[1] ?> <?= ($valpor[0] == 1) ? '' : '%'; ?></td>
                        <td style="text-align: right;"><?= number_format($fact_bloque, 2) ?></td>
                        <td style="text-align: right;"><?= number_format($pago_bloque, 2) ?></td>
                        <td style="text-align: right;"><?= number_format($com_bloque, 2) ?></td>
                    </tr>
                    <tr>
                        <td colspan="5" style="font-weight: bold; text-align: right;">Total <?= mb_strtoupper($gestor_cobro, 'UTF-8') ?></td>
                        <td style="text-align: right;"><?= number_format($facturas_emp, 2) ?></td>
                        <td style="text-align: right;"><?= number_format($cobros_emp, 2) ?></td>
                        <td style="text-align: right;"><?= number_format($comision_emp, 2) ?></td>
                    </tr>
                    <tr>
                        <td colspan="8"></td>
                    </tr>
                    <?php
                    $total_saldos += $facturas_emp;
                    $total_abonos += $cobros_emp;
                    $total_coms += $comision_emp;
                    $fact_bloque = $pago_bloque = $com_bloque = 0;
                    $facturas_emp = $cobros_emp = $comision_emp = 0;

                    $emp_actual = $f['ven_cob'];
                    $com_actual = $f['porcn_ctdad'];
                    $vencob = explode('&&', $emp_actual);
                    $valpor = explode('##', $com_actual);
                    $gestor_cobro = ($vencob[0] == 'C') ? $f['cobrador'] : $f['vendedor'];
                    $comision_fila = ($valpor[0] == 1) ? $valpor[1] : $f['porc_com_estimado']; // $f['suma_def'] * $f['parte_pago'] * ($valpor[1] / 100);

                    $com_bloque += number_format($comision_fila, 2, '.', '');
                    $pago_bloque += number_format($f['abf_monto'], 2, '.', '');
                    $fact_bloque += number_format($f['total_fact'], 2, '.', '');
                    ?>
                    <tr style="font-weight: bold;">
                        <td colspan="8">Asesor: <?= mb_strtoupper($gestor_cobro, 'UTF-8') ?></td>
                    </tr>
                    <tr>
                        <td colspan="8">Comisión <?= ($valpor[0] == 1) ? 'de ' . $simbolo : 'al'; ?> <?= $valpor[1] ?> <?= ($valpor[0] == 1) ? '' : '%'; ?></td>
                    </tr>
                    <tr nobr="true">
                        <td><?php echo formatear_fecha('d-m-Y', $f['fecha_comp']); ?></td>
                        <td><?php echo $f['serie'] . ' - ' . $f['fac_numero']; ?></td>
                        <td><?php echo $f['cliente']; ?></td>
                        <td><?php echo formatear_fecha('d-m-Y', $f['fecha_pago']); ?></td>
                        <td style="text-align: right;"><?php echo $f['dias']; ?></td>
                        <td style="text-align: right;"><?php echo $f['total_fact']; ?></td>
                        <td style="text-align: right;"><?php echo $f['abf_monto']; ?></td>
                        <td style="text-align: right;"><?php echo number_format($comision_fila, 2); ?></td>
                    </tr>
            <?php
                }
            }
            $facturas_emp += $fact_bloque;
            $cobros_emp += $pago_bloque;
            $comision_emp += $com_bloque;
            $total_saldos += $facturas_emp;
            $total_abonos += $cobros_emp;
            $total_coms += $comision_emp;
            ?>
            <tr>
                <td colspan="5" style="font-weight: bold; text-align: right;">Total <?= ($valpor[0] == 1) ? 'valor $' : 'al'; ?> <?= $valpor[1] ?> <?= ($valpor[0] == 1) ? '' : '%'; ?></td>
                <td style="text-align: right;"><?= number_format($fact_bloque, 2) ?></td>
                <td style="text-align: right;"><?= number_format($pago_bloque, 2) ?></td>
                <td style="text-align: right;"><?= number_format($com_bloque, 2) ?></td>
            </tr>
            <tr>
                <td colspan="5" style="font-weight: bold; text-align: right;">Total <?= mb_strtoupper($gestor_cobro, 'UTF-8') ?></td>
                <td style="text-align: right;"><?= number_format($facturas_emp, 2) ?></td>
                <td style="text-align: right;"><?= number_format($cobros_emp, 2) ?></td>
                <td style="text-align: right;"><?= number_format($comision_emp, 2) ?></td>
            </tr>
        <?php
        } else {
        ?>
            <tr>
                <td colspan="8" align="center" style="text-align: center;">No se encontraron registros</td>
            </tr>
        <?php
        } ?>
    </tbody>
    <?php if (count($registros) > 0) {
    ?>
        <tfoot>
            <tr>
                <td colspan="8"></td>
            </tr>
            <tr style="font-weight: bold;">
                <td colspan="5" style="text-align: right;">TOTAL GENERAL</td>
                <td style="text-align: right;"><?= number_format($total_saldos, 2) ?></td>
                <td style="text-align: right;"><?= number_format($total_abonos, 2) ?></td>
                <td style="text-align: right;"><?= number_format($total_coms, 2) ?></td>
            </tr>
        </tfoot>
    <?php
    } ?>
</table>