<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de estado de cuenta corriente cliente
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }

    .titulo {
        vertical-align: middle;
        text-align: center;
        font-weight: bold;

    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: left;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 9pt;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="0" cellpadding="1" class="tabla" <?php echo ($tipo_reporte == 'pdf') ? 'style="font-size: 8pt;"' : ''; ?>>
    <?php } else { ?>
        <table class="responsive display table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="0" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr style="color: black;">
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="8%"' : ''; ?>>Código</th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="19%"' : ''; ?>>Nombre</th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?>>Fecha Transacción</th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?>>Fecha Vencimiento</th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="15%"' : ''; ?>>Vendedor</th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>>Tipo</th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>>Débito</th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>>Crédito</th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>>Total</th>
            </tr>
        </thead>
        <tbody id="tbl_contenedor_clientes">
            <?php
            if (count($clientes) > 0) {
                $i = 0;
                $gran_total_debitos = 0;
                $gran_total_credito = 0;
                $gran_total_cliente = 0;
                $total_cliente      = 0;
                $credito_cliente    = 0;
                $debito_cliente     = 0;
                $cliente_evaluado   = $clientes[0]['id'];
                foreach ($clientes as $key => $cli) {
                    if ($mostrar[$cli['id']]['contador'] > 1 || $mostrar[$cli['id']]['saldo_incial'] > 0) {
                        $i++;
                        if ($cli['id'] == $cliente_evaluado) {
                            if ($cli['Balance incial'] != "") {
                                $total_cliente += number_format($cli['Balance incial'], 2, '.', '');
            ?>
                                <tr class="titulo" nobr="true">
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="8%"' : ''; ?>><?php echo $cli['Codigo']; ?></td>
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="19%"' : ''; ?>><?php echo $cli['Nombre']; ?></td>
                                    <td colspan="6" style="text-align: right;" <?php echo ($tipo_reporte == 'pdf') ? 'width="63%"' : ''; ?>>Saldo Inicial</td>
                                    <td style="text-align: right;" <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>><?php echo $simbolo . number_format($total_cliente, 2); ?></td>
                                </tr>
                            <?php
                            } else {
                                $debito_cliente += number_format($cli['Debito'], 2, '.', '');
                                $credito_cliente += number_format($cli['Credito'], 2, '.', '');
                                $total_cliente += number_format(($cli['Debito'] - $cli['Credito']), 2, '.', '');
                            ?>
                                <tr nobr="true">
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="8%"' : ''; ?>><?php echo $cli['Codigo']; ?></td>
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="19%"' : ''; ?>><?php echo $cli['Nombre']; ?></td>
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?>><?php echo formatear_fecha('d-m-Y', $cli['Fecha Trans.']); ?></td>
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="9%"' : ''; ?>><?php echo formatear_fecha('d-m-Y', $cli['Vencimiento']); ?></td>
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="15%"' : ''; ?>><?php echo $cli['Vendedor']; ?></td>
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>><?php echo $cli['Tipo'] . ' - ' . $cli['Documento']; ?></td>
                                    <td style="text-align: right;" <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>><?php echo $simbolo . number_format($cli['Debito'], 2); ?></td>
                                    <td style="text-align: right;" <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>><?php echo $simbolo . number_format($cli['Credito'], 2); ?></td>
                                    <td style="text-align: right;" <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>><?php echo $simbolo . number_format($total_cliente, 2); ?></td>
                                </tr>
                            <?php
                            }
                        } else {
                            ?>
                            <tr class="totales" nobr="true">
                                <td colspan="6" style="text-align: right; border-bottom: black 1px solid;">Saldo Actual</td>
                                <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($debito_cliente, 2); ?></td>
                                <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($credito_cliente, 2); ?></td>
                                <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($total_cliente, 2); ?></td>
                            </tr>
                            <?php
                            $gran_total_debitos += $debito_cliente;
                            $gran_total_credito += $credito_cliente;
                            $gran_total_cliente += $total_cliente;
                            $cliente_evaluado = $cli['id'];
                            $debito_cliente = $credito_cliente = $total_cliente = 0;
                            if ($cli['Balance incial'] != "") {
                                $total_cliente += number_format($cli['Balance incial'], 2, '.', '');
                            ?>
                                <tr class="titulo">
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="8%"' : ''; ?>><?php echo $cli['Codigo']; ?></td>
                                    <td <?php echo ($tipo_reporte == 'pdf') ? 'width="19%"' : ''; ?>><?php echo $cli['Nombre']; ?></td>
                                    <td colspan="6" style="text-align: right;" <?php echo ($tipo_reporte == 'pdf') ? 'width="63%"' : ''; ?>>Saldo Inicial</td>
                                    <td style="text-align: right;" <?php echo ($tipo_reporte == 'pdf') ? 'width="10%"' : ''; ?>><?php echo $simbolo . number_format($total_cliente, 2); ?></td>
                                </tr>
                    <?php
                            }
                        }
                    }
                }
                if (!($i > 0)) {
                    ?>
                    <tr class="totales">
                        <td colspan="9" style="text-align: center;">No se encontraron registros</td>
                    </tr>
                <?php
                }
                if ($i > 0) {
                ?>
                    <tr class="totales">
                        <td colspan="6" style="text-align: right; border-bottom: black 1px solid;">Saldo Actual</td>
                        <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($debito_cliente, 2); ?></td>
                        <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($credito_cliente, 2); ?></td>
                        <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($total_cliente, 2); ?></td>
                    </tr>
                <?php
                }
                $gran_total_debitos += $debito_cliente;
                $gran_total_credito += $credito_cliente;
                $gran_total_cliente += $total_cliente;
            } else {
                ?>
                <tr class="totales">
                    <td colspan="9" style="text-align: center;">No se encontraron registros</td>
                </tr>
            <?php
            }
            ?>
        </tbody>
        <tfoot>
            <tr class="totales">
                <td colspan="6" style="text-align: right; border-bottom: black 1px solid;">Totales</td>
                <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($gran_total_debitos, 2); ?></td>
                <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($gran_total_credito, 2); ?></td>
                <td style="text-align: right; border-bottom: black 1px solid;"><?php echo $simbolo . number_format($gran_total_cliente, 2); ?></td>
            </tr>
        </tfoot>
        </table>