<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
?>
<table id="tabla" cellpadding="0" cellspacing="0" border="0" class="responsive table table-bordered" width="100%">
    <thead>
        <tr>
            <th>Cliente</th>
            <th>Fecha abono</th>
            <th>Facturas</th>
            <th>Monto Abonado</th>
            <th>Forma de Pago</th>
            <th>Estado</th>
            <th>Comprobante</th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach ($registros as $fila) { ?>
            <tr>
                <td><?php echo $fila['cliente']; ?></td>
                <td><?php echo formatear_fecha('d-m-Y', $fila['abc_fecha']); ?></td>
                <td><?php echo $fila['facturas']; ?></td>
                <td style="text-align: right;"><?php echo $simbolo . number_format(($fila['abc_monto'] + $fila['abono_ret']), 2); ?></td>
                <td><?php echo $fila['forma_pago']; ?></td>
                <td><?php echo ($fila['abc_estado'] > 0) ? "Activo" : "Anulado"; ?></td>
                <td><?php echo $fila['abc_comprobante']; ?></td>
                <td>
                    <div class="tools">
                        <div class="btn-group">
                            <button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>
                            <button class="btn dropdown-toggle" data-toggle="dropdown">
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu">
                                <?php
                                if ($impresion == true) { ?>
                                    <li>
                                        <a target="_blank" href="<?php echo base_url('modulo_cuentas_cobrar/procesos/imprimir_notas_abono') . '/' . $fila['abc_id']; ?>" title="Imprimir">
                                            <span class="icomoon-icon-printer"></span> Imprimir
                                        </a>
                                    </li>
                                <?php } ?>
                                <?php if ($fila['abc_estado'] > 0) { ?>
                                    <li>
                                        <a class="tip anular_abono" title="Anular Pago" id_abono="<?php echo $fila['abc_id']; ?>" href="#">
                                            <span class="minia-icon-cancel"></span> Anular
                                        </a>
                                    </li>
                                <?php } ?>
                                <li>
                                    <a target="_blank" href="<?php echo base_url('modulo_cuentas_cobrar/procesos/imprimir_recibo/' . $fila['abc_id']); ?>" title="Imprimir Recibo">
                                        <span class="icomoon-icon-printer"> Recibo</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>