<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if (count($registros) > 0) { ?>
    <table class="responsive dynamicTable display table table-bordered dataTable" id="datagried" name="datagried" border="1" style="margin-left: 4px; width: 99%; font-size:12px;">
        <thead id="cabezera">
            <tr style="font-weight: bold; text-align: center;">
                <th width="12%">Cliente</th>
                <th width="12%">Vendedor</th>
                <th width="12%">Cobrador</th>
                <th width="8%">Tipo</th>
                <th width="5%">Núm.</th>
                <th width="9%">Fecha</th>
                <th width="8%">Fecha <br />Vencimiento</th>
                <th width="5%">Días<br />Plazo</th>
                <th width="5%">Días<br />Vencido</th>
                <th width="8%">Monto <?= $simbolo ?></th>
                <th width="8%">Abono <?= $simbolo ?></th>
                <th width="8%">Saldo <?= $simbolo ?></th>
                <?php if ($es_reporte != 1) { ?> <th width="10%">Acción</th> <?php } ?>
            </tr>
        </thead>
        <tbody id="contenedor">
            <?php
            $i = 0;
            $total = $facturas = $abonos = 0;
            foreach ($registros as $f) {
                $i++;
                $total += $f['fac_monto_pendiente'];
                $abonos += $f['fac_monto_abono'];
                $facturas += $f['fac_total'];
            ?>
                <tr nobr="true">
                    <td width="12%"><?php echo $f['cli_codigo'] . ' ' . $f['cliente']; ?></td>
                    <td width="12%"><?php echo $f['vendedor']; ?></td>
                    <td width="12%"><?php echo trim($f['cobrador'], ', '); ?></td>
                    <td width="8%"><?php echo $f['tif_abreviacion']; ?></td>
                    <td width="5%"><?php echo $f['fac_numero']; ?></td>
                    <td width="9%"><?php echo ($es_reporte != 1) ? '<span style="display:none;">' . formatear_fecha('Ymd', $f['fac_fecha_fact']) . '</span>' : '';
                                    echo formatear_fecha('d-m-Y', $f['fac_fecha_fact']); ?></td>
                    <td width="8%"><?php echo ($es_reporte != 1) ? '<span style="display:none;">' . formatear_fecha('Ymd', $f['fac_fecha_vencimiento']) . '</span>' : '';
                                    echo formatear_fecha('d-m-Y', $f['fac_fecha_vencimiento']); ?></td>
                    <td width="5%"><?php echo ($f['plazo_pago'] > 0) ? $f['plazo_pago'] : 0; ?></td>
                    <td width="5%"><?php echo ($f['dias_vencido'] > 0) ? $f['dias_vencido'] : 0; ?></td>
                    <td width="8%" style="text-align: right;"><?php echo $f['fac_total']; ?></td>
                    <td width="8%" style="text-align: right;"><?php echo $f['fac_monto_abono']; ?></td>
                    <td width="8%" style="text-align: right;"><?php echo $f['fac_monto_pendiente']; ?></td>
                    <?php if ($es_reporte != 1) { ?>
                        <td>
                            <div class="tools">
                                <div class="btn-group">
                                    <button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>
                                    <button class="btn dropdown-toggle" data-toggle="dropdown">
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <a class="tip ver_detalle_factura" title="Detalle Factura" id_factura="<?php echo $f['fac_id']; ?>" href="#">
                                                <span class="icomoon-icon-list-view-2"></span> Detalle
                                            </a>
                                        </li>
                                        <li>
                                            <a class="ver_modal tip" title="Seguimientos de Cobros al cliente" id_factura="<?php echo $f['fac_id']; ?>" id_cliente="<?php echo $f['cli_id']; ?>"  href="<?php echo base_url('modulo_cuentas_cobrar/procesos/proximo_pago/' . $f['cli_id'] . '/' . $f['fac_id']); ?>">
                                                <span class=" icomoon-icon-clipboard"></span>Seguimiento cobros
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </td>
                    <?php } ?>
                </tr>
            <?php  } ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="9" align="right" style="text-align: right;">TOTAL</th>
                <th style="text-align: right; font-weight: bold;"> <?php echo $simbolo . number_format($facturas, 2, '.', ''); ?></th>
                <th style="text-align: right; font-weight: bold;"> <?php echo $simbolo . number_format($abonos, 2, '.', ''); ?></th>
                <th style="text-align: right; font-weight: bold;"> <?php echo $simbolo . number_format($total, 2, '.', ''); ?></th>
                <?php if ($es_reporte != 1) { ?><th></th><?php } ?>
            </tr>
        </tfoot>
    </table>
<?php } else { ?>
    <table class="responsive dynamicTable display table table-bordered dataTable" id="datagried" name="datagried" border="1" style="margin-left: 4px; width: 99%; font-size:12px;">
        <thead id="cabezera">
            <tr style="font-weight: bold; text-align: center;">
                <th width="12%">Cliente</th>
                <th width="12%">Vendedor</th>
                <th width="12%">Cobrador</th>
                <th width="8%">Tipo</th>
                <th width="5%">Núm.</th>
                <th width="9%">Fecha</th>
                <th width="8%">Fecha <br />Vencimiento</th>
                <th width="5%">Días<br />Plazo</th>
                <th width="5%">Días<br />Vencido</th>
                <th width="8%">Monto <?= $simbolo ?></th>
                <th width="8%">Abono <?= $simbolo ?></th>
                <th width="8%">Saldo <?= $simbolo ?></th>
                <?php if ($es_reporte != 1) { ?> <th width="10%">Acción</th> <?php } ?>
            </tr>
        </thead>
        <tbody id="contenedor">
            <?php if ($es_reporte == 1) { ?> <tr>
                    <td colspan="12" align="center" style="text-align: center;">No se encontraron registros</td>
                </tr> <?php } ?>
        </tbody>
    </table>
<?php } ?>

<?php if ($es_reporte != 1) { ?>
    <div style="display:none;">
        <form action="<?php echo base_url('modulo_cuentas_cobrar/procesos/filtrar_cuentas_cobrar_detallado/1'); ?>" method="post" id="exportar_imprimir" target="_blank">
            <input type="hidden" name="txtFecha_desde" value="<?php echo $txtFecha_desde ?>">
            <input type="hidden" name="txtFecha_hasta" value="<?php echo $txtFecha_hasta ?>">
            <input type="hidden" name="slcVendedor" value="<?php echo $slcVendedor ?>">
            <input type="hidden" name="slcCliente" value="<?php echo $slcCliente ?>">
            <input type="hidden" name="slcCobrador" value="<?php echo $slcCobrador ?>">
            <input type="hidden" name="slcTipoFact" value="<?php echo $slcTipoFact ?>">
            <input type="hidden" name="tipo_accion" id="tipo_accion" value="0">
        </form>
    </div>

    <script>
        $(document).ready(function() {
            $('#exportar, #imprimir_pdf').show();
            $('#datagried').dataTable({
                "bAutoWidth": false,
                "aLengthMenu": [
                    [10, 25, 50, -1],
                    [10, 25, 50, "Todos"]
                ]
            });

            if ($("#datagried tr").length > 1) {
                $("#contenedorTabla").css({
                    'height': 'auto',
                    'width': 'auto',
                    'padding-bottom': '120px'
                });
                $("html, body").animate({
                    scrollTop: $(document).height() - $(window).height()
                });
            }

        });
    </script>
<?php } ?>