<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
?>
<table id="tabla" cellpadding="0" cellspacing="0" border="0" class="responsive table table-bordered" width="100%">
    <thead>
        <tr>
            <th>Cliente</th>
            <th>Fecha anticipo</th>
            <th>Facturas <?php echo (isset($version)) ? "Generadoras" : ""; ?></th>
            <th>Monto anticipo</th>
            <th><?php echo (isset($version)) ? "Saldo Anticipo" : "Forma de Pago"; ?></th>
            <th>Estado</th>
            <?php if (!(isset($version))) : ?>
                <th>Comprobante</th>
            <?php endif ?>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php
        foreach ($registros as $fila) { ?>
            <tr>
                <td><?php echo $fila['cliente']; ?></td>
                <td><?php echo date_format(date_create($fila['anl_fecha']), 'd-m-Y'); ?></td>
                <td><?php echo $fila["facturas"]; ?></td>
                <td style="text-align: right;"><?php echo $simbolo . number_format($fila['anl_monto'], 2); ?></td>
                <td <?php echo (isset($version)) ? 'style="text-align: right;"' : ""; ?>><?php echo (isset($version)) ? "$" . number_format($fila['anl_saldo'], 2) : "-";
                                                                                            //$frp = $fila['forma_pago'];
                                                                                            //$frp .= ($fila['banco'] != '') ? ' ('.$fila['banco'].')' : '';
                                                                                            ?>
                </td>
                <td><?php echo ($fila['anl_estado'] > 0) ? "Activo" : "Anulado"; ?></td>
                <?php if (!(isset($version))) : ?>
                    <td><?php echo $fila['anl_comprobante']; ?></td>
                <?php endif ?>
                <td>
                    <div class="tools">
                        <div class="btn-group">
                            <button class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>
                            <button class="btn dropdown-toggle" data-toggle="dropdown">
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu">
                                <?php if (isset($version)) : ?>
                                    <?php if ($fila['anl_monto'] == $fila['anl_saldo'] && $fila['anl_id_abc_origen'] == "" && $fila['anl_estado'] > 0) : ?>
                                        <li>
                                            <a class="tip anular_anticipo" title="Anular Anticipo" data-id="<?php echo $fila['anl_id']; ?>" href="#">
                                                <span class="minia-icon-cancel"> Anular</span>
                                            </a>
                                        </li>
                                    <?php endif ?>
                                <?php endif ?>
                                <!-- <li> 
                                    <a class="tip anular_abono" title="Anular Pago" id_abono="<?php echo $fila['anl_id']; ?>" href="#" >
                                        <span class="minia-icon-cancel"></span> Anular
                                    </a>
                                </li> -->
                                <?php if ($fila['anl_id_abc_origen'] == "") : ?>
                                    <li>
                                        <a target="_blank" href="<?php echo base_url('modulo_cuentas_cobrar/procesos/imprimir_recibo_anticipo/' . $fila['anl_id']); ?>" title="Imprimir Recibo">
                                            <span class="icomoon-icon-printer"> Recibo</span>
                                        </a>
                                    </li>
                                <?php endif ?>
                            </ul>
                        </div>
                    </div>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>