<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Contratos
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
$registros = 1;
foreach ($reporte as $key => $row) :
    if ($tipo_reporte != '') {
?>

        <?php if ($registros == 1) {
        ?>
            <table class="tabla">
                <thead>
                    <tr>
                        <th>Cod. Cliente</th>
                        <th>Nombre</th>
                        <th>Servicio</th>
                        <th>Fecha Inicio</th>
                        <th>Fecha Fin</th>
                        <th>Fecha Ult. Factura</th>
                    </tr>
                </thead>
                <tbody>
            <?php
        }
    }

    $nombre = $row['cli_nombre'];
    if ($row['cli_personeria'] == 1) {
        $nombre .= " " . $row['cli_apellido'];
    }
            ?>
            <tr nobr="true">
                <?php if ($tipo_reporte == '') : ?>
                    <td style="display:none;"><?php echo $registros; ?></td>
                <?php endif; ?>
                <td><?php echo $row['cli_codigo']; ?></td>
                <td><?php echo $nombre; ?></td>
                <td><?php echo $row['art_nombre']; ?></td>
                <td><?php echo formatear_fecha('d-m-Y', $row['sxc_fecha_contrato']); ?></td>
                <td><?php echo ''; ?></td>
                <td><?php echo ($row['ultima_factura'] != null) ? formatear_fecha('d-m-Y', $row['ultima_factura']) : ''; ?></td>
            </tr>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        $registros++;
    endforeach;
    if ($tipo_reporte != '') {
        ?>
                </tbody>
            </table>
        <?php } ?>