<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$mes = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
$m1 = explode('-', $fec_saldo);
$m2 = explode('-', $fec_cuota);
$pdf = ($reporte == 'pdf') ? true : false;

if ($reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Cuotas por Cobrar
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}

if ($reporte != '') {
?>
    <style type="text/css">
        table th {
            text-align: center;
            font-weight: bold;
        }
    </style>
<?php
}
?>

<table class="responsive table table-bordered display dynamicTable dataTable" id="tblClientes" name="tblClientes" border="1" cellpadding="2">
    <thead>
        <tr>
            <th <?= ($pdf) ? 'width="7%"' : ''; ?>>Código</th>
            <th <?= ($pdf) ? 'width="39%"' : ''; ?>>Nombre</th>
            <th <?= ($pdf) ? 'width="11%"' : ''; ?>>Hasta <br><?= $mes[intval($m1[1])] ?> / <?= $m1[0] ?></th>
            <th <?= ($pdf) ? 'width="11%"' : ''; ?>><?= $mes[intval($m2[1])] ?> / <?= $m2[0] ?></th>
            <th <?= ($pdf) ? 'width="11%"' : ''; ?>>Abonos</th>
            <th <?= ($pdf) ? 'width="11%"' : ''; ?>>Total a Cobrar</th>
            <th <?= ($pdf) ? 'width="10%"' : ''; ?>>Fecha Último Abono</th>
        </tr>
    </thead>
    <tbody>
        <?php if (count($registros) > 0) {
            $total_saldo = $total_cuota = $total_abono = $gran_total = 0;
            foreach ($registros as $key => $value) {
                $cuota = ($value["CUOTA"] != "") ? $value["CUOTA"] : 0;
                $cuota_real = ($value["cuota_mensual"] > 0) ? $value["cuota_mensual"] : $cuota;
                $saldo_pago = ($value["saldo_pendiente"] - $value["abonos_de_saldos_pendientes"]);
                $saldo_pdte = number_format($value['masivas_mes'], 2, '.', '') + $value["vale_consumo"];
                if ($saldo_pago < 0) {
                    $saldo_favor = abs($saldo_pago);
                    $cuota_anter = $saldo_pdte;
                } else {
                    $saldo_favor = 0;
                    $cuota_anter = $saldo_pdte + $saldo_pago;
                }
                $cli_saldo = ($cuota_real + $cuota_anter) - $saldo_favor;
                $total_saldo += $cuota_anter;
                $total_cuota += $cuota_real;
                $total_abono += $saldo_favor;
                $gran_total += $cli_saldo;
        ?>
                <tr nobr="true">
                    <td <?= ($pdf) ? 'width="7%"' : ''; ?>><?= $value['cli_codigo'] ?></td>
                    <td <?= ($pdf) ? 'width="39%"' : ''; ?>><?= $value['cliente'] ?></td>
                    <td <?= ($pdf) ? 'width="11%"' : ''; ?> style="text-align: right;"><?= $simbolo . number_format($cuota_anter, 2) ?></td>
                    <td <?= ($pdf) ? 'width="11%"' : ''; ?> style="text-align: right;"><?= $simbolo . number_format($cuota_real, 2) ?></td>
                    <td <?= ($pdf) ? 'width="11%"' : ''; ?> style="text-align: right;"><?= $simbolo . number_format($saldo_favor, 2) ?></td>
                    <td <?= ($pdf) ? 'width="11%"' : ''; ?> style="text-align: right;"><?= $simbolo . number_format($cli_saldo, 2) ?></td>
                    <td <?= ($pdf) ? 'width="10%"' : ''; ?>><?= formatear_fecha('d-m-Y', $value['ultimo_abono']) ?></td>
                </tr>
            <?php
            }
        } else {
            if ($reporte != '') {
            ?>
                <tr>
                    <td colspan="7" style="text-align: center;"><b>No se encontraron registros</b></td>
                </tr>
        <?php
            }
        }
        ?>
    </tbody>
    <?php if (count($registros) > 0) { ?>
        <tfoot>
            <tr>
                <td colspan="2" style="text-align: right;"><b>Totales </b></td>
                <td style="text-align: right;"><b><?= $simbolo . number_format($total_saldo, 2) ?></b></td>
                <td style="text-align: right;"><b><?= $simbolo . number_format($total_cuota, 2) ?></b></td>
                <td style="text-align: right;"><b><?= $simbolo . number_format($total_abono, 2) ?></b></td>
                <td style="text-align: right;"><b><?= $simbolo . number_format($gran_total, 2) ?></b></td>
                <td></td>
            </tr>
        </tfoot>
    <?php } ?>
</table>

<?php if ($reporte == '') { ?>
    <script>
        $(document).ready(function() {
            $('#tblClientes').dataTable({
                "bAutoWidth": false,
                "aLengthMenu": [
                    [10, 25, 50, -1],
                    [10, 25, 50, "Todos"]
                ]
            });
        });
    </script>
<?php } ?>