<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de facturación masiva
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td {
            vertical-align: middle;
            text-align: center;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 10;
        }

        .tabla tfoot td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 9;
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla">
    <?php } else { ?>
        <table class="responsive dynamicTable display table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="1" style="margin-left: 4px; width: 99%; font-size:12px;">
        <?php } ?>
        <thead>
            <tr>
                <?php if ($anulacion) : /*Para proceso de anulacion masiva de facturas*/ ?>
                    <th>
                        <center style="font-size: 10px;"><span>Todos: </span><input type="checkbox" id="checkh" class="nostyle"></center><br>
                        <span>Anular</span>
                    </th>
                <?php endif ?>
                <th>Código</th>
                <th>Cliente</th>
                <th>Servicios</th>
                <th>Tipo de factura</th>
                <th># Factura</th>
                <th>Fecha</th>
                <th>PERÍODO</th>
                <th>Subtotal</th>
                <th>Total</th>
                <?php if ($tipo_vista == 'p') { ?>
                    <th>Acciones</th>
                <?php } ?>
            </tr>
        </thead>
        <tbody id="tbl_contenedor_clientes">
            <?php if (count($facturas) > 0) :
                $sub_total  = 0;
                $total      = 0;
                foreach ($facturas as $lst) :
                    $sub_total = $sub_total + $lst['fac_subtotal'];
                    $total     = $total + $lst['fac_total'];
                    $cliente   = ($lst['cli_personeria'] == 1) ? $lst['cli_nombre'] . " " . $lst['cli_apellido'] : $lst['cli_apellido'];
                    $numero_factura = $lst["fac_numero"];
                    if ($tipo_reporte == "") {
                        $numero_factura = '<a href="#divform2" class="linker2" onclick="javascript:clicker2(' . $lst['fac_id'] . ');" name="' . $lst['fac_id'] . '">' . $lst["fac_numero"] . '</a>';
                    }
            ?>
                    <tr id="tr_<?php echo $lst['fac_id']; ?>" class="tr_facturas" noBr="true">
                        <?php if ($anulacion) : ?>
                            <td>
                                <input type="checkbox" id="chkAnular_<?= $lst['fac_id'] ?>" class="nostyle chkAnular" data-id="<?= $lst['fac_id'] ?>" />
                                <input type="hidden" name="anular[]" value="0" class="se_anula" id="anular_<?= $lst['fac_id'] ?>">
                            </td>
                        <?php endif ?>
                        <td><input type="hidden" name="factura_inicio[]" value="<?= $lst['fac_id'] ?>"><?php echo $lst['cli_codigo']; ?></td>
                        <td><input type="hidden" name="factura_pct[]" value="<?= $lst['fac_id_pct'] ?>"><?php echo $cliente; ?></td>
                        <td><input type="hidden" name="factura_num[]" value="<?= $lst['fac_numero'] ?>"><?php echo $lst['Servicios']; ?></td>
                        <td><?php echo $lst['tif_abreviacion']; ?></td>
                        <td><?php echo $numero_factura; ?></td>
                        <td><?php echo formatear_fecha('d-m-Y', $lst['fac_fecha_fact']); ?></td>
                        <td><?php echo ($lst['fac_generacion_masiva'] == 1) ? $lst['fac_nombre_factura'] : ""; ?></td>
                        <td><?php echo $lst['fac_subtotal']; ?></td>
                        <td><?php echo $lst['fac_total']; ?></td>
                        <?php if ($tipo_vista == 'p') { ?>
                            <td align="center" width="20%" class="autorizar">
                                <div class="tools">
                                    <div class="btn-group">
                                        <button type="button" class="btn">Acciones</button>
                                        <button type="button" class="btn dropdown-toggle" data-toggle="dropdown">
                                            <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <?php if ($anulacion == false) { ?>
                                                <li>
                                                    <a target="_blank" href="<?php echo base_url('facturacion/facturar/imprimir_factura') . '/' . $lst['fac_id']; ?>" title="Imprimir">
                                                        <span class="icon16  icomoon-icon-printer"></span>
                                                        Imprimir
                                                    </a>
                                                </li>
                                            <?php } else { ?>
                                                <li>
                                                    <a href="#modal_ver" title="Detalle" class="ver" data-numero="<?php echo $lst['fac_numero']; ?>" id="<?php echo $lst['fac_id']; ?>">
                                                        <span class="icon16 icomoon-icon-search-3"></span>
                                                        ver
                                                    </a>
                                                </li>
                                                <li>
                                                    <a href="#modal_anular" title="Anular" class="anular" data-numero="<?php echo $lst['fac_numero']; ?>" id="<?php echo $lst['fac_id']; ?>">
                                                        <span class="icon16 iconic-icon-denied"></span>
                                                        Anular
                                                    </a>
                                                </li>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                    <div class="clear"></div>
                                </div>
                            </td>
                        <?php } ?>
                    </tr>
                <?php endforeach;
            else : ?>
            <?php endif; ?>
        </tbody>
        <tfoot>
            <?php $colspan = ($anulacion) ? 8 : 7; ?>
            <tr>
                <td colspan="<?= $colspan ?>" style="text-align: right;"><b>Totales </b></td>
                <td><?php echo $simbolo . number_format($sub_total, 2, ".", ","); ?></td>
                <td><?php echo $simbolo . number_format($total, 2, ".", ","); ?></td>
            </tr>
        </tfoot>
        </table>

        <?php if ($tipo_reporte == '') { ?>
            <script>
                $(document).ready(function() {

                    $('#tbl_facturas').dataTable({
                        "bAutoWidth": false,
                        "aLengthMenu": [
                            [10, 25, 50, -1],
                            [10, 25, 50, "Todos"]
                        ]
                    });

                    if ($("#tbl_facturas tr").length > 1) {
                        $("#dv_contenedor_clientes").css({
                            'height': 'auto',
                            'width': 'auto',
                            'padding-bottom': '120px'
                        });
                        $("html, body").animate({
                            scrollTop: $(document).height() - $(window).height()
                        });
                    }

                });
            </script>
        <?php } ?>