<?php    //Declaracion de variables para totales
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$venta_no_sujeta      = 0.00;
$ventas_exentas       = 0.00;
$ventas_exportaciones = 0.00;
$ventas_gravadas      = 0.00;
$venta_total          = 0.00;
$retencion_total      = 0.00;
$impuesto_total       = 0.00;
if ($tipo_reporte != "csv") {
    if ($tipo_reporte == 'excel') {
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("content-disposition: attachment;filename=" . $filename . ".xls");
        header("Pragma: no-cache");
        header("Expires: 0");
    }
    ?>
    <?php if ($tipo_reporte == 'excel' or $tipo_reporte == 'pdf') { ?>
        <meta charset="utf-8" />
        <div class="head">
            <table border="0" style="text-align: left;">
                <tr>
                    <td colspan="4" height="20px">
                        <h3><?php echo $empresa; ?></h3>
                        <?php if (isset($propietario) && $propietario != "") : ?>
                            <span style="font-size: 8px; font-weight: bold;"><?= $propietario ?></span>
                        <?php endif ?>
                    </td>
                    <td colspan="2"></td>
                </tr>
                <tr>
                    <td colspan="5">
                        <h4><?php echo strtoupper($titulo) ?></h4>
                    </td>
                    <td height="15px" style="text-align: right;"><?php echo '<b>NRC</b>: ' . $NRC; ?></td>
                </tr>
                <tr>
                    <td colspan="5"></td>
                    <td style="text-align: right;"><?php echo '<b>NIT</b>: ' . $NIT; ?></td>
                </tr>
            </table>
        </div>
    <?php } ?>
    <style>
        .dynamicTable tr th {
            text-align: center;
            border: solid 1px black;
            font-weight: bold;
        }
        .dynamicTable .dinero {
            text-align: right;
        }
        .dynamicTable .total {
            text-align: right;
            border-top: 1px solid silver;
            font-weight: bold;
        }
    </style>
    <table cellpadding="2" cellspacing="0" border="0" <?php echo ($tipo_reporte != "pdf") ? 'style="font-size: 11px;"' : 'style="font-size: 7px;"'; ?> id="tblListado" class="dynamicTable responsive display table table-bordered" aria-describedby="table_2_info">
        <thead>
            <?php if ($tipo_reporte == 'excel' or $tipo_reporte == 'pdf') { ?>
                <tr>
                    <th colspan="4"><?php echo $periodotext; ?></th>
                    <td colspan="4" style="text-align: right;"><?php echo $sub_titulo; ?></td>
                    <td colspan="<?=($esf_elect==1)?8:4;?>"></td>
                </tr>
            <?php }
            if ($esf_elect==1) {
                if ($tipo_fecha == 1) {
                    ?>
                    <tr>
                        <th>&nbsp;#&nbsp;</th>
                        <th>FECHA FACTURADA</th>
                        <th>FECHA CONTAB</th>
                        <th>CORR. INTERNO</th>
                        <th>REFERENCIA</th>
                        <th>CLIENTE</th>
                        <th>DUI / NIT</th>
                        <th>COD GENERACION</th>
                        <th>NUM. CONTROL</th>
                        <th>SELLO RECIBIDO</th>
                        <th>SELLO INVALIDACION</th>
                        <th>CAJA</th>
                        <th>TIPO DOC</th>
                        <th>VENTAS EXENTAS</th>
                        <th>VENTAS GRAVADAS</th>
                        <th>EXPORTACION</th>
                        <th>VENTAS NO SUJETAS</th>
                        <th>RETENCIÓN</th>
                        <th>VENTA TOTAL</th>
                    </tr>
                    <?php
                } else {
                    ?>
                    <tr>
                        <th rowspan="2">&nbsp;#&nbsp;</th>
                        <th rowspan="2" >FECHA CONTAB</th>
                        <th colspan="2" <?= ($tipo_reporte != '') ? '' : 'style="color:white;background:#0167B1!important;"';?>>DOCS. EMITIDOS</th>
                        <th rowspan="2" >CAJA</th>
                        <th rowspan="2" >TIPO DOC</th>
                        <th rowspan="2" >VENTAS EXENTAS</th>
                        <th rowspan="2" >VENTAS GRAVADAS</th>
                        <th rowspan="2" >EXPORTAC.</th>
                        <th rowspan="2" >VENTAS NO SUJETAS</th>
                        <th rowspan="2" >RETENCIÓN</th>
                        <th rowspan="2" >VENTA TOTAL</th>
                        <!-- <th rowspan="2" >NUM. CONTROL</th>
                        <th rowspan="2" >SELLO RECIBIDO</th>
                        <th rowspan="2" >CLIENTE</th>
                        <th rowspan="2" >DUI / NIT</th>
                        <th rowspan="2" >CORR. INTERNO</th> -->
                    </tr>
                    <tr>
                        <th >DEL</th>
                        <th >AL</th>
                    </tr>
                <?php
                }
            } else {
                ?>
                <tr>
                    <th width="4%" rowspan="2" style="vertical-align: middle;">#&nbsp;&nbsp;</th>
                    <th width="9%" rowspan="2" style="vertical-align: middle;"><?php echo ($tipo_fecha == 1) ? 'FECHA<br>FACTURADA' : 'FECHA<br>GENERADA'; ?></th>
                    <th width="14%" colspan="2" <?php echo ($tipo_reporte != '') ? '' : 'style="color: white; background: #0167B1!important;"'; ?>>DOCS EMITIDOS</th>
                    <th width="9%" rowspan="2" style="vertical-align: middle;">CAJA</th>
                    <th width="10%" rowspan="2" style="vertical-align: middle;">TIPO DOC</th>
                    <th width="9%" rowspan="2" style="vertical-align: middle;">VENTAS EXENTAS</th>
                    <th width="9%" rowspan="2" style="vertical-align: middle;">VENTAS GRAVADAS</th>
                    <th width="9%" rowspan="2" style="vertical-align: middle;">EXPORTAC.</th>
                    <th width="9%" rowspan="2" style="vertical-align: middle;">VENTAS NO SUJETAS</th>
                    <th width="9%" rowspan="2" style="vertical-align: middle;">RETENCIÓN</th>
                    <th width="9%" rowspan="2" style="vertical-align: middle;">VENTA TOTAL</th>
                </tr>
                <tr>
                    <th width="7%">DEL</th>
                    <th width="7%">AL</th>
                </tr>
            <?php } ?>
        </thead>
        <tbody>
            <?php if (count($reporte) > 0) {
                $i = 0;
                $k = 0;
                $venta_no_sujeta_fila     = 0;
                $total_venta_exenta_fila  = 0;
                $total_venta_gravado_fila = 0;
                $fac_exportaciones_fila   = 0;
                $retencion_fac_fila       = 0;
                $total_fac_fila           = 0;
                if (!($esf_elect==1 && $tipo_fecha != 1)) {

                    $numero_inicial      = $reporte[0]['serie'] . $reporte[0]['numero'];
                    $numero_final        = $reporte[0]['serie'] . $reporte[0]['numero'];
                    $fecha_inicial       = $reporte[0]['fecha'];

                    $tipo_factura        = $reporte[0]['tif_abreviacion'];
                    $estado_factura      = $reporte[0]['estado_factura'];
                    $caja                = $reporte[0]['caj_nombre'];
                    $numero_inicial_ctrl = $reporte[0]['serie'] . $reporte[0]['numero'];
                    $codigo_inicial      = $reporte[0]['codigo_fecha'];
                    $cod_ini             = $reporte[0]['codigo_fecha_estado'];
                }
                foreach ($reporte as $key => $rep) {
                    if ($esf_elect==1) {
                        if ($tipo_fecha == 1) {
                            if ($rep['estado_factura'] == 0 or $rep['total_venta_exenta'] > 0) {
                                $tipo_factura = ($rep['estado_factura'] == 0) ? $rep['tif_abreviacion'] . " - ANULADA" : $rep['tif_abreviacion'];
                                $total_venta_exenta_fila  = ($rep['total_venta_exenta']>0 && $rep['fac_id_tif']!= $id_tif_expt)?round($rep['total_venta_exenta'],2):0;
                                $total_venta_gravado_fila = ($rep['total_venta_exenta']>0)?0: round((abs($rep['total_venta_gravado'] + $rep['impuesto_fac'] - $rep['total_venta_exenta'])), 2);
                                $fac_exportaciones_fila   = ($rep['total_venta_exenta']>0 && $rep['fac_id_tif']==$id_tif_expt)?round($rep['fac_exportaciones'],2):0;
                                $venta_no_sujeta_fila     = ($rep['total_venta_exenta'] > 0) ? round($rep['venta_no_sujeta'], 2) : 0;
                                $retencion_fac_fila       = ($rep['total_venta_exenta'] > 0) ? round($rep['retencion_fac'], 2) : 0;
                                $total_fac_fila           = ($rep['total_venta_exenta'] > 0) ? round($rep['venta_total'], 2) : (round(($rep['total_venta_gravado']+$rep['impuesto_fac']),2));
                            } else {
                                $tipo_factura = $rep['tif_abreviacion'];
                                $total_venta_exenta_fila  = round($rep['total_venta_exenta'], 2);
                                $total_venta_gravado_fila = round(($rep['total_venta_gravado'] + $rep['impuesto_fac']), 2);
                                $fac_exportaciones_fila   = round($rep['fac_exportaciones'], 2);
                                $venta_no_sujeta_fila     = round($rep['venta_no_sujeta'], 2);
                                $retencion_fac_fila       = round($rep['retencion_fac'], 2);
                                $total_fac_fila           = ($rep['total_venta_exenta'] > 0)?round($rep['venta_total'],2):round(($rep['total_venta_gravado']+$rep['impuesto_fac']),2);
                            }
                            $meshecho = formatear_fecha("Ym", $rep['fac_fecha_cont']);
                            $mesanulo = formatear_fecha("Ym", $rep['fac_fecha_anulacion']);
                            if ($rep['estado_factura'] == 0) {
                                if ($meshecho < $mesanulo) {
                                    $ventas_exentas       += round($total_venta_exenta_fila, 2);
                                    $ventas_gravadas      += round($total_venta_gravado_fila, 2);
                                    $ventas_exportaciones += round($fac_exportaciones_fila, 2);
                                    $venta_no_sujeta      += round($venta_no_sujeta_fila, 2);
                                    $retencion_total      += round($retencion_fac_fila, 2);
                                    $venta_total          += round($total_fac_fila, 2);
                                    $impuesto_total       += round($rep['impuesto_fac'], 2);
                                }
                            } else {
                            $ventas_exentas       += (($rep['estado_factura'] == 0) ? 0 : round($total_venta_exenta_fila, 2));
                            $ventas_gravadas      += (($rep['estado_factura'] == 0) ? 0 : round($total_venta_gravado_fila, 2));
                            $ventas_exportaciones += (($rep['estado_factura'] == 0) ? 0 : round($fac_exportaciones_fila, 2));
                            $venta_no_sujeta      += (($rep['estado_factura'] == 0) ? 0 : round($venta_no_sujeta_fila, 2));
                            $retencion_total      += (($rep['estado_factura'] == 0) ? 0 : round($retencion_fac_fila, 2));
                            $venta_total          += (($rep['estado_factura'] == 0) ? 0 : round($total_fac_fila, 2));
                            $impuesto_total       += (($rep['estado_factura'] == 0) ? 0 : round($rep['impuesto_fac'], 2));
                            }                            
                            $k++;
                            ?>
                            <tr nobr="true">
                                <td><?= $k ?></td>
                                <td>
                                    <?php if (!($tipo_reporte != '')): ?>
                                        <span style="display:none;"><?= formatear_fecha("Ymd", $rep['fecha']) ?></span>
                                    <?php endif ?>
                                    <span><?= $rep['fecha'] ?></span>
                                </td>
                                <td >
                                    <?php if (!($tipo_reporte != '')): ?>
                                        <span style="display:none;"><?= formatear_fecha("Ymd", $rep['fac_fecha_cont']) ?></span>
                                    <?php endif ?>
                                    <span><?= formatear_fecha("d-m-Y", $rep['fac_fecha_cont']) ?></span>
                                </td>
                                <td ><?= $rep['numero'] ?></td>
                                <td ><?= $rep['fac_referencia_externa'] ?></td>
                                <td ><?= $rep['cli_nombre'] ?></td>
                                <td ><?= $rep['documento_cliente'] ?></td>
                                <td ><?= $rep['fac_codigo_generacion'] ?></td>
                                <td ><?= $rep['fac_numero_control'] ?></td>
                                <td ><?= $rep['fac_sello_recepcion'] ?></td>
                                <td ><?= $rep['fac_sello_anulacion_fact_elect'] ?></td>
                                <td ><?= $rep['caj_nombre'] ?></td>
                                <td ><?= $tipo_factura ?></td>
                                <td  class="dinero"><?php echo ($rep['estado_factura'] == 0 && $meshecho == $mesanulo) ? '-' : number_format($total_venta_exenta_fila, 2); ?></td>
                                <td  class="dinero"><?php echo ($rep['estado_factura'] == 0 && $meshecho == $mesanulo) ? '-' : number_format($total_venta_gravado_fila, 2); ?></td>
                                <td  class="dinero"><?php echo ($rep['estado_factura'] == 0 && $meshecho == $mesanulo) ? '-' : number_format($fac_exportaciones_fila, 2); ?></td>
                                <td  class="dinero"><?php echo ($rep['estado_factura'] == 0 && $meshecho == $mesanulo) ? '-' : number_format($venta_no_sujeta_fila, 2); ?></td>
                                <td  class="dinero"><?php echo ($rep['estado_factura'] == 0 && $meshecho == $mesanulo) ? '-' : number_format($retencion_fac_fila, 2); ?></td>
                                <td  class="dinero"><?php echo ($rep['estado_factura'] == 0 && $meshecho == $mesanulo) ? '-' : number_format($total_fac_fila, 2); ?></td>
                            </tr>
                            <?php
                        } else {
                            $total_venta_exenta_fila    = round($rep['total_venta_exenta'],2);
                            $total_venta_gravado_fila   = round(($rep['total_venta_gravado'] + $rep['impuesto_fac']), 2);
                            $fac_exportaciones_fila     = round($rep['fac_exportaciones'],2);
                            $venta_no_sujeta_fila       = round($rep['venta_no_sujeta'], 2);
                            $retencion_fac_fila         = round($rep['retencion_fac'], 2);
                            $total_fac_fila             = round($rep['venta_total'], 2);
                            $ventas_exentas         += ($rep['total_venta_exenta'] > 0) ? round($total_venta_exenta_fila, 2) : 0;
                            $ventas_gravadas        += ($rep['total_venta_gravado'] > 0) ? round($total_venta_gravado_fila, 2) : 0;
                            $ventas_exportaciones   += ($rep['fac_exportaciones'] > 0) ? round($fac_exportaciones_fila, 2) : 0;
                            $venta_no_sujeta        += ($rep['venta_no_sujeta'] > 0) ? round($venta_no_sujeta_fila, 2) : 0;
                            $retencion_total        += ($rep['retencion_fac'] > 0) ? round($retencion_fac_fila, 2) : 0;
                            $venta_total            += ($rep['venta_total'] > 0) ? round($total_fac_fila, 2) : 0;
                            $k++;
                            ?>
                            <tr nobr="true">
                                <td><?= $k ?></td>
                                <td >
                                    <?php if (!($tipo_reporte != '')): ?>
                                        <span style="display:none;"><?= formatear_fecha("Ymd", $rep['fac_fecha_cont']) ?></span>
                                    <?php endif ?>
                                    <span><?= formatear_fecha("d-m-Y", $rep['fac_fecha_cont']) ?></span>
                                </td>
                                <td ><?= $rep['nmin'] ?></td>
                                <td ><?= $rep['nmax'] ?></td>
                                <td ><?= $rep['caj_nombre'] ?></td>
                                <td ><?= $rep['tif_abreviacion'] ?></td>
                                <td class="dinero"><?= ($rep['total_venta_exenta'] > 0)  ? number_format($total_venta_exenta_fila, 2) : '-'; ?></td>
                                <td class="dinero"><?= ($rep['total_venta_gravado'] > 0) ? number_format($total_venta_gravado_fila, 2) : '-'; ?></td>
                                <td class="dinero"><?= ($rep['fac_exportaciones'] > 0) ? number_format($fac_exportaciones_fila, 2): '-'; ?></td>
                                <td class="dinero"><?= ($rep['venta_no_sujeta'] > 0) ? number_format($venta_no_sujeta_fila, 2) : '-'; ?></td>
                                <td class="dinero"><?= ($rep['retencion_fac'] > 0) ? number_format($retencion_fac_fila, 2) : '-'; ?></td>
                                <td class="dinero"><?= ($rep['venta_total'] > 0) ? number_format($total_fac_fila, 2) : '-'; ?></td>
                            </tr>
                            <?php
                        }                        
                    } else {
                        // $rep['total_venta_gravado']   = $rep['venta_total'] - $rep['impuesto_fac'];
                        // if ($key==0 && $rep['estado_factura'] != 0) {
                        $numero_inicial_ctrl++; // = $reporte[1]['numero'];
                        //}
                        //totales finales
                        // $venta_no_sujeta += (($rep['estado_factura'] == 0)? 0:$rep['venta_no_sujeta']);
                        // $ventas_exentas += (($rep['estado_factura'] == 0)? 0:$rep['total_venta_exenta']);
                        // $ventas_exportaciones += (($rep['estado_factura'] == 0)? 0:$rep['fac_exportaciones']);
                        // $ventas_gravadas += (($rep['estado_factura'] == 0)? 0:(abs($rep['total_venta_gravado']-$rep['total_venta_exenta']))+$rep['impuesto_fac']);
                        // $venta_total += (($rep['estado_factura'] == 0)? 0:$rep['venta_total']);
                        // $retencion_total += (($rep['estado_factura'] == 0)? 0:$rep['retencion_fac']); 
                        // $impuesto_total += (($rep['estado_factura'] == 0)? 0:$rep['impuesto_fac']); 
                        //totales finales
                        $i++;
                        //si es estado anulado o exenta hacer una linea independiente.
                        if ($rep['estado_factura'] == 0 or $rep['total_venta_exenta'] > 0) {
                            $venta_no_sujeta_fila += ($rep['total_venta_exenta'] > 0) ? round($rep['venta_no_sujeta'], 2) : 0;
                            $total_venta_exenta_fila += ($rep['total_venta_exenta'] > 0 && $rep['fac_id_tif'] != $id_tif_expt) ? round($rep['total_venta_exenta'], 2) : 0;
                            $total_venta_gravado_fila += ($rep['total_venta_exenta'] > 0) ? 0 : round((abs($rep['total_venta_gravado'] - $rep['total_venta_exenta'])), 2);
                            $fac_exportaciones_fila += ($rep['total_venta_exenta'] > 0 && $rep['fac_id_tif'] == $id_tif_expt) ? round($rep['fac_exportaciones'], 2) : 0;
                            $retencion_fac_fila += ($rep['total_venta_exenta'] > 0) ? round($rep['retencion_fac'], 2) : 0;
                            $total_fac_fila += ($rep['total_venta_exenta'] > 0) ? round($rep['venta_total'], 2) : 0;
                            // ($rep['venta_no_sujeta'] + $rep['total_venta_exenta'] + $rep['total_venta_gravado']*1.13 + $rep['fac_exportaciones']);
                            //totales finales
                            $impuesto_total         += (($rep['estado_factura'] == 0) ? 0 : round($rep['impuesto_fac'], 2));
                            $venta_no_sujeta        += (($rep['estado_factura'] == 0) ? 0 : round($venta_no_sujeta_fila, 2));
                            $ventas_exentas         += (($rep['estado_factura'] == 0) ? 0 : round($total_venta_exenta_fila, 2));
                            $ventas_exportaciones   += (($rep['estado_factura'] == 0) ? 0 : round($fac_exportaciones_fila, 2));
                            $ventas_gravadas        += (($rep['estado_factura'] == 0) ? 0 : round($total_venta_gravado_fila, 2));
                            $retencion_total        += (($rep['estado_factura'] == 0) ? 0 : round($retencion_fac_fila, 2));
                            $venta_total            += (($rep['estado_factura'] == 0) ? 0 : round($total_fac_fila, 2));
                            //totales finales
                            $tipo_factura = ($rep['estado_factura'] == 0) ? $rep['tif_abreviacion'] . " - ANULADA" : $rep['tif_abreviacion'] . " - EXENTA";
                            $k++;
                            ?>
                            <tr nobr="true">
                                <td width="4%"><?= $k ?></td>
                                <td width="9%"><?= $rep['fecha'] ?></td>
                                <td width="7%"><?= $rep['serie'] . $rep['numero'] ?></td><!--DESDE-->
                                <td width="7%"><?= $rep['serie'] . $rep['numero'] ?></td><!--HASTA-->
                                <td width="9%"><?= $rep['caj_nombre'] ?></td>
                                <td width="10%"><?= $tipo_factura ?></td>
                                <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_venta_exenta_fila, 2); ?></td>
                                <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_venta_gravado_fila, 2); ?></td>
                                <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($fac_exportaciones_fila, 2); ?></td>
                                <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($venta_no_sujeta_fila, 2); ?></td>
                                <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($retencion_fac_fila, 2); ?></td>
                                <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_fac_fila, 2); ?></td>
                            </tr>
                            <?php
                            $numero_inicial = (isset($reporte[$i]['numero']) && isset($reporte[$i]['serie'])) ? $reporte[$i]['serie'] . $reporte[$i]['numero'] : $numero_inicial;
                            $fecha_inicial = (isset($reporte[$i]['fecha'])) ? $reporte[$i]['fecha'] : $fecha_inicial;
                            $tipo_factura = (isset($reporte[$i]['tif_abreviacion'])) ? $reporte[$i]['tif_abreviacion'] : $tipo_factura;
                            $estado_factura = (isset($reporte[$i]['estado_factura'])) ? $reporte[$i]['estado_factura'] : $estado_factura;
                            $caja = (isset($reporte[$i]['caj_nombre'])) ? $reporte[$i]['caj_nombre'] : $caja;
                            $numero_inicial_ctrl = (isset($reporte[$i]['numero']) && isset($reporte[$i]['serie'])) ? $reporte[$i]['serie'] . $reporte[$i]['numero'] : $numero_inicial_ctrl;
                            // $numero_inicial_ctrl = $rep['numero'];
                            $codigo_inicial = (isset($reporte[$i]['codigo_fecha'])) ? $reporte[$i]['codigo_fecha'] : $codigo_inicial;
                            $venta_no_sujeta_fila = 0;
                            $total_venta_exenta_fila = 0;
                            $total_venta_gravado_fila = 0;
                            $fac_exportaciones_fila = 0;
                            $retencion_fac_fila = 0;
                            $total_fac_fila = 0;
                            $cod_ini = (isset($reporte[$i]['codigo_fecha_estado'])) ? $reporte[$i]['codigo_fecha_estado'] : $cod_ini;
                        } else {
                            if ($cod_ini == $rep['codigo_fecha_estado']) {
                                $venta_no_sujeta_fila += round($rep['venta_no_sujeta'], 2);
                                $total_venta_exenta_fila += round($rep['total_venta_exenta'], 2);
                                $total_venta_gravado_fila += round(($rep['total_venta_gravado'] + $rep['impuesto_fac']), 2);
                                $fac_exportaciones_fila += round($rep['fac_exportaciones'], 2);
                                $retencion_fac_fila += round($rep['retencion_fac'], 2);
                                $total_fac_fila += ($rep['total_venta_exenta'] > 0) ? round($rep['venta_total'], 2) : round(($rep['total_venta_gravado'] + $rep['impuesto_fac']), 2);
                                $cod_iniv = (isset($reporte[$i]['codigo_fecha_estado'])) ? $reporte[$i]['codigo_fecha_estado'] : 0;
                                $caj_iniv = (isset($reporte[$i]['caj_id'])) ? $reporte[$i]['caj_id'] : 0;
                                if ($rep['codigo_fecha_estado'] != $cod_iniv || $rep['caj_id'] != $caj_iniv) {
                                    //totales finales
                                    $venta_no_sujeta += (($rep['estado_factura'] == 0) ? 0 : round($venta_no_sujeta_fila, 2));
                                    $ventas_exentas += (($rep['estado_factura'] == 0) ? 0 : round($total_venta_exenta_fila, 2));
                                    $ventas_exportaciones += (($rep['estado_factura'] == 0) ? 0 : round($fac_exportaciones_fila, 2));
                                    $ventas_gravadas += (($rep['estado_factura'] == 0) ? 0 : round($total_venta_gravado_fila, 2));
                                    $venta_total += (($rep['estado_factura'] == 0) ? 0 : round($total_fac_fila, 2));
                                    $retencion_total += (($rep['estado_factura'] == 0) ? 0 : round($retencion_fac_fila, 2));
                                    $impuesto_total += (($rep['estado_factura'] == 0) ? 0 : round($rep['impuesto_fac'], 2));
                                    //totales finales
                                    $k++;
                                    ?>
                                    <tr nobr="true">
                                        <td width="4%"><?= $k ?></td>
                                        <td width="9%"><?= $rep['fecha'] ?></td>
                                        <td width="7%"><?= $numero_inicial ?></td>
                                        <td width="7%"><?= $rep['serie'] . $rep['numero'] ?></td>
                                        <td width="9%"><?= $caja ?></td>
                                        <td width="10%"><?= $tipo_factura ?></td>
                                        <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_venta_exenta_fila, 2); ?></td>
                                        <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_venta_gravado_fila, 2); ?></td>
                                        <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($fac_exportaciones_fila, 2); ?></td>
                                        <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($venta_no_sujeta_fila, 2); ?></td>
                                        <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($retencion_fac_fila, 2); ?></td>
                                        <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_fac_fila, 2); ?></td>
                                    </tr>
                                    <?php
                                    $numero_inicial = (isset($reporte[$i]['numero']) && isset($reporte[$i]['serie'])) ? $reporte[$i]['serie'] . $reporte[$i]['numero'] : $numero_inicial;
                                    $cod_ini = (isset($reporte[$i]['codigo_fecha_estado'])) ? $reporte[$i]['codigo_fecha_estado'] : $cod_ini;
                                    $fecha_inicial = (isset($reporte[$i]['fecha'])) ? $reporte[$i]['fecha'] : $fecha_inicial;
                                    $tipo_factura = (isset($reporte[$i]['tif_abreviacion'])) ? $reporte[$i]['tif_abreviacion'] : $tipo_factura;
                                    $estado_factura = (isset($reporte[$i]['estado_factura'])) ? $reporte[$i]['estado_factura'] : $estado_factura;
                                    $caja = (isset($reporte[$i]['caj_nombre'])) ? $reporte[$i]['caj_nombre'] : $caja;
                                    $numero_inicial_ctrl = (isset($reporte[$i]['numero']) && isset($reporte[$i]['serie'])) ? $reporte[$i]['serie'] . $reporte[$i]['numero'] : $numero_inicial_ctrl;
                                    $codigo_inicial = (isset($reporte[$i]['codigo_fecha'])) ? $reporte[$i]['codigo_fecha'] : $codigo_inicial;
                                    $venta_no_sujeta_fila = 0;
                                    $total_venta_exenta_fila = 0;
                                    $total_venta_gravado_fila = 0;
                                    $fac_exportaciones_fila = 0;
                                    $retencion_fac_fila = 0;
                                    $total_fac_fila = 0;
                                } else {
                                    $impuesto_total += (($rep['estado_factura'] == 0) ? 0 : $rep['impuesto_fac']);
                                }                                
                            } else {
                                //totales finales
                                $venta_no_sujeta += (($rep['estado_factura'] == 0) ? 0 : round($venta_no_sujeta_fila, 2));
                                $ventas_exentas += (($rep['estado_factura'] == 0) ? 0 : round($total_venta_exenta_fila, 2));
                                $ventas_exportaciones += (($rep['estado_factura'] == 0) ? 0 : round($fac_exportaciones_fila, 2));
                                $ventas_gravadas += (($rep['estado_factura'] == 0) ? 0 : round($total_venta_gravado_fila, 2));
                                $venta_total += (($rep['estado_factura'] == 0) ? 0 : round($total_fac_fila, 2));
                                $retencion_total += (($rep['estado_factura'] == 0) ? 0 : round($retencion_fac_fila, 2));
                                $impuesto_total += (($rep['estado_factura'] == 0) ? 0 : round($rep['impuesto_fac'], 2));
                                    //totales finales
                                $k++;
                                ?>
                                <tr nobr="true">
                                    <td width="4%"><?= $k ?></td>
                                    <td width="9%"><?= $rep['fecha'] ?></td>
                                    <td width="7%"><?= $numero_inicial ?></td>
                                    <td width="7%"><?= $rep['serie'] . $rep['numero'] ?></td>
                                    <td width="9%"><?= $caja ?></td>
                                    <td width="10%"><?= $tipo_factura ?></td>
                                    <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_venta_exenta_fila, 2); ?></td>
                                    <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_venta_gravado_fila, 2); ?></td>
                                    <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($fac_exportaciones_fila, 2); ?></td>
                                    <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($venta_no_sujeta_fila, 2); ?></td>
                                    <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($retencion_fac_fila, 2); ?></td>
                                    <td width="9%" class="dinero"><?php echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_fac_fila, 2); ?></td>
                                </tr>
                                <?php
                                $numero_inicial = (isset($reporte[$i]['numero']) && isset($reporte[$i]['serie'])) ? $reporte[$i]['serie'] . $reporte[$i]['numero'] : $numero_inicial;
                                $cod_ini = (isset($reporte[$i]['codigo_fecha_estado'])) ? $reporte[$i]['codigo_fecha_estado'] : $cod_ini;
                                $fecha_inicial = (isset($reporte[$i]['fecha'])) ? $reporte[$i]['fecha'] : $fecha_inicial;
                                $tipo_factura = (isset($reporte[$i]['tif_abreviacion'])) ? $reporte[$i]['tif_abreviacion'] : $tipo_factura;
                                $estado_factura = (isset($reporte[$i]['estado_factura'])) ? $reporte[$i]['estado_factura'] : $estado_factura;
                                $caja = (isset($reporte[$i]['caj_nombre'])) ? $reporte[$i]['caj_nombre'] : $caja;
                                $numero_inicial_ctrl = (isset($reporte[$i]['numero']) && isset($reporte[$i]['serie'])) ? $reporte[$i]['serie'] . $reporte[$i]['numero'] : $numero_inicial_ctrl;
                                $codigo_inicial = (isset($reporte[$i]['codigo_fecha'])) ? $reporte[$i]['codigo_fecha'] : $codigo_inicial;
                                $venta_no_sujeta_fila = 0;
                                $total_venta_exenta_fila = 0;
                                $total_venta_gravado_fila = 0;
                                $fac_exportaciones_fila = 0;
                                $retencion_fac_fila = 0;
                                $total_fac_fila = 0;
                            }
                            
                        }                        
                    }
                    ?>
                    <?php
                }
            } else {
                if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') {
                    ?>
                    <tr nobr="true">
                        <td colspan="<?=($esf_elect==1 && $tipo_fecha==1) ? 17 : 12;?>" align="center">No se encontraron registros</td>
                    </tr>
                    <?php
                }
            } 
            if (count($anula_reporte) > 0 && $tipo_fecha == 1){
                $anula_total_venta_exenta_fila = 0;
                // $venta_no_sujeta_fila     = 0;
                // $total_venta_gravado_fila = 0;
                // $fac_exportaciones_fila   = 0;
                // $retencion_fac_fila       = 0;
                // $total_fac_fila           = 0;
                foreach ($anula_reporte as $ka => $va) {
                    if ($va['impuesto_fac'] > 0) {
                        $tipo_factura = $va['tif_abreviacion'];
                        $meshecho = formatear_fecha("Ym", $va['fac_fecha_cont']); 
                        $mesanulo = formatear_fecha("Ym", $va['fac_fecha_anulacion']);
                        $anula_total_venta_exenta_fila = ($va['total_venta_exenta'] > 0 && $va['fac_id_tif'] != $id_tif_expt) ? round($va['total_venta_exenta'], 2) : 0;
                        $anula_total_venta_gravado_fila = round(($va['total_venta_gravado'] + $va['impuesto_fac']), 2);
                        $anula_fac_exportaciones_fila   = round($va['fac_exportaciones'], 2);
                        $anula_venta_no_sujeta_fila = round($va['venta_no_sujeta'], 2);
                        $anula_retencion_fac_fila = round($va['retencion_fac'], 2);
                        $anula_total_fac_fila = round(  ($va['total_venta_exenta'] + $va['total_venta_gravado'] + $va['impuesto_fac']), 2);
                        ?>
                        <tr nobr="true">
                            <td><?= $k ?></td>
                            <td>
                                <?php if (!($tipo_reporte != '')): ?>
                                    <span style="display:none;"><?= formatear_fecha("Ymd", $va['fac_fecha_anulacion']) ?></span>
                                <?php endif ?>
                                <span><?= formatear_fecha("d-m-Y", $va['fac_fecha_anulacion']) ?></span>
                            </td>
                            <td >
                                <?php if (!($tipo_reporte != '')): ?>
                                    <span style="display:none;"><?= formatear_fecha("Ymd", $va['fac_fecha_cont']) ?></span>
                                <?php endif ?>
                                <span><?= formatear_fecha("d-m-Y", $va['fac_fecha_cont']) ?></span>
                            </td>
                            <td ><?= $va['numero'] ?></td>
                            <td ><?= $va['fac_referencia_externa'] ?></td>
                            <td ><?= $va['cli_nombre'] ?></td>
                            <td ><?= $va['documento_cliente'] ?></td>
                            <td ><?= $va['fac_codigo_generacion'] ?></td>
                            <td ><?= $va['fac_numero_control'] ?></td>
                            <td ><?= $va['fac_sello_recepcion'] ?></td>
                            <td ><?= $va['fac_sello_anulacion_fact_elect'] ?></td>
                            <td ><?= $va['caj_nombre'] ?></td>
                            <td ><?= $tipo_factura ?></td>
                            <td  class="dinero"><?php echo ($meshecho < $mesanulo) ? number_format((-1*$anula_total_venta_exenta_fila), 2) : '-'; ?></td>
                            <td  class="dinero"><?php echo ($meshecho < $mesanulo) ? number_format((-1*$anula_total_venta_gravado_fila), 2) : '-'; ?></td>
                            <td  class="dinero"><?php echo ($meshecho < $mesanulo) ? number_format((-1*$anula_fac_exportaciones_fila), 2) : '-'; ?></td>
                            <td  class="dinero"><?php echo ($meshecho < $mesanulo) ? number_format((-1*$anula_venta_no_sujeta_fila), 2) : '-'; ?></td>
                            <td  class="dinero"><?php echo ($meshecho < $mesanulo) ? number_format((-1*$anula_retencion_fac_fila), 2) : '-'; ?></td>
                            <td  class="dinero"><?php echo ($meshecho < $mesanulo) ? number_format((-1*$anula_total_fac_fila), 2) : '-'; ?></td>
                        </tr>
                        <?php
                        $ventas_exentas -= round($anula_total_venta_exenta_fila, 2);
                        $ventas_gravadas -= round($anula_total_venta_gravado_fila, 2);
                        $ventas_exportaciones -= round($anula_fac_exportaciones_fila, 2);
                        $venta_no_sujeta -= round($anula_venta_no_sujeta_fila, 2);
                        $retencion_total -= round($anula_retencion_fac_fila, 2);
                        $venta_total -= round($anula_total_fac_fila, 2);
                        $impuesto_total -= round($va['impuesto_fac'], 2);
                    }
                }
            }
            ?>
        </tbody>
        <tfoot>
            <tr nobr="true">
                <td colspan="<?=($esf_elect==1 && $tipo_fecha==1) ? 13 : 6;?>" width="46%" class="total">TOTALES</td>
                <td width="9%" class="total"><?php echo $simbolo . number_format($ventas_exentas, 2); ?></td>
                <td width="9%" class="total"><?php echo $simbolo . number_format($ventas_gravadas, 2); ?></td>
                <td width="9%" class="total"><?php echo $simbolo . number_format($ventas_exportaciones, 2); ?></td>
                <td width="9%" class="total"><?php echo $simbolo . number_format($venta_no_sujeta, 2); ?></td>
                <td width="9%" class="total"><?php echo $simbolo . number_format($retencion_total, 2); ?></td>
                <td width="9%" class="total"><?php echo $simbolo . number_format($venta_total, 2); ?></td>
            </tr>
        </tfoot>
    </table>
    <div class="clear"><br></div>
    <?php if ($tipo_reporte == 'pdf' or $tipo_reporte == 'excel') : ?>
        <table border="0" width="100%">
            <tr noBr="true">
                <td width="8%"></td>
                <td width="84%">
                    <table border="1" style="font-size: 8px;">
                        <tr style="text-align: center;">
                            <th width="44%"><b>&nbsp;RESUMEN DEL CÁLCULO DEL DÉBITO FISCAL</b></th>
                            <th width="14%"><b>&nbsp;VENTA NETA</b></th>
                            <th width="14%"><b>&nbsp;IVA</b></th>
                            <th width="14%"><b>&nbsp;VENTA TOTAL</b></th>
                            <th width="14%"><b>&nbsp;RETENCION</b></th>
                        </tr>
                        <?php
                        $venta_gravada_neta =  $ventas_gravadas - $impuesto_total;
                        $venta_neta = ($venta_no_sujeta + $ventas_exentas + $ventas_exportaciones + $venta_gravada_neta);
                        $iva = $impuesto_total; // $venta_gravada_neta * 0.13;
                        $venta_total = $venta_neta + $iva;
                        ?>
                        <tr>
                            <td><b>&nbsp;VENTAS EXENTAS</b></td>
                            <td style="text-align: right;"><?php echo ($ventas_exentas > 0) ? '$' . number_format($ventas_exentas, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;">&nbsp;</td>
                            <td style="text-align: right;"><?php echo ($ventas_exentas > 0) ? '$' . number_format($ventas_exentas, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;">&nbsp;</td>
                        </tr>
                        <tr>
                            <td><b>&nbsp;VENTAS GRAVADAS NETAS</b></td>
                            <td style="text-align: right;"><?php echo ($venta_gravada_neta > 0) ? '$' . number_format($venta_gravada_neta, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;"><?php echo ($venta_gravada_neta > 0) ? '$' . number_format($impuesto_total, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;"><?php echo ($venta_gravada_neta > 0) ? '$' . number_format($ventas_gravadas, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;"><?php echo ($retencion_total > 0) ? '$' . number_format($retencion_total, 2) : ''; ?>&nbsp;&nbsp;</td>
                        </tr>
                        <tr>
                            <td><b>&nbsp;VENTAS EXPORTACIONES</b></td>
                            <td style="text-align: right;"><?php echo ($ventas_exportaciones > 0) ? '$' . number_format($ventas_exportaciones, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;">&nbsp;</td>
                            <td style="text-align: right;"><?php echo ($ventas_exportaciones > 0) ? '$' . number_format($ventas_exportaciones, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;">&nbsp;</td>
                        </tr>
                        <tr>
                            <td><b>&nbsp;VENTAS NO SUJETAS</b></td>
                            <td style="text-align: right;"><?php echo ($venta_no_sujeta > 0) ? '$' . number_format($venta_no_sujeta, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;">&nbsp;</td>
                            <td style="text-align: right;">&nbsp;</td>
                            <td style="text-align: right;">&nbsp;</td>
                        </tr>
                        <tr>
                            <td style="text-align: right;font-weight: bold;"><b>TOTAL&nbsp;&nbsp;</b></td>
                            <td style="text-align: right;font-weight: bold;"><?php echo ($venta_neta > 0) ? '$' . number_format($venta_neta, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;font-weight: bold;"><?php echo ($iva > 0) ? '$' . number_format($iva, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;font-weight: bold;"><?php echo ($venta_total > 0) ? '$' . number_format($venta_total, 2) : ''; ?>&nbsp;&nbsp;</td>
                            <td style="text-align: right;font-weight: bold;"><?php echo ($retencion_total > 0) ? '$' . number_format($retencion_total, 2) : ''; ?>&nbsp;&nbsp;</td>
                        </tr>
                    </table>
                </td>
                <td width="8%"></td>
            </tr>
            <tr>
                <td colspan="3"></td>
            </tr>
            <tr>
                <td colspan="3"></td>
            </tr>
            <tr>
                <td colspan="3"></td>
            </tr>
            <tr>
                <td colspan="3"></td>
            </tr>
            <tr>
                <td colspan="3"></td>
            </tr>
            <tr>
                <td></td>
                <td>
                    <table border="0">
                        <tr>
                            <td width="20%"></td>
                            <td width="60%" align="center"><?php echo 'F.________________________________'; ?></td>
                            <td width="20%"></td>
                        </tr>
                        <tr>
                            <td></td>
                            <td align="center"><?php echo $firmas->REPRESENTANTE_LEGAL->NOMBRE; ?></td>
                            <td></td>
                        </tr>
                    </table>
                </td>
                <td></td>
            </tr>
        </table>
        <!-- 
        <table>
        <tr noBr="true">
            <td>
                <table border="0" width="100%">
                    <tr>
                        <td height="20px"></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">RESUMEN DEL CÁLCULO DEL DÉBITO FISCAL</td>
                        <td width="40%"></td>
                        <td width="10%"></td>
                    </tr>    
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">Ventas no sujetas:          //  </td>
                        <td width="40%"><?php // $simbolo .echo ($venta_no_sujeta > 0) ? number_format($venta_no_sujeta,2, '.', '') : '0.00';
                                        ?></td>
                        <td width="10%"></td>      
                    </tr>
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">Ventas exentas:             //  </td>
                        <td width="40%"><?php // $simbolo .echo ($ventas_exentas > 0) ? number_format($ventas_exentas,2, '.', '') : '0.00';
                                        ?></td>
                        <td width="10%"></td>      
                    </tr>
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">Ventas exportaciones:       //  </td>
                        <td width="40%"><?php // $simbolo .echo ($ventas_exportaciones > 0) ? number_format($ventas_exportaciones,2, '.', '') : '0.00';
                                        ?></td>
                        <td width="10%"></td>      
                    </tr>                    
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">Ventas gravadas netas:      //  </td>
                        <td width="40%"><?php // $simbolo .echo ($venta_gravada_neta > 0) ? (number_format($venta_gravada_neta,2, '.', '')) : '0.00';
                                        ?></td>
                        <td width="10%"></td>      
                    </tr>            
                    <tr>
                        <td width="10%"></td>
                        <td width="30%"></td>
                        <td width="40%">-------------------</td>
                        <td width="10%"></td>
                    </tr>
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">VENTA NETA:       //  </td>
                        <td width="40%"><?php // $simbolo .echo ($venta_neta > 0) ? (number_format($venta_neta,2, '.', '')) : '0.00';
                                        ?></td>
                        <td width="10%"></td>
                    </tr>
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">IVA:              //  </td>
                        <td width="40%"><?php // $simbolo .echo ($iva > 0) ? (number_format($iva,2, '.', '')) : '0.00';
                                        ?></td>
                        <td width="10%"></td>
                    </tr>                    
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">VENTA TOTAL:      //  </td>
                        <td width="40%"><?php // $simbolo .echo ($venta_total > 0) ? (number_format($venta_total,2, '.', '')) : '0.00';
                                        ?></td>
                        <td width="10%"></td>
                    </tr>
                    <tr>
                        <td width="10%"></td>
                        <td width="30%">RETENCION:        //  </td>
                        <td width="40%"><?php // $simbolo .echo ($retencion_total > 0) ? (number_format($retencion_total,2, '.', '')) : '0.00';
                                        ?></td>
                        <td width="10%"></td>
                    </tr>
                    <?php if ($tipo_reporte == 'pdf') { ?>
                    <tr>
                        <td height="20px"></td>
                        <td></td>
                        <td></td>
                    </tr>
                    <?php } else { ?>
                    <tr></tr>
                    <?php } ?>            
                    <tr>
                        <td colspan="11" align="center"><?php //echo 'F.________________________________';
                                                        ?></td>
                    </tr>
                    <tr>
                        <td colspan="11" align="center"><?php //echo $firmas->REPRESENTANTE_LEGAL->NOMBRE; 
                                                        ?></td>
                    </tr>  
                </table>  
            </td>
        </tr>
        </table> 
        -->
    <?php endif; ?>
<?php } ?>
<?php

if ($tipo_reporte == "csv") {
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header('Content-Description: File Transfer');
    header("Content-type: text/csv");
    header("Content-Disposition: attachment; filename={$filename}.csv");
    header("Expires: 0");
    header("Pragma: public");
    $fh = @fopen('php://output', 'w+');
    $headerDisplayed = false;
    $default = "0.00";
    if ($esf_elect==1) {
        $tIngreso = 3;
        foreach ($reporte as $k => $rep) {
            if ($rep['total_venta_exenta'] > 0) {
                if ($rep['total_venta_gravado'] > 0) {
                    $tOperacion = 4;
                } else {
                    $tOperacion = 2;
                }
            } else {
                if ($rep['total_venta_gravado'] > 0) {
                    $tOperacion = 1;
                } else {
                    $tOperacion = 3;
                }                
            }            
            /*A   FECHA DE EMISIÓN DEL DOCUMENTO                          10   Texto*/
            echo formatear_fecha("d/m/Y", $rep['fac_fecha_cont']) . ";";
            /*B   CLASE DE DOCUMENTO                                      1    Texto*/
            echo "4;";
            /*C   TIPO DE DOCUMENTO                                       2    Texto*/
            echo $rep['tif_codigo_fact_elect'] . ";";
            /*D   NUMERO DE RESOLUCIÓN YA NO APLICA, COLOCAR N/A          100  Texto*/
            echo "N/A;";
            /*E   SERIE DEL DOCUMENTO YA NO APLICA, COLOCAR N/A           100  Texto*/
            echo "N/A;";
            /*F   NUMERO DE CONTROL INTERNO DEL YA NO APLICA, COLOCAR N/A 100  Texto*/
            echo "N/A;";
            /*G   NUMERO DE CONTROL INTERNO AL YA NO APLICA, COLOCAR N/A  100  Texto*/
            echo "N/A;";
            /*H   NÚMERO DE DOCUMENTO (DEL) N/A: COD. DE GEN. DEL 1er DTE 100  Texto*/
            echo $rep['firstdte'] . ";";
            /*I   NÚMERO DE DOCUMENTO (AL) M/A COD DE GEN DEL ULTIMO DTE  100  Texto*/
            echo $rep['lastdte'] . ";";
            /*J   NÚMERO DE MAQUINA REGISTRADORA DEBE QUEDAR VACIO         14   Texto*/
            echo ";";
            /*K   VENTAS EXENTAS                                           10   Texto*/
            echo number_format($rep['total_venta_exenta'], 2, '.','') . ";";
            /*L   VENTAS INTERNAS EXENTAS NO SUJETAS A PROPORCIONALIDAD    10   Texto*/
            echo $default . ";";
            /*M   VENTAS NO SUJETAS                                        10   Texto*/
            echo number_format($rep['venta_no_sujeta'], 2, '.','') . ";";
            /*N   VENTAS GRAVADAS LOCALES                                 10   Texto*/
            echo number_format(($rep['total_venta_gravado'] + $rep['impuesto_fac']), 2, '.','') . ";";
            /*O   EXPORTACIONES DENTRO DEL ÁREA DE CENTROAMÉRICA          10   Texto*/
            echo number_format($rep['fac_exportaciones_centroamerica'], 2, '.','') . ";";
            /*P   EXPORTACIONES FUERA DEL ÁREA DE CENTROAMÉRICA           10   Texto*/
            echo number_format($rep['fac_exportaciones_mundial'], 2, '.','') . ";";
            /*Q   EXPORTACIONES DE SERVICIO                               10   Texto*/
            echo $default . ";";
            /*R   VENTAS A ZONAS FRANCAS Y DPA (TASA CERO)                10   Texto*/
            echo $default . ";";
            /*S   VENTAS A CUENTA DE TERCEROS NO DOMICILIADOS             10   Texto*/
            echo $default . ";";
            /*T   TOTAL DE VENTAS                                         10   Texto*/
            echo number_format($rep['venta_total'], 2, '.', '') . ";";
            /*U   TIPO DE OPERACION  SEGUN MANUAL */
            echo $tOperacion . ";";
            /*V   TIPO DE INGRESO SEGUN MANUAL DE MOMENTO SE DEJA QUEMADO */
            echo $tIngreso . ";";
            /*W  NUMERO DE ANEXO SEGUN MANUAL VALOR FIJO SEGUN CASO */
            echo "2;";
            // /*SALTO DE LINEA*/
            echo PHP_EOL;
        }
    } else {

    foreach ($reporte as $rep) {
        // OBTIENE EL TIPO DE DOCUMENTO:
        //-----------------------------------------------------------------------
        $tipo_documento = 0;
        switch ($rep['fac_id_tif']) {
            case '1':
                $tipo_documento = "01";
                break;
            case '2':
                $tipo_documento = "02";
                break;
            case '3':
                $tipo_documento = "03";
                break;
            default:
                $tipo_documento = 0;
                break;
        }
        //-----------------------------------------------------------------------
        $total_venta_exenta_fila  = 0;
        $total_venta_exenta_fila += round($rep['total_venta_exenta'], 2);
        $venta_no_sujeta_fila = 0;
        $venta_no_sujeta_fila += ($rep['total_venta_exenta'] > 0) ? round($rep['venta_no_sujeta'], 2) : 0;
        $total_venta_gravado_fila = 0;
        $total_venta_gravado_fila += ($rep['total_venta_exenta'] > 0) ? 0 : round((abs($rep['total_venta_gravado'] - $rep['total_venta_exenta'])), 2);
        $total_fac_fila = 0;
        $total_fac_fila += ($rep['total_venta_exenta'] > 0) ? round($rep['venta_total'], 2) : 0;
        //-----------------------------------------------------------------------
        //IMPRESION DE PROPIEDADES:
        //-----------------------------------------------------------------------
        /*A   FECHA DE EMISIÓN DEL DOCUMENTO                          10   Texto*/
        echo $rep['fecha'] . ";";
        /*B   CLASE DE DOCUMENTO                                      1    Texto*/
        echo (1) . ";";
        /*C   TIPO DE DOCUMENTO                                       2    Texto*/
        echo $tipo_documento . ";";
        /*D   NUMERO DE RESOLUCIÓN                                    100  Texto*/
        echo $rep['num_resolucion'] . ";";
        /*E   SERIE DEL DOCUMENTO                                     100  Texto*/
        echo $rep['serie'] . ";";
        /*F   NUMERO DE CONTROL INTERNO DEL                           100  Texto*/
        echo $rep['cof_inicio'] . ";";
        /*G   NUMERO DE CONTROL INTERNO AL                            100  Texto*/
        echo $rep['cof_fin'] . ";";
        /*H   NÚMERO DE DOCUMENTO (DEL)                               100  Texto*/
        echo $rep['cof_inicio'] . ";";
        /*I   NÚMERO DE DOCUMENTO (AL)                                100  Texto*/
        echo $rep['cof_fin'] . ";";
        /*J   NÚMERO DE MAQUINA REGISTRADORA                          14   Texto*/
        echo $rep['caj_numero_registradora'] . ";";
        /*K   VENTAS EXENTAS                                          10   Texto*/
        echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_venta_exenta_fila, 2) . ";";
        /*L   VENTAS INTERNAS EXENTAS NO SUJETAS A PROPORCIONALIDAD   10   Texto*/
        echo $default . ";";
        /*M   VENTAS NO SUJETAS                                       10   Texto*/
        echo ($rep['estado_factura'] == 0) ? '-' : number_format($venta_no_sujeta_fila, 2) . ";";
        /*N   VENTAS GRAVADAS LOCALES                                 10   Texto*/
        echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_venta_gravado_fila, 2) . ";";
        /*O   EXPORTACIONES DENTRO DEL ÁREA DE CENTROAMÉRICA          10   Texto*/
        echo $default . ";";
        /*P   EXPORTACIONES FUERA DEL ÁREA DE CENTROAMÉRICA           10   Texto*/
        echo $rep['fac_exportaciones'] . ";";
        /*Q   EXPORTACIONES DE SERVICIO                               10   Texto*/
        echo $default . ";";
        /*R   VENTAS A ZONAS FRANCAS Y DPA (TASA CERO)                10   Texto*/
        echo $default . ";";
        /*S   VENTAS A CUENTA DE TERCEROS NO DOMICILIADOS             10   Texto*/
        echo $default . ";";
        /*T   TOTAL DE VENTAS                                         10   Texto*/
        echo ($rep['estado_factura'] == 0) ? '-' : number_format($total_fac_fila, 2) . ";";
        /*U   NÚMERO DEL ANEXO                                        1    Texto*/
        echo $default . ";";
        /*SALTO DE LINEA*/
        echo PHP_EOL;
    }
    }
    fclose($fh);
    exit;
}


?>