<?php
/**
 * @author Elman Ortiz
 * @copyright 2018
 */
?>
<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
if ($tipo_reporte != 'csv') { ?>
    <?php  //Declaracion de variables para totales
    $venta_no_sujeta = 0.00;
    $ventas_exentas = 0.00;
    $ventas_exportaciones = 0.00;
    $ventas_gravadas = 0.00;
    $venta_total = 0.00;
    $retencion_total = 0.00;
    $fuente = ($tipo_reporte != "") ? "style='7px'" : "";
    $style = ($tipo_reporte == 'excel' or $tipo_reporte == 'pdf') ? 'style="text-align: center;"' : 'style="color: white; background: #0167B1; text-align: center;"';
    $p = ($tipo_reporte == 'pdf')?true:false;
    if ($tipo_reporte == 'excel') {
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header("content-disposition: attachment;filename=" . $filename . ".xls");
        header("Pragma: no-cache");
        header("Expires: 0");
    }
    ?>
    <?php if ($tipo_reporte == 'excel' or $tipo_reporte == 'pdf') { ?>
        <meta charset="utf-8" />
        <div class="head">
            <table border="0" style="text-align: left;">
                <tr>
                    <td colspan="6" height="20px">
                        <h2><?php echo $empresa; ?></h2>
                        <?php if (isset($propietario) && $propietario != "") : ?>
                            <span style="font-size: 8px; font-weight: bold; text-align: left;"><?= $propietario ?></span>
                        <?php endif ?>
                    </td>
                    <td colspan="3">
                        <h4><?php echo 'NRC: ' . $NRC; ?></h4>
                    </td>
                    <td colspan="3" style="text-align: right;">
                        <h4><?php echo 'NIT: ' . $NIT; ?></h4>
                    </td>
                </tr>
                <tr>
                    <td colspan="6" height="20px">
                        <h3><?php echo strtoupper($titulo) ?></h3>
                    </td>
                    <td colspan="6" style="text-align: right;">
                        <h4><?php echo $sub_titulo; ?></h4>
                    </td>
                </tr>
            </table>
        </div>
    <?php } ?>
    <style>
        /*.dynamicTable {
            table-layout: fixed;
        }*/
        .dynamicTable tr th {
            text-align: center;
            border: 1px solid black;
            font-weight: bold;
        }
        /*.dynamicTable td {
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }
        .dynamicTable td:hover {
            overflow: visible;
            white-space: initial;
            cursor: pointer;
        }*/
        .dynamicTable .dinero {
            text-align: right;
        }
        .total {
            border-top: 1px silver solid;
            text-align: right;
        }
        .resumen tr th {
            text-align: center;
            font-weight: bold;
        }
    </style>
    <?php if ($tipo_reporte == 'pdf') : ?>
        <style type="text/css">
            .dynamicTable td {
                font-size: 6px;
            }
        </style>
    <?php endif; ?>
    <table cellpadding="0.7" width="100%" style="font-size: <?= ($p) ? 6 : (($tipo_reporte != '') ? 12 : 11); ?>px !important;" id="tblListado" class="dynamicTable responsive display table table-bordered" <?php echo ($tipo_reporte != '') ? 'border="1"' : 'border="0"'; ?>  >
        <thead>
            <?php if ($esf_elect == 1) {
                if ($tipo_reporte != '') {
                    ?>
                    <tr>
                        <th width="47%" colspan="10"><?php echo $mes . "&nbsp;&nbsp;" . $year; ?></th>
                        <th width="53%" colspan="9" <?php echo $style; ?>>Ventas Propias y A Cuenta de Terceros</th>
                    </tr>
                    <tr>
                        <th rowspan="2" <?=($p)?'width="2%"':''; ?> >&nbsp;#&nbsp;</th>
                        <th rowspan="2" <?=($p)?'width="5%"':''; ?> >Fecha<br>Emisión</th>
                        <th rowspan="2" <?=($p)?'width="4%"':''; ?> >Corr. Interno</th>
                        <th rowspan="2" <?=($p)?'width="5%"':''; ?> >Cod. Generación</th>
                        <th rowspan="2" <?=($p)?'width="5%"':''; ?> >Num. Control</th>
                        <th rowspan="2" <?=($p)?'width="5%"':''; ?> >Sello Recibido</th>
                        <th rowspan="2" <?=($p)?'width="6%"':''; ?> >Nombre de Contribuyente</th>
                        <th rowspan="2" <?=($p)?'width="5%"':''; ?> >Referencia Externa</th>
                        <th rowspan="2" <?=($p)?'width="5%"':''; ?> >Caja</th>
                        <th rowspan="2" <?=($p)?'width="5%"':''; ?> >NRC</th>
                        <th colspan="4" <?=($p)?'width="24%"':''; ?> <?php echo $style; ?>>Propias</th>
                        <th colspan="2" <?=($p)?'width="12%"':''; ?> <?php echo $style; ?>>A cuenta de terceros</th>
                        <th rowspan="2" <?=($p)?'width="6%"':''; ?> >IVA<br>Retenido</th>
                        <th rowspan="2" <?=($p)?'width="5%"':''; ?> >IVA<br>Percibido</th>
                        <th rowspan="2" <?=($p)?'width="6%"':''; ?> >Total Ventas</th>
                    </tr>
                    <?php
                } else {
                    ?>
                    <tr>
                        <th rowspan="3">&nbsp;#&nbsp;</th>
                        <th rowspan="3">Fecha Emisión</th>
                        <th rowspan="3">Corr. Interno</th>
                        <th rowspan="3">Cod. Generación</th>
                        <th rowspan="3">Num. Control</th>
                        <th rowspan="3">Sello Recibido</th>
                        <th rowspan="3">Nombre de Contribuyente</th>
                        <th rowspan="3">Referencia Externa</th>
                        <th rowspan="3">Caja</th>
                        <th rowspan="3">NRC</th>
                        <th colspan="9" <?php echo $style; ?>>Ventas Propias y A Cuenta de Terceros</th>
                    </tr>
                    <tr>
                        <th colspan="4" <?= $style ?>>Propias</th>
                        <th colspan="2" <?= $style ?>>A cuenta de terceros</th>
                        <th rowspan="2">IVA<br>Retenido</th>
                        <th rowspan="2">IVA<br>Percibido</th>
                        <th rowspan="2">Total Ventas</th>
                    </tr>
                    <?php
                }
            } else {
                if ($tipo_reporte != '') {
                    ?>
                    <tr>
                        <th width="39%" colspan="5"><?php echo $mes . "&nbsp;&nbsp;" . $year; ?></th>
                        <th width="61%" colspan="9" <?php echo $style; ?>>Ventas Propias y A Cuenta de Terceros</th>
                    </tr>
                    <tr>
                        <th rowspan="2" <?=($p)?'width="2%"':'';?> >&nbsp;#&nbsp;</th>
                        <th rowspan="2" <?=($p)?'width="6%"':'';?> >Fecha<br>Emisión</th>
                        <th rowspan="2" <?=($p)?'width="7%"':'';?> >No. Doc.</th>
                        <th rowspan="2" <?=($p)?'width="14%"':'';?> >Nombre de Contribuyente</th>
                        <th rowspan="2" <?=($p)?'width="5%"':'';?> >Caja</th>
                        <th rowspan="2" <?=($p)?'width="5%"':'';?> >NRC</th>
                        <th colspan="4" <?=($p)?'width="28%"':'';?> <?php echo $style; ?>>Propias</th>
                        <th colspan="2" <?=($p)?'width="12%"':'';?> <?php echo $style; ?>>A cuenta de terceros</th>
                        <th rowspan="2" <?=($p)?'width="7%"':'';?> >IVA<br>Retenido</th>
                        <th rowspan="2" <?=($p)?'width="7%"':'';?> >IVA<br>Percibido</th>
                        <th rowspan="2" <?=($p)?'width="7%"':'';?> >Total Ventas</th>
                    </tr>
                    <?php
                } else {
                    ?>
                    <tr>
                        <th rowspan="3">&nbsp;#&nbsp;</th>
                        <th rowspan="3">Fecha Emisión</th>
                        <th rowspan="3">No. Doc.</th>
                        <th rowspan="3">Nombre de Contribuyente</th>
                        <th rowspan="3">Caja</th>
                        <th rowspan="3">NRC</th>
                        <th colspan="9" <?php echo $style; ?>>Ventas Propias y A Cuenta de Terceros</th>
                    </tr>
                    <tr>
                        <th colspan="4" <?= $style ?>>Propias</th>
                        <th colspan="2" <?= $style ?>>A cuenta de terceros</th>
                        <th rowspan="2">IVA<br>Retenido</th>
                        <th rowspan="2">IVA<br>Percibido</th>
                        <th rowspan="2">Total Ventas</th>
                    </tr>
                    <?php
                }
            } ?>
            <tr>                                          
                <th >Exentas</th>
                <th >Internas Gravadas</th>
                <th >Débito Fiscal</th>
                <th >No Sujetas</th>
                <th >Internas Gravadas</th>
                <th >Débito Fiscal</th>
            </tr>
        </thead>
        <?php if (count($reporte) > 0) {
            ?>
            <tbody>
                <?php
                $contador = 1;
                $sub_total_exentas = 0;
                $sub_total_no_sujetas = 0;
                $sub_total_locales = 0;
                $sub_total_debito_fiscal = 0;
                $sub_total_venta_terceros = 0;
                $sub_total_debito_terceros = 0;
                $sub_total_iva_percibido = 0;
                $sub_total_iva_retenido = 0;
                $sub_total_venta = 0;
                $total_gra_tabla_contribuyente = 0;
                $total_gra_iva_tabla_contribuyente = 0;
                $total_gra_ret_tabla_contribuyente = 0;
                $total_exe_tabla_contribuyente = 0;
                $total_gra_tabla_consum_final = 0;
                $total_gra_iva_tabla_consum_final = 0;
                $total_gra_ret_tabla_consum_final = 0;
                $total_exe_tabla_consum_final = 0;
                $total_exe_tabla_exportacion = 0;
                if (count($tipos_facturas) > 0) {
                    $creditos = explode(',', trim($tipos_facturas['CREDITO FISCAL']));
                    $consumidor = explode(',', trim($tipos_facturas['CONSUMIDOR FINAL']));
                    $exportacion = (isset($tipos_facturas['EXPORTACION'])) ? explode(',', trim($tipos_facturas['EXPORTACION'])) : array(0);
                    if (isset($tipos_facturas['NOTA CREDITO']) && trim($tipos_facturas['NOTA CREDITO']) != '') {
                        $n_c = explode(',', trim($tipos_facturas['NOTA CREDITO']));
                        foreach ($n_c as $key => $value) {
                            array_push($creditos, $value);
                        }
                    }
                    if (isset($tipos_facturas['TICKET']) && trim($tipos_facturas['TICKET']) != '') {
                        $tck = explode(',', trim($tipos_facturas['TICKET']));
                        foreach ($tck as $key => $value) {
                            array_push($consumidor, $value);
                        }
                    }
                    if (isset($tipos_facturas['SUJETO EXCLUIDO']) && trim($tipos_facturas['SUJETO EXCLUIDO']) != '') {
                        $s_j = explode(',', trim($tipos_facturas['SUJETO EXCLUIDO']));
                        foreach ($s_j as $key => $value) {
                            array_push($consumidor, $value);
                        }
                    }
                }
                foreach ($reporte as $key => $rep) {
                    $ventas_exportaciones = 0;
                    $venta_no_sujeta     += number_format($rep['venta_no_sujeta'], 4, '.', '');
                    $ventas_exentas      += number_format($rep['ventas_exentas'], 4, '.', '');
                    $ventas_gravadas     += number_format($rep['ventas_locales'], 4, '.', '');
                    $retencion_total     += ($rep['iva_retenido'] < 0) ? number_format($rep['iva_retenido'], 4, '.', '') : number_format(($rep['iva_retenido'] * -1), 4, '.', '');
                    $total_ventas = number_format($rep['ventas_exentas'],4,'.','') + number_format($rep['ventas_locales'],4,'.','') + number_format($rep['venta_no_sujeta'],4,'.','') + number_format($rep['debito_fiscal'],4,'.','') + number_format($rep['iva_percibido'],4,'.','') - number_format($rep['iva_retenido'],4,'.','');

                    //Se suman los subtotales de cada columna
                    $sub_total_iva_percibido   += number_format($rep['iva_percibido'], 4, '.', '');
                    $sub_total_no_sujetas      += number_format($rep['venta_no_sujeta'], 4, '.', '');
                    $sub_total_debito_terceros += number_format($rep['debito_fiscal_terceros'], 4, '.', '');
                    $sub_total_exentas         += number_format($rep['ventas_exentas'], 4, '.', '');
                    $sub_total_locales         += number_format($rep['ventas_locales'], 4, '.', '');
                    $sub_total_debito_fiscal   += number_format($rep['debito_fiscal'], 4, '.', '');
                    $sub_total_venta_terceros  += number_format($rep['ventas_terceros'], 4, '.', '');
                    $sub_total_iva_retenido    += number_format($rep['iva_retenido'], 4, '.', '');
                    $sub_total_venta           += $total_ventas;

                    //totales para la tabla
                    if (count($tipos_facturas) > 0) {
                        if (in_array($rep['fac_id_tif'], $creditos)) {
                            if ($rep['ventas_locales'] != 0 && $rep['debito_fiscal'] != 0) {
                                $total_gra_tabla_contribuyente += number_format($rep['ventas_locales'], 4, '.', '');
                                $total_gra_iva_tabla_contribuyente += number_format($rep['debito_fiscal'], 4, '.', '');
                                $total_gra_ret_tabla_contribuyente += ($rep['iva_retenido'] < 0) ? number_format($rep['iva_retenido'], 4, '.', '') : number_format(($rep['iva_retenido'] * -1), 4, '.', '');
                            } else {
                                $total_exe_tabla_contribuyente += number_format($rep['ventas_exentas'], 4, '.', '');
                            }
                        }
                        if (in_array($rep['fac_id_tif'], $consumidor)) {
                            if ($rep['ventas_locales'] != 0 && $rep['debito_fiscal'] != 0) {
                                $total_gra_tabla_consum_final += number_format($rep['ventas_locales'], 4, '.', '');
                                $total_gra_iva_tabla_consum_final += number_format($rep['debito_fiscal'], 4, '.', '');
                                $total_gra_ret_tabla_consum_final += ($rep['iva_retenido'] < 0) ? number_format($rep['iva_retenido'], 4, '.', '') : number_format(($rep['iva_retenido'] * -1), 4, '.', '');
                            } else {
                                $total_exe_tabla_consum_final += ($rep['venta_no_sujeta'] != 0) ? number_format($rep['venta_no_sujeta'], 4, '.', '') : number_format($rep['ventas_exentas'], 4, '.', '');
                            }
                        }
                        if (in_array($rep['fac_id_tif'], $exportacion)) {
                            $total_exe_tabla_exportacion += ($rep['ventas_exentas'] != 0) ? number_format($rep['ventas_exentas'], 4, '.', '') : number_format($rep['ventas_locales'], 4, '.', '');
                        }
                    }
                    if ($esf_elect == 1) {
                        ?>
                        <tr nobr="true">
                            <td <?=($p)?'width="2%"':''; ?> ><?= $contador ?></td>
                            <td <?=($p)?'width="5%"':''; ?> ><?= formatear_fecha('d-m-Y', $rep['fac_fecha_fact']) ?></td>
                            <td <?=($p)?'width="4%"':''; ?> ><?= $rep['fac_numero'] ?></td>
                            <td <?=($p)?'width="5%"':''; ?> ><?= $rep['fac_codigo_generacion'] ?></td>
                            <td <?=($p)?'width="5%"':''; ?> ><?= $rep['fac_numero_control'] ?></td>
                            <td <?=($p)?'width="5%"':''; ?> ><?= $rep['fac_sello_recepcion'] ?></td>
                            <td <?=($p)?'width="6%"':''; ?> ><?= $rep['cli_nombre'] ?></td>
                            <td <?=($p)?'width="5%"':''; ?> ><?= $rep['fac_referencia_externa'] ?></td>
                            <td <?=($p)?'width="5%"':''; ?> ><?= $rep['caja_nombre']; ?></td>
                            <td <?=($p)?'width="5%"':''; ?> ><?= $rep['nrc']; ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?= $simbolo . number_format($rep['ventas_exentas'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?= $simbolo . number_format($rep['ventas_locales'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?= $simbolo . number_format($rep['debito_fiscal'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?= $simbolo . number_format($rep['venta_no_sujeta'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?= $simbolo . number_format($rep['ventas_terceros'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?= $simbolo . number_format($rep['debito_fiscal_terceros'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?= $simbolo . number_format(abs($rep['iva_retenido']), 2); ?></td>
                            <td <?=($p)?'width="5%"':'';?> class="dinero" ><?= $simbolo . number_format($rep['iva_percibido'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?= $simbolo . number_format($total_ventas, 2); ?></td>
                        </tr>
                        <?php
                    } else {
                        ?>
                        <tr nobr="true">
                            <td <?=($p)?'width="2%"':'';?>><?php echo $contador ?></td>
                            <td <?=($p)?'width="6%"':'';?> <?= $fuente ?>><?php echo formatear_fecha('d-m-Y', $rep['fac_fecha_fact']); ?></td>
                            <td <?=($p)?'width="7%"':'';?> <?= $fuente ?>><?php echo $rep['serie_fac'] . $rep['fac_numero']; ?></td>
                            <td <?=($p)?'width="14%"':'';?> <?= $fuente ?>><?php echo $rep['cli_nombre']; ?></td>
                            <td <?=($p)?'width="5%"':'';?> <?= $fuente ?>><?php echo $rep['caja_nombre']; ?></td>
                            <td <?=($p)?'width="5%"':'';?> <?= $fuente ?>><?php echo $rep['nrc']; ?></td>
                            <td <?=($p)?'width="7%"':'';?> class="dinero" ><?php echo $simbolo . number_format($rep['ventas_exentas'], 2); ?></td>
                            <td <?=($p)?'width="7%"':'';?> class="dinero" ><?php echo $simbolo . number_format($rep['ventas_locales'], 2); ?></td>
                            <td <?=($p)?'width="7%"':'';?> class="dinero" ><?php echo $simbolo . number_format($rep['debito_fiscal'], 2); ?></td>
                            <td <?=($p)?'width="7%"':'';?> class="dinero" ><?php echo $simbolo . number_format($rep['venta_no_sujeta'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?php echo $simbolo . number_format($rep['ventas_terceros'], 2); ?></td>
                            <td <?=($p)?'width="6%"':'';?> class="dinero" ><?php echo $simbolo . number_format($rep['debito_fiscal_terceros'], 2); ?></td>
                            <td <?=($p)?'width="7%"':'';?> class="dinero" ><?php echo $simbolo . number_format(abs($rep['iva_retenido']), 2); ?></td>
                            <td <?=($p)?'width="7%"':'';?> class="dinero" ><?php echo $simbolo . number_format($rep['iva_percibido'], 2); ?></td>
                            <td <?=($p)?'width="7%"':'';?> class="dinero" ><?php echo $simbolo . number_format($total_ventas, 2); ?></td>
                        </tr>
                        <?php 
                    }
                    $contador++;
                } ?>
            </tbody>
            <tfoot>
                <tr nobr="true" style="font-weight: bold;">
                    <td class="total dinero" style="text-align: right;" colspan="<?=($esf_elect == 1)?10:6;?>" >TOTAL</td>
                    <td class="total dinero"><?php echo $simbolo . number_format($sub_total_exentas, 2); ?></td>
                    <td class="total dinero"><?php echo $simbolo . number_format($sub_total_locales, 2); ?></td>
                    <td class="total dinero"><?php echo $simbolo . number_format($sub_total_debito_fiscal, 2); ?></td>
                    <td class="total dinero"><?php echo $simbolo . number_format($sub_total_no_sujetas, 2); ?></td>
                    <td class="total dinero"><?php echo $simbolo . number_format($sub_total_venta_terceros, 2); ?></td>
                    <td class="total dinero"><?php echo $simbolo . number_format($sub_total_debito_terceros, 2); ?></td>
                    <td class="total dinero"><?php echo $simbolo . ($sub_total_iva_retenido < 0) ? number_format($sub_total_iva_retenido, 2) : number_format(($sub_total_iva_retenido * -1), 2); ?></td>
                    <td class="total dinero"><?php echo $simbolo . number_format($sub_total_iva_percibido, 2, '.', ''); ?></td>
                    <td class="total dinero"><?php echo $simbolo . number_format($sub_total_venta, 2); ?></td>
                </tr>
            </tfoot>
            <?php
        } else {
            if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') {
                ?>
                <tbody>
                    <tr nobr="true">
                        <td colspan="<?=($esf_elect == 1) ? 18 : 15;?>" align="center" style="border: 1px solid black; font-size: 9px"><b>No se encontraron registros</b></td>
                    </tr>
                </tbody>
                <?php
            }
        } ?>
    </table>
    <?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') :
        $venta_gravada_neta =  $ventas_gravadas /*+ $ventas_exentas*/;
        $venta_neta = (number_format($ventas_exentas, 4, '.', '') + number_format($venta_gravada_neta, 4, '.', ''));
        //$iva = number_format($venta_gravada_neta * 0.13,4, '.', '');
        $iva = number_format($sub_total_debito_fiscal, 4, '.', '');
        $venta_total = $venta_neta + $iva + $retencion_total;
        $width1 = ($tipo_reporte == 'pdf') ? 10 : 3;
        $width2 = ($tipo_reporte == 'pdf') ? 80 : 67;
        $width3 = ($tipo_reporte == 'pdf') ? 10 : 30;
        $total_gra = $total_gra_tabla_contribuyente + $total_gra_tabla_consum_final;
        $total_gra_iva = $total_gra_iva_tabla_contribuyente + $total_gra_iva_tabla_consum_final;
        $total_gra_ret = $total_gra_ret_tabla_contribuyente + $total_gra_ret_tabla_consum_final;
        $total_exe = $total_exe_tabla_contribuyente + $total_exe_tabla_consum_final;
        $gran_total = $total_gra + $total_exe + $total_exe_tabla_exportacion;
        $gran_total2 = $venta_gravada_neta + $ventas_exentas + $sub_total_no_sujetas;
        ?>
        <table border="0" cellpadding="2">
            <tr>
                <td width="<?= $width1 ?>%"></td>
                <td width="<?= $width2 ?>%" height="20px"></td>
                <td width="<?= $width3 ?>%"></td>
            </tr>
            <tr>
                <td></td>
                <td style="text-align: center;font-weight: bold;">Resumen de Operaciones de Ventas</td>
                <td></td>
            </tr>
            <tr>
                <td></td>
                <td style="border: black 1px solid;">
                    <table class="resumen" border="0" width="100%" <?php echo ($tipo_reporte == 'excel') ? '' : 'style="font-size: 7px;"'; ?> cellpadding="1">
                        <thead>
                            <tr style="background-color: silver;">
                                <th width="30%"></th>
                                <th width="5%"></th>
                                <th colspan="2" width="26%">Ventas Propias</th>
                                <th colspan="2" width="26%">A Cta. de Terceros</th>
                                <th width="13%">IVA Retenido</th>
                            </tr>
                            <tr style="background-color: silver;">
                                <th colspan="2"></th>
                                <th width="13%">Venta Neta</th>
                                <th width="13%">Débito Fiscal</th>
                                <th width="13%">Venta Neta</th>
                                <th width="13%">Débito Fiscal</th>
                                <th width="13%"></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="7" style="font-weight: bold;">Operaciones Internas Gravadas</td>
                            </tr>
                            <tr>
                                <td style="text-align: right;"><?php echo (count($tipos_facturas) > 0) ? 'Contribuyentes' : ''; ?></td>
                                <td></td>
                                <td style="text-align: right;"><?php echo (count($tipos_facturas) > 0) ? '$' . number_format($total_gra_tabla_contribuyente, 2) : '$' . number_format($venta_gravada_neta, 2); ?></td>
                                <td style="text-align: right;"><?php echo (count($tipos_facturas) > 0) ? '$' . number_format($total_gra_iva_tabla_contribuyente, 2) : '$' . number_format($iva, 2); ?></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"><?php echo (count($tipos_facturas) > 0) ? '$' . number_format($total_gra_ret_tabla_contribuyente, 2) : '$' . number_format($retencion_total, 2); ?></td>
                            </tr>
                            <?php if (count($tipos_facturas) > 0) : ?>
                                <tr>
                                    <td style="text-align: right;">Consumidor Final</td>
                                    <td></td>
                                    <td style="text-align: right;"><?php echo "$" . number_format($total_gra_tabla_consum_final, 2); ?></td>
                                    <td style="text-align: right;"><?php echo "$" . number_format($total_gra_iva_tabla_consum_final, 2); ?></td>
                                    <td style="text-align: right;"></td>
                                    <td style="text-align: right;"></td>
                                    <td style="text-align: right;"><?php echo "$" . number_format($total_gra_ret_tabla_consum_final, 2); ?></td>
                                </tr>
                                <tr>
                                    <td style="text-align: center;font-weight: bold;border-top: silver 1px solid;" height="20px">Total</td>
                                    <td style="border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;font-weight: bold;border-top: silver 1px solid;"><?php echo "$" . number_format($total_gra, 2); ?></td>
                                    <td style="text-align: right;font-weight: bold;border-top: silver 1px solid;"><?php echo "$" . number_format($total_gra_iva, 2); ?></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;font-weight: bold;border-top: silver 1px solid;"><?php echo "$" . number_format($total_gra_ret, 2); ?></td>
                                </tr>
                            <?php endif ?>
                            <tr>
                                <td colspan="7" style="font-weight: bold;">Operaciones Internas Exentas</td>
                            </tr>
                            <tr>
                                <td style="text-align: right;"><?php echo (count($tipos_facturas) > 0) ? 'Contribuyentes' : ''; ?></td>
                                <td></td>
                                <td style="text-align: right;"><?php echo (count($tipos_facturas) > 0) ? '$' . number_format($total_exe_tabla_contribuyente, 2) : '$' . number_format(($ventas_exentas), 2); ?></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"></td>
                            </tr>
                            <?php if (count($tipos_facturas) > 0) : ?>
                                <tr>
                                    <td style="text-align: right;">Consumidor Final</td>
                                    <td></td>
                                    <td style="text-align: right;"><?php echo "$" . number_format($total_exe_tabla_consum_final, 2); ?></td>
                                    <td style="text-align: right;"></td>
                                    <td style="text-align: right;"></td>
                                    <td style="text-align: right;"></td>
                                    <td style="text-align: right;"></td>
                                </tr>
                                <tr>
                                    <td style="text-align: center;font-weight: bold;border-top: silver 1px solid;" height="20px">Total</td>
                                    <td style="border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;font-weight: bold;border-top: silver 1px solid;"><?php echo "$" . number_format($total_exe, 2); ?></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                </tr>
                            <?php endif ?>
                            <tr>
                                <td colspan="7" style="font-weight: bold;"><?php echo (count($tipos_facturas) > 0) ? 'Exportaciones' : 'No Sujetas'; ?></td>
                            </tr>
                            <tr>
                                <td style="text-align: right;"></td>
                                <td></td>
                                <td style="text-align: right;"><?php echo (count($tipos_facturas) > 0) ? '$' . number_format($total_exe_tabla_exportacion, 2) : '$' . number_format($sub_total_no_sujetas, 2); ?></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"></td>
                                <td style="text-align: right;"></td>
                            </tr>
                            <?php if (count($tipos_facturas) > 0) : ?>
                                <tr>
                                    <td style="text-align: center;font-weight: bold;border-top: silver 1px solid;" height="20px">Total</td>
                                    <td style="border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;border-top: silver 1px solid;font-weight: bold;"><?php echo '$' . number_format($total_exe_tabla_exportacion, 2); ?></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                    <td style="text-align: right;border-top: silver 1px solid;"></td>
                                </tr>
                            <?php endif ?>
                        </tbody>
                        <tfoot>
                            <tr style="background-color: silver;">
                                <th style="font-weight: bold;">Total de Ventas</th>
                                <th></th>
                                <th style="font-weight: bold;text-align: right;"><?php echo (count($tipos_facturas) > 0) ? "$" . number_format($gran_total, 2) : "$" . number_format($gran_total2, 2); ?></th>
                                <th style="font-weight: bold;text-align: right;"><?php echo (count($tipos_facturas) > 0) ? "" : "$" . number_format($iva, 2); ?></th>
                                <th colspan="2"></th>
                                <th style="font-weight: bold;text-align: right;"><?php echo (count($tipos_facturas) > 0) ? "" : "$" . number_format($retencion_total, 2); ?></th>
                            </tr>
                        </tfoot>
                    </table>
                </td>
                <td></td>
            </tr>
        </table>
        <br><br>
        <table border="0">
            <tr noBr="true">
                <td></td>
                <td>
                    <table border="0" width="100%">
                        <!--
                <tr>
                    <td height="20px"></td><td></td><td></td>
                </tr>
                <tr>
                    <td width="10%"></td>
                    <td width="30%">RESUMEN DEL CÁLCULO DEL DÉBITO FISCAL</td>
                    <td width="40%"></td>
                    <td width="10%"></td>
                </tr>    
                -->
                        <!-- <tr>
                    <td width="10%"></td>
                    <td width="30%">Ventas no sujetas:</td>
                    <td width="40%"><?php echo $simbolo . ($venta_no_sujeta > 0) ? number_format($venta_no_sujeta, 2, '.', '') : '0.00'; ?></td>
                    <td width="10%"></td>      
                </tr> -->
                        <!--
                <tr>
                    <td width="10%"></td>
                    <td width="30%">Ventas exentas:</td>
                    <td width="40%"><?php echo $simbolo . ($ventas_exentas > 0) ? number_format($ventas_exentas, 2, '.', '') : '0.00'; /////////////////////////
                                    ?></td>
                    <td width="10%"></td>
                </tr>
                -->
                        <!-- <tr>
                    <td width="10%"></td>
                    <td width="30%">Ventas exportaciones:</td>
                    <td width="40%"><?php echo $simbolo . ($ventas_exportaciones > 0) ? number_format($ventas_exportaciones, 2, '.', '') : '0.00'; ?></td>
                    <td width="10%"></td>      
                </tr> -->
                        <!--
                <tr>
                    <td width="10%"></td>
                    <td width="30%">Ventas gravadas netas:</td>
                    <td width="40%"><?php echo $simbolo . ($venta_gravada_neta > 0) ? (number_format($venta_gravada_neta, 2, '.', '')) : '0.00'; ////////////////
                                    ?></td>
                    <td width="10%"></td>
                </tr>
                <tr>
                    <td width="10%"></td>
                    <td width="30%"></td>
                    <td width="40%">-------------------</td>
                    <td width="10%"></td>
                </tr>
                <tr>
                    <td width="10%"></td>
                    <td width="30%">VENTA NETA:</td>
                    <td width="40%"><?php echo $simbolo . ($venta_neta > 0) ? (number_format($venta_neta, 2, '.', '')) : '0.00'; ?></td>
                    <td width="10%"></td>
                </tr>
                <tr>
                    <td width="10%"></td>
                    <td width="30%">IVA:</td>
                    <td width="40%"><?php echo $simbolo . ($iva > 0) ? (number_format($iva, 2, '.', '')) : '0.00'; ?></td>
                    <td width="10%"></td>
                </tr>
                <tr>
                    <td width="10%"></td>
                    <td width="30%">RETENCION:</td>
                    <td width="40%"><?php echo $simbolo . ($retencion_total > 0) ? (number_format($retencion_total, 2, '.', '')) : '0.00'; ////////////////////////////
                                    ?></td>
                    <td width="10%"></td>
                </tr>
                <tr>
                    <td width="10%"></td>
                    <td width="30%">VENTA TOTAL:</td>
                    <td width="40%"><?php echo $simbolo . ($venta_total > 0) ? (number_format($venta_total, 2, '.', '')) : '0.00'; ?></td>
                    <td width="10%"></td>
                </tr>
                -->
                        <tr>
                            <td></td>
                        </tr>
                        <tr>
                            <td></td>
                        </tr>
                        <tr>
                            <td></td>
                        </tr>
                        <tr>
                            <td></td>
                        </tr>
                        <tr>
                            <td align="center"><?php echo 'F.________________________________'; ?></td>
                        </tr>
                        <tr>
                            <td align="center"><?php echo $firmas->CONTADOR->NOMBRE; ?></td>
                        </tr>
                    </table>
                </td>
                <td></td>
            </tr>
        </table>
    <?php endif; ?>
<?php } ?>
<?php
if (0) {
    echo "<pre>";
    print_r($reporte[0]);
    echo "<hr>";
    print_r($this->gsatelite->get_parametro('SYS_CONFIGURACION_REPORTE_COMPRA'));
    echo "</pre>";
    die();
}
if ($tipo_reporte == "csv") {
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header('Content-Description: File Transfer');
    header("Content-type: text/csv");
    header("Content-Disposition: attachment; filename={$filename}.csv");
    header("Expires: 0");
    header("Pragma: public");

    $fh = @fopen('php://output', 'w+');
    $headerDisplayed = false;

    $default = "0.00";

    foreach ($reporte as $rep) {
        // OBTIENE EL TIPO DE DOCUMENTO:
        //-----------------------------------------------------------------------
        $tipo_documento = 0;
        switch ($rep['fac_id_tif']) {
            case '1':
                $tipo_documento = '"01"';
                break;
            case '2':
                $tipo_documento = '"02"';
                break;
            case '3':
                $tipo_documento = '"03"';
                break;
            default:
                $tipo_documento = 0;
                break;
        }
        //-----------------------------------------------------------------------
        $total_venta_exenta_fila  = 0;
        $total_venta_exenta_fila += round($rep['total_venta_exenta'], 2);
        $venta_no_sujeta_fila = 0;
        $venta_no_sujeta_fila += ($rep['total_venta_exenta'] > 0) ? round($rep['venta_no_sujeta'], 2) : 0;
        $total_venta_gravado_fila = 0;
        $total_venta_gravado_fila += ($rep['total_venta_exenta'] > 0) ? 0 : round((abs($rep['total_venta_gravado'] - $rep['total_venta_exenta'])), 2);
        $total_fac_fila = 0;
        $total_fac_fila += ($rep['total_venta_exenta'] > 0) ? round($rep['venta_total'], 2) : 0;
        //------------------------------------------------------------------------
        //IMPRESION DE PROPIEDADES:
        //--------------------------------------------------------------------------------------
        /* A   FECHA DE EMISIÓN DEL DOCUMENTO                   10          Texto */
        echo formatear_fecha('d-m-Y', $rep['fac_fecha_fact']) . ";";
        /* B   CLASE DE DOCUMENTO                               1           Texto */
        echo (2) . ";";
        /* C   TIPO DE DOCUMENTO                                2           Texto */
        echo $tipo_documento . ';';
        /* D   NUMERO DE RESOLUCIÓN                             100         Texto */
        echo $rep['num_resolucion'] . ";";
        /* E   SERIE DEL DOCUMENTO                              100         Texto */
        echo $rep['serie_fac'] . ";";
        /* F   NÚMERO DE DOCUMENTO                              100         Texto */
        echo $rep['fac_numero'] . ";";
        /* G   NÚMERO DE CONTROL INTERNO                        100         Texto */
        echo $rep['numero'] . ";";
        /* H   NIT                                              14          Texto */
        echo $rep['nrc'] . ";";
        /* I   NOMBRE RAZÓN SOCIAL O DENOMINACIÓN               SIN LÍMITE  Texto */
        echo "$empresa;";
        /* J   VENTAS EXENTAS                                   10          Texto */
        echo number_format($rep['ventas_exentas'], 2) . ";";
        /* K   VENTAS NO SUJETAS                                10          Texto */
        echo number_format($rep['venta_no_sujeta'], 2) . ";";
        /* L   VENTAS GRAVADAS LOCALES                          10          Texto */
        echo number_format($rep['ventas_locales'], 2) . ";";
        /* M   DÉBITO FISCAL                                    10          Texto */
        echo number_format($rep['debito_fiscal'], 2) . ";";
        /* N   VENTAS A CUENTA DE TERCEROS NO DOMICILIADOS      10          Texto */
        echo number_format($rep['ventas_terceros'], 2) . ";";
        /* O   DEBITO FISCAL POR VENTAS A CUENTA DE TERCEROS    10          Texto */
        echo number_format($rep['debito_fiscal_terceros'], 2) . ";";
        /* P   TOTAL DE VENTAS                                  10          Texto */
        echo number_format($total_ventas, 2) . ";";
        /* Q   NÚMERO DEL ANEXO                                 1           Texto */
        echo (1) . ";";
        /*SALTO DE LINEA*/
        echo PHP_EOL;
    }
    //AGREGAR JOIN SEF Y HACER RELACION CON LA LLAVE DE LA COF
    fclose($fh);
    exit;
}


?>