<?php

/**
 * @author Elman Ortiz
 * @copyright 2018
 */
?>
<?php
//Declaracion de variables para totales
$venta_no_sujeta      = 0.00;
$ventas_exentas       = 0.00;
$ventas_exportaciones = 0.00;
$ventas_gravadas      = 0.00;
$venta_total          = 0.00;
$retencion_total      = 0.00;
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

?>
<?php
if ($tipo_reporte == 'excel') {
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header("content-disposition: attachment;filename=" . $filename . ".xls");
  header("Pragma: no-cache");
  header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel' or $tipo_reporte == 'pdf') { ?>
  <meta charset="utf-8" />
  <div class="head">
    <table>
      <tr>
        <td align="center" colspan="11">
          <h4>
            <?php
            echo $empresa . "<br/>" . $titulo . "<br/>" . $sub_titulo;
            ?>
          </h4>
        </td>
      </tr>
    </table>
  </div>
<?php } ?>

<?php if ($tipo_reporte == 'pdf') : ?>
  <style type="text/css">
    td {
      font-family: courier;
      font-size: 9px;
    }
  </style>
<?php endif; ?>

<?php if ($tipo_reporte == 'pdf' or $tipo_reporte == 'excel') : ?>
  <table border="0" width="100%">
    <tr>
      <td><?php echo '<b>NIT</b>: ' . $NIT; ?></td>
      <td style="text-align:right;"><?php echo $periodotext; ?></td>
    </tr>
    <tr>
      <td colspan="2"><?php echo '<b>NRC</b>: ' . $NRC; ?></td>
    </tr>
    <tr>
      <td colspan="2"></td>
    </tr>
  </table>
<?php endif; ?>

<style>
  .dynamicTable tr th {
    text-align: center;
  }

  .dynamicTable .dinero {
    text-align: right;
  }
</style>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered" aria-describedby="table_2_info">
  <thead>
    <tr>
      <!-- <th style="display:none;"></th> -->
      <th width="5%">COR.</th>
      <th width="10%">FECHA</th>
      <th width="10%">TIPO DOC</th>
      <th width="10%">CAJA</th>
      <th width="5%">DEL</th>
      <th width="5%">AL</th>
      <th width="5%">VENTAS NO SUJETAS</th>
      <th width="10%">VENTAS EXENTAS</th>
      <th width="10%">VENTAS GRAVADAS</th>
      <th width="10%">EXPORTACIONES</th>
      <th width="10%">RETENCIÓN</th>
      <th width="10%">VENTA TOTAL</th>
      <!-- <th>ESTADO</th>  -->
    </tr>
  </thead>
  <tbody>
    <?php if (count($reporte) > 0) { ?>
      <?php
      $n_anterior = 0;
      $nivelar_correlativo = 0;
      foreach ($reporte as $key => $rep) {
        if ($n_anterior != 0) {
          $ind = $key - 1;
          $nivelar_correlativo = 0;
          if (isset($reporte[$ind]['fac_estado'])) {
            if (($reporte[$ind]['fac_estado'] == 0 ||  $reporte[$ind]['total_venta_exenta'] > 0)
              // && ($reporte[$ind]['del'] == $reporte[$ind]['al']) 
              && (!$rep['fac_estado'] == 0 ||  !$rep['total_venta_exenta'] > 0)
            ) {
              //print_r($reporte[$ind]);
              //print_r($rep);
              //print_r($ind);
              // print_r($n_anterior);
              //die('llego');
              $nivelar_correlativo = 1;
            }
          }
        }
        $n_anterior++;

      ?>
        <?php
        $venta_no_sujeta = $venta_no_sujeta + $rep['venta_no_sujeta'];
        $ventas_exentas = $ventas_exentas + $rep['total_venta_exenta'];
        $ventas_exportaciones = $ventas_exportaciones + $rep['exportacion'];
        $ventas_gravadas = $ventas_gravadas + $rep['total_venta_gravado'] * 1.13;
        $venta_total = $venta_total + $rep['venta_total'];
        $retencion_total = $retencion_total + $rep['retencion'];
        ?>
        <tr nobr="true">
          <td width="5%"><?php echo 1 + $key ?></td>
          <td width="10%"><?php echo formatear_fecha('d-m-Y', $rep['fac_fecha_fact']); ?></td>
          <td width="10%"><?php echo ($rep['fac_estado'] == 0) ? 'FACTURA ANULADA' : (($rep['fac_estado'] != 0 && $rep['total_venta_exenta'] > 0) ? ($rep['tipo_documento'] . ' (exenta)') : $rep['tipo_documento']); ?></td>
          <td width="10%"><?php echo $rep['caj_nombre']; ?></td>
          <td width="5%"><?php echo ($rep['del'] - $nivelar_correlativo); ?></td>
          <td width="5%"><?php echo $rep['al']; ?></td>
          <td width="5%" class="dinero"><?php echo ($rep['fac_estado'] == 0) ? ' - ' : number_format($rep['venta_no_sujeta'], 2, '.', ''); ?></td>
          <td width="10%" class="dinero"><?php echo ($rep['fac_estado'] == 0) ? ' - ' : number_format($rep['total_venta_exenta'], 2, '.', ''); ?></td>
          <td width="10%" class="dinero"><?php echo ($rep['fac_estado'] == 0) ? ' - ' : number_format($rep['total_venta_gravado'] * 1.13, 2, '.', ''); ?></td>
          <td width="10%" class="dinero"><?php echo ($rep['fac_estado'] == 0) ? ' - ' : number_format($rep['exportacion'], 2, '.', ''); ?></td>
          <td width="10%" class="dinero"><?php echo ($rep['fac_estado'] == 0) ? ' - ' : number_format($rep['retencion'], 2, '.', ''); ?></td>
          <td width="10%" class="dinero"><?php echo ($rep['fac_estado'] == 0) ? ' - ' : number_format($rep['venta_no_sujeta'] + $rep['total_venta_exenta'] + $rep['total_venta_gravado'] * 1.13 + $rep['exportacion'], 2, '.', '') // 
                                          ?></td>
          <!-- <td width="10%"><?php echo ($rep['emp_estado'] == 0) ? 'Inactivo' : 'Activo'; ?></td> -->
        </tr>
      <?php
        if ($n_anterior) {
          $anterior_fila_unitaria = ($reporte[$n_anterior]['fac_estado'] == 0 ||  ($rep[$n_anterior]['fac_estado'] != 0 && $rep[$n_anterior]['total_venta_exenta'] > 0)) ? 1 : 0;
        }
        $n_anterior++;
      } ?>
      <?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') : ?>
        <tr nobr="true">
          <td width="40%" colspan="6" style="text-align:center"><b>TOTALES</b></td>
          <!-- <td width="10%"></td>
              <td width="10%"></td>                                
              <td width="5%"></td>                                
              <td width="10%"></td>   -->
          <td width="10%" class="dinero"><b><?php echo $simbolo . number_format($venta_no_sujeta, 2, '.', ''); ?></b></td>
          <td width="10%" class="dinero"><b><?php echo $simbolo . number_format($ventas_exentas, 2, '.', ''); ?></b></td>
          <td width="10%" class="dinero"><b><?php echo $simbolo . number_format($ventas_gravadas, 2, '.', ''); ?></b></td>
          <td width="10%" class="dinero"><b><?php echo $simbolo . number_format($ventas_exportaciones, 2, '.', ''); ?></b></td>
          <td width="10%" class="dinero"><b><?php echo $simbolo . number_format($retencion_total, 2, '.', ''); ?></b></td>
          <td width="10%" class="dinero"><b><?php echo $simbolo . number_format($venta_no_sujeta + $ventas_exentas + $ventas_gravadas + $ventas_exportaciones, 2, '.', '') // 
                                            ?></b></td>
        </tr>
      <?php endif; ?>
    <?php } else { ?>
      <?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') { ?>
        <tr nobr="true">
          <td colspan="12" align="center">No se encontraron registros</td>
        </tr>
      <?php } ?>
    <?php } ?>
  </tbody>
</table>
<?php if ($tipo_reporte == 'pdf' or $tipo_reporte == 'excel') : ?>
  <table>
    <tr noBr="true">
      <td>
        <table border="0" width="100%">
          <tr>
            <td height="20px"></td>
            <td></td>
            <td></td>
          </tr>
          <tr>
            <td width="10%"></td>
            <td width="30%">RESUMEN DEL CÁLCULO DEL DÉBITO FISCAL</td>
            <td width="40%"></td>
            <td width="10%"></td>
          </tr>
          <tr>
            <td width="10%"></td>
            <td width="30%">Ventas no sujetas:</td>
            <td width="40%"><?php echo $simbolo . ($venta_no_sujeta > 0) ? number_format($venta_no_sujeta, 2, '.', '') : '0.00'; ?></td>
            <td width="10%"></td>
          </tr>
          <tr>
            <td width="10%"></td>
            <td width="30%">Ventas exentas:</td>
            <td width="40%"><?php echo $simbolo . ($ventas_exentas > 0) ? number_format($ventas_exentas, 2, '.', '') : '0.00'; ?></td>
            <td width="10%"></td>
          </tr>
          <tr>
            <td width="10%"></td>
            <td width="30%">Ventas exportaciones:</td>
            <td width="40%"><?php echo $simbolo . ($ventas_exportaciones > 0) ? number_format($ventas_exportaciones, 2, '.', '') : '0.00'; ?></td>
            <td width="10%"></td>
          </tr>
          <?php $venta_gravada_neta =  $ventas_gravadas / 1.13 ?>
          <tr>
            <td width="10%"></td>
            <td width="30%">Ventas gravadas netas:</td>
            <td width="40%"><?php echo $simbolo . ($venta_gravada_neta > 0) ? (number_format($venta_gravada_neta, 2, '.', '')) : '0.00'; ?></td>
            <td width="10%"></td>
          </tr>
          <?php
          $venta_neta = ($venta_no_sujeta + $ventas_exentas + $ventas_exportaciones + $venta_gravada_neta);
          $iva = $venta_gravada_neta * 0.13;
          ?>
          <tr>
            <td width="10%"></td>
            <td width="30%"></td>
            <td width="40%">-------------------</td>
            <td width="10%"></td>
          </tr>
          <tr>
            <td width="10%"></td>
            <td width="30%">VENTA NETA:</td>
            <td width="40%"><?php echo $simbolo . ($venta_neta > 0) ? (number_format($venta_neta, 2, '.', '')) : '0.00'; ?></td>
            <td width="10%"></td>
          </tr>
          <tr>
            <td width="10%"></td>
            <td width="30%">IVA:</td>
            <td width="40%"><?php echo $simbolo . ($iva > 0) ? (number_format($iva, 2, '.', '')) : '0.00'; ?></td>
            <td width="10%"></td>
          </tr>
          <?php $venta_total = $venta_neta + $iva ?>
          <tr>
            <td width="10%"></td>
            <td width="30%">VENTA TOTAL:</td>
            <td width="40%"><?php echo $simbolo . ($venta_total > 0) ? (number_format($venta_total, 2, '.', '')) : '0.00'; ?></td>
            <td width="10%"></td>
          </tr>
          <tr>
            <td width="10%"></td>
            <td width="30%">RETENCION:</td>
            <td width="40%"><?php echo $simbolo . ($retencion_total > 0) ? (number_format($retencion_total, 2, '.', '')) : '0.00'; ?></td>
            <td width="10%"></td>
          </tr>

          <?php if ($tipo_reporte == 'pdf') : ?>
            <tr>
              <td height="20px"></td>
              <td></td>
              <td></td>
            </tr>
          <?php else : ?>
            <tr></tr>
          <?php endif; ?>
          <tr>
            <td colspan="11" align="center"><?php echo 'F.________________________________'; ?></td>
          </tr>
          <tr>
            <td colspan="11" align="center"><?php echo $firmas->REPRESENTANTE_LEGAL->NOMBRE; ?></td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
<?php endif; ?>