<?php

/**
 * @author Elman Ortiz
 * @copyright 2018
 */
?>
<?php
if ($tipo_reporte == 'excel') {
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header("content-disposition: attachment;filename=" . $filename . ".xls");
  header("Pragma: no-cache");
  header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
  <meta charset="utf-8" />
  <div class="head">
    <table>
      <tr>
        <td align="center" colspan="4">
          <h4>
            <?php
            echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
            ?> <br />
            Reporte consolidación partidas
          </h4>
        </td>
      </tr>
    </table>
  </div>
<?php } ?>

<?php if ($tipo_reporte == 'pdf') : ?>
  <style type="text/css">
    td {
      font-family: courier;
      font-size: 9px;
    }
  </style>
<?php endif; ?>

<?php if ($tipo_reporte == 'pdf' or $tipo_reporte == 'excel') : ?>
  <table border="0" width="100%">
    <tr>
      <td><?php echo '<b>FECHA PARTIDA: </b>' . date("d-m-Y"); ?></td>
    </tr>
    <tr>
      <td><?php echo $tipopartidatext; ?></td>
    </tr>
  </table>
  <table border="0" width="100%">
    <tr>
      <td><?php echo $fecha_iniciotext; ?></td>
      <td><?php echo $fecha_fintext; ?></td>
    </tr>
    <tr>
      <td><b>Centro de costo:</b> <?php echo ($centro != "") ? $centro : 'Todos'; ?></td>
      <td></td>
    </tr>
  </table>
<?php endif; ?>
<?php
$total_debe = 0.00;
$total_haber = 0.00;
?>
<table border="1px" id="tblListado" class="dynamicTable responsive table table-bordered" aria-describedby="table_2_info">
  <thead>
    <tr>
      <!-- <th style="display:none;"></th> -->
      <th width="30%">Cuenta.</th>
      <th width="40%">Nombre cuenta</th>
      <th width="15%">Debe</th>
      <th width="15%">Haber</th>
    </tr>
  </thead>
  <tbody>
    <?php if (count($reporte) > 0) { ?>
      <?php foreach ($reporte as $key => $rep) { ?>

        <tr nobr="true">
          <td width="30%"><?php echo $rep['cnt_cuenta']; ?></td>
          <td width="40%"><?php echo $rep['cnt_nombre']; ?></td>
          <td width="15%"><?php echo $rep['dpc_debe']; ?></td>
          <td width="15%"><?php echo $rep['dpc_haber']; ?></td>
        </tr>
      <?php
        $total_debe = $total_debe + $rep['dpc_debe'];
        $total_haber = $total_haber + $rep['dpc_haber'];
      } ?>
  <tfoot>
    <tr>
      <td width="70%" colspan="2" style="text-align:center"><b>Total</b></td>
      <td width="15%"><b><?php echo number_format($total_debe, 2) ?></b></td>
      <td width="15%"><b><?php echo number_format($total_haber, 2) ?></b></td>
    </tr>
  </tfoot>
  </tbody>
<?php } else { ?>
  <?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') { ?>
    <tr nobr="true">
      <td colspan="4" align="center">No se encontraron registros</td>
    </tr>
  <?php } else { ?>
    <tfoot>
      <tr nobr="true">
        <td colspan="4" style="text-align: center">No se encontraron registros</td>
      </tr>
    </tfoot>
  <?php } ?>
<?php } ?>


</table>