<meta charset="UTF-8">
<style type="text/css">
    .text {
        mso-number-format: "\@";
    }
</style>
<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$xcl = (isset($excel) && $excel > 0) ? true : false;
if ($xcl) {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment; filename = " . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
$salario_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO', 300);
$agui_exento = ($salario_min * 2);
$meses = array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
$afp_codes = array('MAX', 'COF', 'ISS');
?>
<table class="responsive table table-bordered" style="font-size: 9pt;">
    <thead>
        <tr style="font-weight: bold;">
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Nombre o Razón Social</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Documento</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Código Ingreso</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Monto Devengado</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Bonificación y Gratificaciones</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Impuesto Retenido</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Aguinaldo Exento</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Aguinaldo Gravado</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">ISSS</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">AFP</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">IPSFA</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">CEFAFA</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">INPEP</th>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">Bienestar Magisterial</th>
            <?php for ($i = 1; $i < 13; $i++) {  ?>
                <th colspan="3" style="text-align: center!important;"><?= $meses[$i] ?></th>
            <?php } ?>
            <th rowspan="2" style="vertical-align: middle;text-align: center;">A&ntilde;o</th>
        </tr>
        <tr>
            <?php for ($i = 1; $i < 13; $i++) {  ?>
                <th style="text-align: center!important;">Monto Afecto Mensual</th>
                <th style="text-align: center!important;">Monto Retenido Mensual</th>
                <th style="text-align: center!important;">Monto AFP Mensual</th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <?php
        $contador = 0;
        if (count($empleados2) > 0) {
            foreach ($empleados2 as $key => $codigo_ingresos) {
                $codigo_ingreso = ($key == 'codigo_1') ? '01' : '11';
                foreach ($codigo_ingresos as $k => $emp) {
                    $contador++;
                    if ($emp['emp_es_jubilado'] > 0 && $codigo_ingreso != '11') {
                        if ($emp['total_afp'] > 0 || $emp['total_isss'] > 0) {
                            $codigo_ing = $codigo_ingreso;
                        } else {
                            if ($emp['total_isr'] > 0) {
                                $codigo_ing = '80';
                            } else {
                                $codigo_ing = '81';
                            }
                        }
                    } else {
                        if ($emp['total_isr'] > 0) {
                            $codigo_ing = $codigo_ingreso;
                        } else {
                            $codigo_ing = '60';
                        }
                    }
                    if ($emp['aguinaldo'] > $agui_exento) {
                        $aguinaldo_exe = $agui_exento;
                        $aguinaldo_gra = ($emp['aguinaldo'] - $agui_exento);
                    } else {
                        $aguinaldo_exe = $emp['aguinaldo'];
                        $aguinaldo_gra = 0;
                    }
                    $afp_mensual = $emp['meses_afp'];
                    $arr_isr_mes = $emp['meses_isr'];
                    if ($emp['afp_codigo'] != "" && in_array(strtoupper($emp['afp_codigo']), $afp_codes)) {
                        $monto_afp_total = number_format($emp['total_afp'], 2);
                        $monto_inpep = $monto_ipsfa = number_format(0, 2);
                    } else {
                        $monto_afp_total = number_format(0, 2);
                        if (strtoupper($emp['afp_codigo']) == 'INP') {
                            $monto_ipsfa = number_format(0, 2);
                            $monto_inpep = number_format($emp['total_afp'], 2);
                        } else {
                            $monto_ipsfa = number_format($emp['total_afp'], 2);
                            $monto_inpep = number_format(0, 2);
                        }
                    }
        ?>
                    <tr style="white-space: nowrap;" nobr="true">
                        <td><?php echo $emp["empleado"]; ?></td>
                        <td class="text"><?php echo $emp["documento"]; ?></td>
                        <td class="text"><?php echo $codigo_ing; ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($emp['devengado'], 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($emp['gratificaciones'], 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($emp['total_isr'], 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($aguinaldo_exe, 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($aguinaldo_gra, 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($emp['total_isss'], 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . $monto_afp_total; ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . $monto_ipsfa; ?></td><?php //IPSFA 
                                                                                                    ?>
                        <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td><?php //CEFAFA 
                                                                                                        ?>
                        <td style="text-align:right;"><?php echo $simbolo . $monto_inpep; ?></td><?php //INPEP 
                                                                                                    ?>
                        <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td><?php //BIENESTAR MAGISTERIAL 
                                                                                                        ?>
                        <?php
                        for ($i = 1; $i <= 12; $i++) { ?>
                            <td style="text-align:right;"><?php echo $simbolo . number_format($arr_isr_mes[$i]['afecto'], 2); ?></td>
                            <td style="text-align:right;"><?php echo $simbolo . number_format($arr_isr_mes[$i]['mensual'], 2); ?></td>
                            <td style="text-align:right;"><?php echo $simbolo . number_format($afp_mensual[$i], 2); ?></td>
                        <?php
                        } ?>
                        <td><?php echo $year; ?></td>
                    </tr>
                <?php
                }
            }
        }
        if (count($proveedores) > 0) {
            foreach ($proveedores as $proveedor) {
                $codigo_prov = '09';
                $contador++;
                $where2['prv_id'] = $proveedor['prv_id'];
                $where2['DATE_FORMAT(dpv_fecha_contabilizacion,"%Y")']  = $year;
                $detalles2 = $this->contabilidad_model->get_planilla_proveedores($where2, 'prv_id, MONTH( dpv_fecha_contabilizacion)', $year, $renta);
                $arr_mes = array();
                foreach ($detalles2 as $dt2) {
                    $arr_mes[$dt2['mes']] = $dt2['retenciones'];
                } ?>
                <tr nobr="true" style="white-space: nowrap;">
                    <td><?php echo $proveedor['proveedor']; ?></td>
                    <td><?php echo $proveedor['nit']; ?></td>
                    <td><?php echo $codigo_prov; ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format($proveedor['total'], 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format($proveedor['retenciones'], 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <?php
                    for ($i = 1; $i <= 12; $i++) {
                        if (array_key_exists($i, $arr_mes)) {
                    ?>
                            <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                            <td style="text-align:right;"><?php echo $simbolo . number_format($arr_mes[$i], 2); ?></td>
                            <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                        <?php
                        } else {
                        ?>
                            <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                            <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                            <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <?php
                        }
                    }
                    ?>
                    <td><?php echo $year; ?></td>
                </tr>
            <?php
            }
        }
        if ($contador == 0) {
            ?>
            <tr>
                <td colspan="51" style="font-weight: bold;">No se encontraron registros</td>
            </tr>
        <?php
        }
        ?>
    </tbody>
</table>