<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$salario_min = $this->gsatelite->get_parametro('MONTO_SALARIO_MINIMO', 300);
$agui_exento = ($salario_min * 2);
$meses = array('Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
$afps = array('MAX', 'COF', 'ISS');
?>
<table class="responsive table table-bordered" style="font-size: 9pt;">
    <tr style="font-weight: bold;">
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Nombre o Razón Social</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Documento</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Código Ingreso</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Monto Devengado</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Bonificación y Gratificaciones</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Impuesto Retenido</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Aguinaldo Exento</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Aguinaldo Gravado</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">ISSS</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">AFP</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">IPSFA</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">CEFAFA</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">INPEP</th>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">Bienestar Magisterial</th>
        <?php foreach ($meses as $key => $value) : ?>
            <th colspan="3" style="text-align: center!important;"><?= $value ?></th>
        <?php endforeach ?>
        <th rowspan="2" style="vertical-align: middle;text-align: center;">A&ntilde;o</th>
    </tr>
    <tr>
        <?php foreach ($meses as $key => $value) : ?>
            <th style="text-align: center!important;">Monto Sujeto de Retención Mensual</th>
            <th style="text-align: center!important;">Monto Retenido Renta Mensual</th>
            <th style="text-align: center!important;">AFP Mensual</th>
        <?php endforeach ?>
    </tr>
    <?php
    $contador = 0;
    if (count($empleados) > 0) {
        foreach ($empleados as $emp) {
            $arr_isr_mes = $arr_afp_mes = array();
            $contador++;
            $where['emp_id'] = $emp['emp_id'];
            $where['DATE_FORMAT(pla_fecha_inicio,"%Y")']    = $year;
            $detalles = $this->contabilidad_model->get_isr_planilla($where);
            foreach ($detalles as $dt) {
                $arr_isr_mes[$dt['mes']] = $dt['isr'];
                $arr_ing_mes[$dt['mes']] = $dt['ingreso'];
            }
            $afp_mensual = $this->contabilidad_model->get_afp_mensual(array('ddd_id_emp' => $emp['emp_id'], 'DATE_FORMAT(pla_fecha_inicio,"%Y")' => $year));
            foreach ($afp_mensual as $afp) {
                $arr_afp_mes[$afp['mes']] = $afp['afp'];
            }
            $codigo = '01';
            if ($emp['emp_es_jubilado'] > 0) {
                $codigo = '80';
            }
            if ($emp['aguinaldo'] > $agui_exento) {
                $aguinaldo_exe = $agui_exento;
                $aguinaldo_gra = ($emp['aguinaldo'] - $agui_exento);
            } else {
                $aguinaldo_exe = $emp['aguinaldo'];
                $aguinaldo_gra = 0;
            }
    ?>
            <tr style="white-space: nowrap;">
                <td><?php echo $emp["empleado"]; ?></td>
                <td><?php echo $emp["nit"]; ?></td>
                <td><?php echo $codigo; ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format($emp['devengado'], 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format($emp['bonificaciones'], 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format($emp['renta'], 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format($aguinaldo_exe, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format($aguinaldo_gra, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format($emp['isss'], 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . (in_array(strtoupper($emp['afp_codigo']), $afps)) ? number_format($emp['afp'], 2) : number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . (!(in_array(strtoupper($emp['afp_codigo']), $afps)) && strtoupper($emp['afp_codigo']) != 'INP') ? number_format($emp['afp'], 2) : number_format(0, 2); ?></td><?php //IPSFA 
                                                                                                                                                                                                                                    ?>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td><?php //CEFAFA 
                                                                                                ?>
                <td style="text-align:right;"><?php echo $simbolo . (strtoupper($emp['afp_codigo']) == 'INP') ? number_format($emp['afp'], 2) : number_format(0, 2); ?></td><?php //INPEP 
                                                                                                                                                                            ?>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td><?php //BIENESTAR MAGISTERIAL 
                                                                                                ?>
                <?php
                for ($i = 1; $i <= 12; $i++) {
                    $mes_afp = (array_key_exists($i, $arr_afp_mes)) ? $arr_afp_mes[$i] : 0;
                    $mon_suj = (array_key_exists($i, $arr_ing_mes) && $emp['emp_es_jubilado'] < 1) ? $arr_ing_mes[$i] : 0;
                    if (array_key_exists($i, $arr_isr_mes)) {
                ?>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($mon_suj, 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($arr_isr_mes[$i], 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($mes_afp, 2); ?></td>
                    <?php
                    } else {
                    ?>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($mon_suj, 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($mes_afp, 2); ?></td>
                <?php
                    }
                }
                ?>
                <td><?php echo $year; ?></td>
            </tr>
        <?php
        }
    }
    if (count($proveedores) > 0) {
        foreach ($proveedores as $proveedor) {
            $codigo_prov = '09';
            $contador++;
            $where2['prv_id'] = $proveedor['prv_id'];
            $where2['DATE_FORMAT(dpv_fecha_contabilizacion,"%Y")']  = $year;
            $detalles2 = $this->contabilidad_model->get_planilla_proveedores($where2, 'prv_id, MONTH( dpv_fecha_contabilizacion)', $year, $renta);
            $arr_mes = array();
            foreach ($detalles2 as $dt2) {
                $arr_mes[$dt2['mes']] = $dt2['retenciones'];
            } ?>

            <tr style="white-space: nowrap;">
                <td><?php echo $proveedor['proveedor']; ?></td>
                <td><?php echo $proveedor['nit']; ?></td>
                <td><?php echo $codigo_prov; ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format($proveedor['total'], 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format($proveedor['retenciones'], 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <?php
                for ($i = 1; $i <= 12; $i++) {
                    if (array_key_exists($i, $arr_mes)) {
                ?>
                        <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format($arr_mes[$i], 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                    <?php
                    } else {
                    ?>
                        <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                        <td style="text-align:right;"><?php echo $simbolo . number_format(0, 2); ?></td>
                <?php
                    }
                }
                ?>
                <td><?php echo $year; ?></td>
            </tr>
        <?php
        }
    }
    if ($contador == 0) {
        ?>
        <tr>
            <td colspan="47" style="font-weight: bold;">No se encontraron registros</td>
        </tr>
    <?php
    }
    ?>
</table>