<?php 
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
//0 proveedores  && 1 clientes
if ($tipo_reporte == 'excel') { 
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="0">
            <tr>
                <td align="center" colspan="3" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de <?php echo ($tipo > 0) ? 'Clientes' : 'Proveedores'; ?> con Configuracion Contable Pendiente para el Tipo de Cuenta: <?= $nombre_cuenta; ?>
                    </h4>
                </td>
            </tr>
        </table>        
    </div>
    <br>
    <br>
    <?php 
} 

$font = ($tipo_reporte == 'pdf') ? 'style="font-size: 10pt;"' : 'style="font-size: 12pt;"';
$borde = ($tipo_reporte == 'pdf') ? 1 : 0;
?>
<table border="<?= $borde ?>" cellpadding="1" id="tblListado" class="dynamicTable responsive display table table-bordered" <?php echo $font; ?>>
    <thead id="encabezado">
        <tr align="center">
            <th style="font-weight: bold;" width="20%">Codigo</th>
            <th style="font-weight: bold;" width="55%"><?php echo ($tipo > 0) ? 'Cliente' : 'Proveedor'; ?></th>
            <th style="font-weight: bold;" width="25%">Personeria</th>                                        
        </tr>
    </thead>
    <tbody id="tbContenedorListado">
        <?php if (count($datos) > 0): ?>
            <?php foreach ($datos as $key => $value): ?>
                <?php 
                if ($tipo > 0) {
                    $nombre = ($value['cli_personeria'] > 1) ? $value['cli_apellido'] : $value['cli_nombre'] . ' ' . $value['cli_apellido'];
                    $personeria = ($value['cli_personeria'] > 1) ? 'Personería Jurídica' : 'Persona Natural';
                } else {
                    $nombre = ($value['prv_tipo_pers'] > 1) ? $value['prv_apellido'] : $value['prv_nombre'] . ' ' . $value['prv_apellido']; 
                    $personeria = ($value['prv_tipo_pers'] > 1) ? 'Personería Jurídica' : 'Persona Natural';
                }                
                ?>
                <tr>
                    <td style='mso-number-format:"@";' width="20%"><?php echo ($tipo > 0) ? $value['cli_codigo'] : $value['prv_codigo']; ?></td>
                    <td width="55%"><?php echo $nombre; ?></td>
                    <td width="25%"><?php echo $personeria; ?></td>
                </tr>
            <?php endforeach ?>    
        <?php else: ?>
            <tr>
                <th colspan="3" style="text-align: center;"><b>No se Encontrarón Registros para los Filtros Aplicados</b></th>                                        
            </tr> 
        <?php endif ?>
    </tbody>
</table>