<?php
$total_facturacion = 0;
$total_compra = 0;
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="0">
            <tr>
                <td align="center" colspan="3">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Contabilidad por Centro de Costo
                    </h4>
                </td>
            </tr>
            <tr>
                <td align="center" colspan="3">
                    <b>Del <?php echo formatear_fecha('d-m-Y', $fecha_ini); ?> al <?php echo formatear_fecha('d-m-Y', $fecha_fin); ?></b>
                </td>
            </tr>
        </table>
    </div>
    <br>
    <br>
<?php
}

$font = ($tipo_reporte == 'pdf') ? 'style="font-size: 10pt;"' : 'style="font-size: 12pt;"';
$fondo = ($tipo_reporte != '') ? 'style="border: black 1px solid;font-weight: bold;"' : '';
?>
<table border="0" cellpadding="1" id="tblListado" class="dynamicTable responsive display table table-bordered" <?php echo $font; ?>>
    <thead id="encabezado">
        <tr align="center">
            <th <?php echo $fondo; ?>>Centro de Costo</th>
            <th <?php echo $fondo; ?>>Facturación</th>
            <th <?php echo $fondo; ?>>Compras</th>
        </tr>
    </thead>
    <tbody id="tbContenedorListado">
        <?php if (count($reporte) > 0) : ?>
            <?php foreach ($reporte as $key => $value) : ?>
                <?php
                $total_facturacion += number_format($value['facturacion'], 2, '.', '');
                $total_compra += number_format($value['compras'], 2, '.', '');
                ?>
                <tr>
                    <td><?php echo $value['cec_codigo'] . ' - ' . $value['cec_nombre']; ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($value['facturacion'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($value['compras'], 2); ?></td>
                </tr>
            <?php endforeach ?>
        <?php else : ?>
            <?php if ($tipo_reporte != '') : ?>
                <tr align="center">
                    <th colspan="3"><b>No se Encontrarón Registros</b></th>
                </tr>
            <?php endif ?>
        <?php endif ?>
    </tbody>
    <?php if (count($reporte) > 0) : ?>
        <tfoot>
            <tr>
                <th style="border-top: solid 1px black;">TOTAL</th>
                <th style="text-align: right;border-top: solid 1px black;"><?php echo $simbolo . number_format($total_facturacion, 2); ?></th>
                <th style="text-align: right;border-top: solid 1px black;"><?php echo $simbolo . number_format($total_compra, 2); ?></th>
            </tr>
        </tfoot>
    <?php endif ?>
</table>