<?php
$total_general = 0;
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Pago a cuenta
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}

$porcentaje = ($empresa[0]['gir_porcentaje_pago_cuenta'] > 0) ? ($empresa[0]['gir_porcentaje_pago_cuenta'] / 100) : (1 / 100);
$borde = ($tipo_reporte == 'pdf') ? 'style="text-align: center; border: black 1px solid;"' : 'style="text-align: center;"';
$bde_t = ($tipo_reporte == 'pdf') ? 'style="text-align: right; border-top: black 1px solid;"' : 'style="text-align: right;"';
$total_general += number_format(($fac_sub_total * $porcentaje), 2, '.', '');
$total_general += number_format($isr_total, 2, '.', '');
$total_general += number_format($renta_emp, 2, '.', '');
?>
<table class="table table-bordered responsive display" width="100%" border="0">
    <thead>
        <tr>
            <th colspan="2"><b>Empresa:</b> <?php echo $empresa[0]['emr_nombre']; ?></th>
            <th></th>
            <th style="text-align: right;"><b>Período:</b> <?php echo $fecha; ?></th>
        </tr>
        <tr>
            <th <?= $borde ?> colspan="2"><b>Concepto</b></th>
            <th <?= $borde ?>><b>Monto</b></th>
            <th <?= $borde ?>><b>Valor a Cuenta</b></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="2">Venta Total sin impuestos</td>
            <td style="text-align: right;"><?php echo $simbolo . number_format($fac_sub_total, 2); ?></td>
            <td style="text-align: right;"><?php echo $simbolo . number_format(($fac_sub_total * $porcentaje), 2); ?></td>
        </tr>
        <tr>
            <td colspan="2">Descuento del Impuesto sobre la Renta en Planilla</td>
            <td style="text-align: right;"></td>
            <td style="text-align: right;"><?php echo $simbolo . number_format($isr_total, 2); ?></td>
        </tr>
        <tr>
            <td colspan="2">Descuento del 10% de Renta en Planilla</td>
            <td style="text-align: right;"></td>
            <td style="text-align: right;"><?php echo $simbolo . number_format($renta_emp, 2); ?></td>
        </tr>
    </tbody>
    <tfoot>
        <tr>
            <td <?= $bde_t ?> colspan="3"><b>Total</b></td>
            <td <?= $bde_t ?>><?php echo $simbolo . number_format($total_general, 2) ?></td>
        </tr>
    </tfoot>
</table>