<meta charset="utf-8" />
<style type='text/css'>
    body{
        font-family: Arial;
        font-size: 14px;
    }
    a {
        color: blue;
        text-decoration: none;
        font-size: 14px;
    }
    a:hover{
        text-decoration: underline;
    }
    .width{
        min-width: 90px;max-width: 90px;
        padding-left: 2%;
        /*border-style:solid;*/
    }
</style>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Filtrar</span>
                </h4>
            </div>            
            <div class="content">
                <form name="form-filtro" id="form-filtro" method="POST" >
                    <div class="row-fluid">
                        <label class="form-label span2 width" >Desde:</label>
                        <div class="span2 controls" >
                            <input type="text" id="fecha_desde" name="fecha_desde" value="<?= (isset($fecha_desde) && $fecha_desde != '') ? formatear_fecha('d-m-Y', $fecha_desde) : date('d-m-Y'); ?>" style="min-width: 160px; max-width:160px;" />
                            <br>
                            <div id="fecha_desde_error" style="color:red;font-size:11px;"></div>
                        </div>
                        <label class="form-label span2 width" style="margin-left:5%" >Hasta:</label>
                        <div class="span2 controls" >
                            <input type="text" id="fecha_hasta" name="fecha_hasta" style="" value="<?php
                            if (isset($fecha_hasta) && $fecha_hasta != '') {
                                echo date('d-m-Y', strtotime($fecha_hasta));
                            } else {
                                echo date('d-m-Y');
                            }
                            ?>" alias='' style="min-width: 160px; max-width:160px;" />
                            <div id="fecha_hasta_error" style="color:red;font-size:11px;"></div>
                        </div>
                        <label class="form-label span2 width" >Proceso:</label>
                        <div class="span2 controls" >
                            <select id="proceso_partida" multiple="true" name="proceso_partida[]" class="nostyle" style="width:100%" placeholder="Seleccione">
                                <option value=""></option>
                                <option value="1">Facturación</option>
                                <option value="2">Abono Factura</option>
                                <option value="3">Anticipos</option>
                                <option value="4">Doc. Proveedor</option>
                                <option value="5">Planilla</option>
                                <option value="6">Inventario</option>
                                <option value="7">Caja Chica</option>
                                <option value="8">Contabilidad</option>
                                <option value="9">Bancos - Cheque</option>
                                <option value="10">Bancos - N. Abono</option>
                                <option value="11">Bancos - Transacciones</option>
                                <option value="12">Bancos - Otr. F. Pago</option>
                            </select>
                            <div id="proceso_error" style="color:red;font-size:11px;margin-top: 5px;"></div>
                        </div>
                        <button type="button" class="btn btn-info" title="Filtrar" id="filtro" style="margin-left: 15px;">
                            <span class="icon16 icomoon-icon-search-3 white"></span>
                            <strong> Buscar</strong>
                        </button>
                        <div>
                        </div>
                    </div>
                    <a class="btn btn-large" style="margin-left: 1%;" href="<?php echo base_url('modulo_contabilidad/procesos/agregar_partida') ?>" title="Agregar partida contable">
                        <strong >Agregar partida contable</strong>
                    </a>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Partidas</span>
                </h4>
            </div>        
            <div class="content noPad clearfix" id="datos">
                <table id="datagried1" cellpadding="0" cellspacing="0" border="0" class="responsive display  dynamicTable table table-bordered" width="100%">
                    <thead>
                        <tr>
                            <th>Partida</th>
                            <th id="thCodigo" >Código</th>
                            <th>Fecha</th>
                            <th>Concepto partida</th>
                            <th>Monto</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <?php foreach ($query as $key => $value) { ?>
                        <tr>
                            <td><?php echo $value['pct_correlativo']; ?></td>
                            <td><?php echo $value['pct_codigo']; ?></td>
                            <td><?php echo date('d-m-Y', strtotime($value['pct_fecha'])); ?></td>
                            <td><?php echo $value['pct_concepto']; ?></td>
                            <td><?php echo number_format($value['pct_total'], 2); ?></td>
                            <td>
                                <div class="tools">
                                    <div class="btn-group">
                                        <button class="btn" type="button"><span >Acciones</span></button>
                                        <button class="btn dropdown-toggle" data-toggle="dropdown">
                                            <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <?php if ($value['pct_estado'] == 1 && (!(is_numeric($value['pct_editable_periodo']) && $value['pct_editable_periodo'] == 0))) { ?>
                                                <li>
                                                    <a href="<?php echo base_url(); ?>modulo_contabilidad/procesos/editar_partida/<?php echo $value['pct_id'] . '/1'; ?>" name="<?php echo $value['pct_id']; ?>">
                                                        <span aria-hidden="true" class="icomoon-icon-pencil-5"></span>
                                                        Editar
                                                    </a>
                                                </li>
                                                <?php 
                                            }
                                            if ($value['pct_estado'] == 1 && (!(is_numeric($value['pct_editable_periodo']) && $value['pct_editable_periodo'] == 0))) { ?>
                                                <li>
                                                    <a title="Eliminar" class="del_ptda" data-borrar="<?= $value['pct_id'] ?>" data-fecha="<?= formatear_fecha('Y-m-d', $value['pct_fecha']) ?>"  name="<?= $value['pct_id'] ?>">
                                                        <span aria-hidden="true" class="icomoon-icon-remove"> Eliminar</span>
                                                    </a>
                                                </li>
                                            <?php } ?>
                                            <li>
                                                <a class="ver_en_modal_ajax2" href="<?php echo base_url(); ?>modulo_contabilidad/procesos/ver_partida_modal/<?php echo $value['pct_id']; ?>" name="<?php echo $value['pct_id']; ?>">
                                                    <span aria-hidden="true" class="icomoon-icon-printer"></span>
                                                    Ver
                                                </a>
                                            </li>
                                            <?php if ($value['pct_estado'] == 1 && validarFechaPeriodoContable(formatear_fecha('Y-m-d', $value['pct_fecha']))) { ?>
                                                <li>
                                                    <a href="<?php echo base_url(); ?>modulo_contabilidad/procesos/duplicar_partida/<?php echo $value['pct_id']; ?>" name="<?php echo $value['pct_id']; ?>">
                                                        <span aria-hidden="true" class="icomoon-icon-copy-2"></span>
                                                        Duplicar
                                                    </a>
                                                </li>
                                            <?php } ?>
                                            <li>
                                                <a target="_blank" href="<?= base_url(); ?>modulo_contabilidad/procesos/excel_partida/<?= $value['pct_id']; ?>">
                                                    <span class="icomoon-icon-file-2"></span>
                                                    Exportar
                                                </a>
                                            </li>
                                            <?php if ($retaceo[$value['pct_id']] != "") { ?>
                                                <li>
                                                    <a target="_blank" href="<?php echo base_url(); ?>modulo_compras/procesos/imprimir_retaceo/<?php echo $retaceo[$value['pct_id']]; ?>" >
                                                        <span aria-hidden="true" class="icomoon-icon-printer"> Imprimir Retaceo</span>
                                                    </a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </div> 
                            </td>
                        </tr>
                        <?php 
                    }
                    ?>
                </table>
            </div>
        </div>
    </div>
</div>


<script type="text/javascript">
    jQuery(document).ready(function ($) {

        $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
        $("input[name^='fecha']").mask("99-99-9999");
        $("input[name^='fecha']").attr('placeholder', "dd-mm-yyyy");
        $("#dependencia").select2();
        $("#proceso_partida").select2();
        //	$("a.btn-large:first").attr('href', '<?php echo base_url("modulo_contabilidad/procesos/agregar_partida"); ?>');
        //$("#DataTables_Table_0_filter").remove();

        $("#filtro").click(function () {
            if ($("#fecha_desde").val() != '' || $("#fecha_hasta").val() != '') {
                var fecha_ini = $("#fecha_desde").val();
                var fecha_fin = $("#fecha_hasta").val();
                verifica_fecha(fecha_ini, fecha_fin);
                if ($("#fecha_hasta_error").text() == '') {
                    wait.start();
                    $.ajax({
                        url: 'consulta_partida_contable',
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            fecha_ini: fecha_ini, 
                            fecha_fin: fecha_fin, 
                            proceso_partida: $("#proceso_partida").val()
                             },
                        success: function (json) {
                            wait.close();
                            $('#datos').html('');
                            $('#datos').html(json.html);
                            $('#datagried').dataTable({"aaSorting": [[ 1, "asc" ]] }); // Sort by first column descending);

                            $("#balance_grl").show('slide');
                            if (Number(json.respuesta) == 1) {
                                $('#pdf').hide();
                            } else {
                                $('#pdf').show();
                            }
                        }
                    });
                }
            } else {
                //location.href = urlj+'modulo_contabilidad/procesos/partida_contable';
            }
        });

        $("body").on('click', '.del_ptda', function(event) {
            event.preventDefault();
            var datos = [$(this).data("borrar"), $(this).data("fecha")];
            alerta_confirm_ajax(borrar_partida, datos, 'Alerta de Confirmación', '¿Está seguro que desea eliminar esta Partida Contable? <br />Esta acción no se puede revertir y deberá procesar nuevamente la(s) partida(s) si desea restablecer la información.');
        });

        $("body").on('click', '.activa_una', function(event) {
            event.preventDefault();
            alerta_confirm_ajax(activa_edit_partida, $(this).data("activate"), 'Alerta de Confirmación', '¿Está seguro que desea desbloquear esta Partida Contable? <br />Esta acción le permitira realizar una edicion a la partida.');
        });


        // $("#main-table-box").hide();

        function verifica_fecha(fecha_ini, fecha_fin) {
            //Convierto la fecha a Y-m-d
            var fecha_i = fecha_ini.split("-").reverse().join("-");
            var fecha_f = fecha_fin.split("-").reverse().join("-");

            if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
                $("#fecha_hasta_error").text('');
                return true;
            }

            if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
                $("#fecha_hasta").addClass('error');
                $("#fecha_hasta_error").text("Verifique las fechas del período");
                return false;
            }

            if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
                $("#fecha_hasta").removeClass('error');
                $("#fecha_hasta_error").text('');
                return true;
            }
        }

        //Ajax para mostrar los detalles de una factura
        $("body").on('click', '.ver_detalle_factura', function(event) {
            event.preventDefault();
            id_factura = $(this).attr('id_factura');
            url_ajax = window.satelite.base_url('modulo_cuentas_cobrar/procesos/detalle_factura');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    id_factura: id_factura
                },
                beforeSend: function () {
                    wait.start();
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    wait.close();
                    $.fancybox(json.html);
                }
            });
        });

        $("body").on('click', '.ver-accion-modal', function (event) {
            event.preventDefault();
            var url = $(this).attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width:'100%',
                closeBtn: true
            });
        });

    });

function borrar_partida(datos) {
    console.log(datos);
    var splitFecha = datos[1].split("-");
    var codigoPeriodo = splitFecha[0] + splitFecha[1]; 
    var indexMes = periodosContables.findIndex(x => x.codigo === codigoPeriodo);
    var direccion = "<?= base_url('modulo_contabilidad/procesos/inactivar_partida') ?>"; 
    direccion += '/' + datos[0];
    if (indexMes < 0) {
        crear_alerta('error', 'Periodos Contables','Fecha de la partida fuera de los periodos contables');
        return false;
    } else {
        window.location = direccion; 
    }
}

function activa_edit_partida(id_partida) {
    wait.start();    
    setTimeout(function() {
        $.ajax({
            type: 'POST',
            url: urlj + 'modulo_contabilidad/procesos/activacion_individual/' + id_partida,
            success: function (respuesta) {
                if (Number(respuesta) == 1) {
                    $("#filtro").trigger('click');
                }
                wait.close();
            }
        });    
    }, 200);
    
}
</script>