<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$concepto = (trim($detalle[0]['pct_concepto']) != "") ? trim($detalle[0]['pct_concepto']) : "partida_" . formatear_fecha('Ymd', $detalle[0]['pct_fecha']);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("content-disposition: attachment;filename=\"" . $concepto . ".xls\"");
header("Pragma: no-cache");
header("Expires: 0");
?>
<style type="text/css">
	.tabla {
		font-weight: normal !important;
		font-family: 'Arial';
		border: 1px solid black;
	}

	.tabla th {
		border: 1px solid black;
		vertical-align: middle;
		text-align: center;
	}

	.tabla td {
		border: 1px solid black;
		vertical-align: middle;
		text-align: center;
	}

	.text {
		mso-number-format: "\@";
	}

	.texto {
		font-family: Arial;
		font-size: 14px;
	}
</style>
<?php
if (count($detalle) > 0) {
?>
	<table class="texto" width="100%">
		<tr>
			<th colspan="4"><b>Concepto: </b><?php echo $detalle[0]['pct_concepto']; ?></th>
		</tr>
		<tr>
			<th colspan="4"><b>Tipo: </b><?php echo $detalle[0]['tpd_nombre']; ?></th>
		</tr>
		<tr>
			<th colspan="4"><b>Fecha: </b><?php echo date('d-m-Y', strtotime($detalle[0]['pct_fecha'])); ?></th>
		</tr>
	</table>
	<table class="texto" width="100%">
		<tr>
			<th style="border-bottom: 1px solid; text-align: left;">Cuenta</th>
			<th style="border-bottom: 1px solid; text-align: left;">Nombre de Cuenta</th>
			<th style="border-bottom: 1px solid; text-align: left;">Descripción</th>
			<th style="border-bottom: 1px solid;">Debe (<?= $simbolo ?>)</th>
			<th style="border-bottom: 1px solid;">Haber (<?= $simbolo ?>)</th>
		</tr>
		<?php
		$debe = 0;
		$haber = 0;
		foreach ($detalle as $key) {
			$debe += $key['dpc_debe'];
			$haber +=  $key['dpc_haber'];
		?>
			<tr>
				<td class="text" style="text-align: left;  "><?php echo $key['cnt_cuenta']; ?></td>
				<td class="text" style="text-align: left;  "><?php echo $key['cnt_nombre'] /* $key['dpc_concepto'] */; ?></td>
				<td class="text" style="text-align: left;  "><?php echo $key['dpc_descripcion']; ?></td>
				<td style="text-align: right;"><?php echo number_format($key['dpc_debe'], 2); ?></td>
				<td style="text-align: right;"><?php echo number_format($key['dpc_haber'], 2); ?></td>
			</tr>
		<?php
		} ?>
		<tr>
			<th colspan="3" style="text-align: right; border-top:1px solid; ">Total</th>
			<th style="text-align: right; border-top:1px solid;  "><?php echo number_format($debe, 2, '.', ','); ?></th>
			<th style="text-align: right; border-top:1px solid;  "><?php echo number_format($haber, 2, '.', ','); ?></th>
		</tr>
	</table>
<?php } else {
?>
	<div style="text-align: center;">
		<h3><b>Partida pendiente de procesar</b></h3>
	</div>
<?php } ?>