<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
?>
<table class="responsive table table-bordered" id="partidas" border="0">
    <thead>
        <tr>
            <?php if ($consolidar == 0) { ?>
                <th><?php if (count($partidas) > 0) { ?><input type="checkbox" id="check_all" checked> <span style="font-size: 6pt;">(Todas)</span><?php } ?></th>
            <?php } ?>
            <th>Corr.</th>
            <th>Código</th>
            <th>Concepto</th>
            <th>Debe <?= ($simbolo != " ") ? "(" . $simbolo . ")" : ""; ?></th>
            <th>Haber <?= ($simbolo != " ") ? "(" . $simbolo . ")" : ""; ?></th>
            <th>Acciones</th>
        </tr>
    </thead>
    <tbody>
        <?php
        $total_total  = 0;
        foreach ($partidas as $key => $fila) {
            if (trim($fila['ids_referencias']) != '') {
                $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + ($key + 1);
                $numero = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
                $cod = $numero;
                $total_total += number_format($fila['total_partida'], 2, '.', '');
                $concepto_partida = $fila['concepto_partida'];
                $concepto_partida .= ($consolidar == 0) ? " - " . $fila['tac_nombre'] . ' ' . formatear_fecha('d-m-Y', $fecha) : "";
                ?>
                <tr id="tr_<?php echo ($key + 1); ?>" data-ident="<?php echo ($key + 1); ?>" class="validar_interna">
                    <?php if ($consolidar == 0) { ?>
                        <td>
                            <input type="checkbox" class="checkear" checked data-id="<?= ($key + 1) ?>">
                            <input type="hidden" id="procesar_<?= ($key + 1) ?>" name="procesar[]" value="1">
                        </td>
                    <?php } ?>
                    <td>
                        <span><?php echo ($key + 1); ?></span>
                        <input type="hidden" name="correlativopartida[]" id="txt_correlativopartida_<?php echo ($key + 1); ?>" value="<?php echo ($key + 1); ?>">
                    </td>
                    <td style="text-align:center;">
                        <input type="hidden" name="contenedorpartidas[]" id="contenedorpartidas" value="<?php echo $fila['ids_referencias']; ?>">
                        <input type="hidden" name="txtcorrelativopartida[]" id="txt_p_correlativopartida_<?php echo ($key + 1); ?>" value="<?php echo $cod; ?>">
                        <label id="lbl_p_corr_<?php echo ($key + 1); ?>"><?php echo $cod; ?></label>
                    </td>
                    <td style="text-align:center;">
                        <input type="hidden" name="txtconcepto[]" id="txt_pconcepto" value="<?php echo $concepto_partida; ?>">
                        <label id="lbl_p_concepto_<?php echo ($key + 1); ?>"><?php echo $concepto_partida; ?></label>
                    </td>
                    <td style="text-align:center;">
                        <input type="hidden" name="txtdebe[]" id="txt_p_debe_<?php echo ($key + 1); ?>" value="<?php echo number_format($fila['total_partida'], 2, '.', ''); ?>">
                        <label id="lbl_p_debe_<?php echo ($key + 1); ?>"><?php echo number_format($fila['total_partida'], 2, '.', ','); ?></label>
                    </td>
                    <td style="text-align:center;">
                        <input type="hidden" name="txthaber[]" id="txt_p_debe_<?php echo ($key + 1); ?>" value="<?php echo number_format($fila['total_partida'], 2, '.', ''); ?>">
                        <label id="lbl_p_haber_<?php echo ($key + 1); ?>"><?php echo number_format($fila['total_partida'], 2, '.', ','); ?></label>
                    </td>
                    <td>
                        <div class="tools">
                            <div class="btn-group">
                                <button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button>
                                <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                                <ul class="dropdown-menu">
                                    <li>
                                        <a id="id_<?php echo ($key + 1); ?>" class="fancy_detalle_partida fac_det " href="#detalle_<?php echo ($key + 1); ?>">
                                            <span aria-hidden="true" class="icomoon-icon-search-2"> Ver</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <?php if ($consolidar == 0) { ?>
                        <td></td>
                    <?php } ?>
                    <td></td>
                    <td></td>
                    <td style="text-align: center;">
                        <h4><strong>Totales</strong></h4>
                    </td>
                    <td>
                        <input type="hidden" name="txt_g_debe[]" id="txt_g_debe" value="<?php echo number_format($fila['total_partida'], 2, '.', ''); ?>">
                        <label id="lbl_g_debe" rowid="<?=($key + 1)?>" class="tot_debe"><?php echo number_format($fila['total_partida'], 2, '.', ','); ?></label>
                    </td>
                    <td>
                        <input type="hidden" name="txt_g_haber[]" id="txt_g_haber" value="<?php echo number_format($fila['total_partida'], 2, '.', ''); ?>">
                        <label id="lbl_g_haber" rowid="<?=($key + 1)?>" class="tot_habe"><?php echo number_format($fila['total_partida'], 2, '.', ','); ?></label>
                    </td>
                    <td></td>
                </tr>
                <?php
            }
        }
        ?>
    </tbody>
</table>
<?php

//recorrer nuevamente las partidas para dibujar sus detalles
foreach ($partidas as $key => $fila) {
    $valid_debe = $valid_haber = 0;
    if (trim($fila['ids_referencias']) != '') {
        //Correlativo de la partida contable
        $correlativo_partida = $this->gsatelite->get_max('pct_partida_contable', 'pct_correlativo') + ($key + 1);
        $numero = str_pad($correlativo_partida, 5, '0', STR_PAD_LEFT);
        $cod = $numero;
        $total_partida = number_format($fila['total_partida'], 2, '.', '');
        ?>
        <div class="row-fluid form-fluid" style="display: none;" id="detalle_<?php echo ($key + 1); ?>">
            <div class="form-fluid row-fluid">
                <div class="span12">
                    <div class="box">
                        <div class="title">
                            <h4>
                                Detalles de partida
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close" data-idfila="<?php echo ($key + 1); ?>">
                                    <span aria-hidden="true" class="minia-icon-close"></span>
                                </button>
                            </h4>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-fluid row-fluid">
                <div class="span12">
                    <!-- Cuenta Contable -->
                    <div class="span5">
                        <label class="form-label span4">Cuenta:</label>
                        <div class="span1"></div>
                        <div class="span7 controls">
                            <select id="slcCuenta_<?php echo ($key + 1); ?>" class="nostyle slcCuentas" placeholder="Seleccione">
                                <option value=""></option>
                                <?php echo str_replace('<option value="0">Seleccione</option>', '', $cuentas_cnt); ?>
                            </select>
                        </div>
                    </div>
                    <!-- Cantidad para el Debe -->
                    <div class="span3">
                        <label class="form-label span6">Monto Debe:</label>
                        <div class="span1"></div>
                        <div class="span5 controls">
                            <input type="text" id="txtnumdebe_<?php echo ($key + 1); ?>" class="soloDecimales" value="">
                        </div>
                    </div>
                    <!-- Cantidad para el Haber -->
                    <div class="span3">
                        <label class="form-label span6">Monto Haber:</label>
                        <div class="span1"></div>
                        <div class="span5 controls">
                            <input type="text" id="txtnumhaber_<?php echo ($key + 1); ?>" class="soloDecimales" value="">
                        </div>
                    </div>
                    <!-- Boton de Agregar -->
                    <div class="span1" style="text-align: left;">
                        <button type="button" id="btnadicionar_<?php echo ($key + 1); ?>" class="btn btn-success btnadicionar">Adicionar</button>
                    </div>
                </div>
            </div>
            <div class="span12">
                <div class="box">
                    <input type="hidden" id="txtflag_editar_<?php echo ($key + 1); ?>" value="0">
                    <table class="responsive table table-bordered" border="0" id="tabla_contiene_<?php echo ($key + 1); ?>" width="100%">
                        <thead>
                            <tr>
                                <th style="width: 20%;">Partida</th>
                                <th style="width: 15%">Cuenta</th>
                                <th style="width: 25%">Nombre de Cuenta</th>
                                <th style="width: 10%">Debe <?= ($simbolo != " ") ? "(" . $simbolo . ")" : ""; ?></th>
                                <th style="width: 10%">Haber <?= ($simbolo != " ") ? "(" . $simbolo . ")" : ""; ?></th>
                                <th style="width: 30%">Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="tbcontenedor_<?php echo ($key + 1); ?>">
                            <?php
                            if (isset($debe[($key)]) && count($debe[($key)]) > 0) {
                                $debe_detalle = $debe[($key)];
                                $correlativo_debe = 0;
                                foreach ($debe_detalle as $fila_debe) {
                                    ?>
                                    <tr>
                                        <td>
                                            <label id="lblcodigo_<?php echo $correlativo_debe . '_' . ($key + 1); ?>"><?php echo $cod; ?></label>
                                            <input type="hidden" name="txt_codigo_<?php echo ($key + 1); ?>[]" id="txt_codigo_<?php echo $correlativo_debe . '_' . ($key + 1); ?>" value="<?php echo $cod; ?>">
                                        </td>
                                        <td>
                                            <label id="lblcuenta_<?php echo $correlativo_debe . '_' . ($key + 1); ?>"><?php echo $fila_debe['cuenta']; ?></label>
                                            <input type="hidden" name="txt_cuenta_<?php echo ($key + 1); ?>[]" id="txt_cuenta_<?php echo $correlativo_debe . '_' . ($key + 1); ?>" value="<?php echo $fila_debe['cuenta']; ?>">
                                            <input type="hidden" name="txt_cnt_id_<?php echo ($key + 1); ?>[]" id="txt_cnt_id_<?php echo ($key + 1); ?>" value="<?php echo $fila_debe['cnt_id']; ?>">
                                        </td>
                                        <td>
                                            <label id="lblnombre_<?php echo $correlativo_debe . '_' . ($key + 1); ?>"><?php echo $fila_debe['cnt_nombre']; ?></label>
                                            <input type="hidden" name="txt_nombre_<?php echo ($key + 1); ?>[]" id="txt_nombre_<?php echo $correlativo_debe . '_' . ($key + 1); ?>" value="<?php echo $fila_debe['cnt_nombre']; ?>">
                                        </td>
                                        <td>
                                            <?php $valid_debe += number_format($fila_debe['total_debe'], 8, '.', ''); ?>
                                            <label id="lbldebe_<?php echo $correlativo_debe . '_' . ($key + 1); ?>">$<?php echo number_format($fila_debe['total_debe'], 2, '.', ','); ?></label>
                                            <input type="hidden" name="txtdebe_<?php echo ($key + 1); ?>[]" id="txtdebe_<?php echo $correlativo_debe . '_' . ($key + 1); ?>" value="<?php echo number_format($fila_debe['total_debe'], 2, '.', ''); ?>">
                                        </td>
                                        <td>
                                            <?php $valid_haber += number_format($fila_debe['total_haber'], 8, '.', ''); ?>
                                            <label id="lblhaber_<?php echo $correlativo_debe . '_' . ($key + 1); ?>">$<?php echo  number_format($fila_debe['total_haber'], 2, '.', ','); ?></label>
                                            <input type="hidden" name="txthaber_<?php echo ($key + 1); ?>[]" id="txthaber_<?php echo $correlativo_debe . '_' . ($key + 1); ?>" value="<?php echo number_format($fila_debe['total_haber'], 2, '.', ''); ?>">
                                        </td>
                                        <td>
                                            <div class="controls center">
                                                <a href="#" title="Borrar" id="eliminar_<?php echo $correlativo_debe . '_' . ($key + 1); ?>" class="tip eliminar_cuenta"><span class="icon12 icomoon-icon-remove"></span></a>
                                                <a href="#" title="Editar" id="editar_<?php echo $correlativo_debe . '_' . ($key + 1); ?>" class="tip editar_cuenta"><span class="icon-edit"></span></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php
                                    $correlativo_debe++;
                                }
                            }

                            if (isset($haber[($key)]) && count($haber[($key)]) > 0) {
                                $haber_detalle = $haber[($key)];
                                $correlativo_haber = 0;
                                foreach ($haber_detalle as $fila_haber) {
                                    ?>
                                    <tr>
                                        <td>
                                            <label id="lblcodigo_<?php echo $correlativo_haber . '_' . ($key + 1); ?>"><?php echo $cod; ?></label>
                                            <input type="hidden" name="txt_codigo_<?php echo ($key + 1); ?>[]" id="txt_codigo_<?php echo $correlativo_haber . '_' . ($key + 1); ?>" value="<?php echo $cod; ?>">
                                        </td>
                                        <td>
                                            <label id="lblcuenta_<?php echo $correlativo_haber . '_' . ($key + 1); ?>"><?php echo $fila_haber['cuenta']; ?></label>
                                            <input type="hidden" name="txt_cuenta_<?php echo ($key + 1); ?>[]" id="txt_cuenta_<?php echo $correlativo_haber . '_' . ($key + 1); ?>" value="<?php echo $fila_haber['cuenta']; ?>">
                                            <input type="hidden" name="txt_cnt_id_<?php echo ($key + 1); ?>[]" id="txt_cnt_id_<?php echo ($key + 1); ?>" value="<?php echo $fila_haber['cnt_id']; ?>">
                                        </td>
                                        <td>
                                            <label id="lblnombre_<?php echo $correlativo_haber . '_' . ($key + 1); ?>"><?php echo $fila_haber['cnt_nombre']; ?></label>
                                            <input type="hidden" name="txt_nombre_<?php echo ($key + 1); ?>[]" id="txt_nombre_<?php echo $correlativo_haber . '_' . ($key + 1); ?>" value="<?php echo $fila_haber['cnt_nombre']; ?>">
                                        </td>
                                        <td>
                                            <?php $valid_debe += number_format($fila_haber['total_debe'], 8, '.', ''); ?>
                                            <label id="lbldebe_<?php echo $correlativo_haber . '_' . ($key + 1); ?>">$<?php echo number_format($fila_haber['total_debe'], 2, '.', ','); ?></label>
                                            <input type="hidden" name="txtdebe_<?php echo ($key + 1); ?>[]" id="txtdebe_<?php echo $correlativo_haber . '_' . ($key + 1); ?>" value="<?php echo number_format($fila_haber['total_debe'], 2, '.', ''); ?>">
                                        </td>
                                        <td>
                                            <?php $valid_haber += number_format($fila_haber['total_haber'], 8, '.', ''); ?>
                                            <label id="lblhaber_<?php echo $correlativo_haber . '_' . ($key + 1); ?>">$<?php echo number_format($fila_haber['total_haber'], 2, '.', ','); ?></label>
                                            <input type="hidden" name="txthaber_<?php echo ($key + 1); ?>[]" id="txthaber_<?php echo $correlativo_haber . '_' . ($key + 1); ?>" value="<?php echo number_format($fila_haber['total_haber'], 2, '.', ''); ?>">
                                        </td>
                                        <td>
                                            <div class="controls center">
                                                <a href="#" title="Borrar" id="eliminar_<?php echo $correlativo_haber . '_' . ($key + 1); ?>" class="tip eliminar_cuenta"><span class="icon12 icomoon-icon-remove"></span></a>
                                                <a href="#" title="Editar" id="editar_<?php echo $correlativo_haber . '_' . ($key + 1); ?>" class="tip editar_cuenta"><span class="icon-edit"></span></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php
                                    $correlativo_haber++;
                                }
                            }
                            ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td>Totales</td>
                                <td></td>
                                <td></td>
                                <td>
                                    <label id="lbldebetotal_<?php echo ($key + 1); ?>"><?php echo '$' . number_format($total_partida, 2, '.', ','); ?></label>
                                    <input type="hidden" name="txtdebetotal[]" id="txtdebetotal_<?php echo ($key + 1); ?>" value="<?php echo number_format($total_partida, 2, '.', ''); ?>">
                                    <input type="hidden" value="<?php echo number_format($valid_debe, 2, '.', ''); ?>" data-ident="<?php echo ($key + 1); ?>" id="valid_debe_<?php echo ($key + 1); ?>">
                                </td>
                                <td>
                                    <label id="lblhabertotal_<?php echo ($key + 1); ?>"><?php echo '$' . number_format($total_partida, 2, '.', ','); ?></label>
                                    <input type="hidden" name="txthabertotal[]" id="txthabertotal_<?php echo ($key + 1); ?>" value="<?php echo number_format($total_partida, 2, '.', ''); ?>">
                                    <input type="hidden" value="<?php echo number_format($valid_haber, 2, '.', ''); ?>" data-ident="<?php echo ($key + 1); ?>" id="valid_haber_<?php echo ($key + 1); ?>">
                                </td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <?php
    }
} //fin de foreach
?>


<script type="text/javascript">
    $(document).ready(function() {
        $('#partidas').dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 10,
            "bLengthChange": false,
            "aaSorting": [],
            "BSort": false,
            "bDestroy": true,
            "bPaginate": false,
            "bInfo": false,
            "bSort": false,
            "bFilter": false,
            "fnInitComplete": function(oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    });
</script>