<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { //Encabezado del Archivo Excel 
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="8">
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
                        <br>Reporte de comparativo de cotizaciones
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>


<?php if ($tipo_reporte == 'excel') { //Encabezado del Archivo Excel 
?>
    <table border="1">
        <tr>
            <td>Requisición No:</td>
            <td style="text-align:left;"><b><?php echo $requisiciones[0]["rxi_numero"]; ?></b></td>
        </tr>
        <tr>
            <td>Fecha:</td>
            <td style="text-align:left;"><?php echo date('d-m-y', strtotime($requisiciones[0]["rxi_fecha"])); ?></td>
        </tr>
        <tr>
            <td>Solicitado por:</td>
            <td style="text-align:left;"><?php echo $requisiciones[0]["username"]; ?></td>
        </tr>
        <tr>
            <td>Justificación:</td>
            <td style="text-align:left;"><?php echo $requisiciones[0]["rxi_justificacion"]; ?></td>
        </tr>
        <tr>
            <td>P.P. / Rubro:</td>
            <td style="text-align:left;"><?php echo $requisiciones[0]["ace_nombre"]; ?></td>
        </tr>
    </table>
    <br>
<?php } ?>

<table class="table table-bordered contenedor" border="1">
    <thead>
        <tr>
            <th colspan="5" style="text-align:center;">DETALLES</th>
            <?php
            $th = '';
            foreach ($cotizaciones as $cotizacion) {
                $th .= '<th colspan="2">' . strtoupper($cotizacion["prv_nombre"]);
                $th .= '</th>';
            }
            echo $th;
            ?>
        </tr>
        <?php
        $th2 = '';
        if (count($cotizaciones) > 0) {
            $th2 .= '<tr>';
            $th2 .= '<th>ITEM</th>';
            $th2 .= '<th>PRUDUCTO/SERVICIO</th>';
            $th2 .= '<th>DESCRIPCIÓN</th>';
            $th2 .= '<th>CANTIDAD SOLICITADA</th>';
            $th2 .= '<th>U.M.</th>';
            foreach ($cotizaciones as $cotizacion) {
                $th2    .= '<th>PRECIO</th>';
                $th2    .= '<th>SELECCIÓN</th>';
            }
            $th2 .= '</tr>';
        }
        echo $th2;
        ?>
    </thead>
    <tbody>
        <?php
        $tbody              = "";
        $total_cantidades   = 0;
        $contador           = 0;
        $columna_clave      = array_column($destalles_cotizaciones, 'clave');
        $global_sub_total          = array();
        $global_descuentos         = array();
        $global_impuestos          = array();
        $global_totales            = array();
        $total_final               = 0;

        //iniciando variables totales
        foreach ($cotizaciones as $key => $cotizacion) {
            $global_sub_total[$key]    = 0;
            $global_descuentos[$key]   = 0;
            $global_impuestos[$key]    = 0;
            $global_totales[$key]      = 0;
        }

        if (count($requisiciones) > 0) {
            foreach ($requisiciones as $requisicion) {
                $contador++;
                $cantidad           = $requisicion["dri_cantidad"];
                $total_cantidades  += $cantidad;
                $tbody .= '<tr class="fila">';
                $tbody .= '<td>' . $contador . '</td>';
                $tbody .= '<td>' . $requisicion["art_nombre"] . '</td>';
                $tbody .= '<td>' . $requisicion["art_descripcion"] . '</td>';
                $tbody .= '<td>' . number_format($cantidad, $decimales, ".", ",") . '</td>';
                $tbody .= '<td>' . $requisicion["mep_nombre"] . '</td>';

                //inicializar varaibles totales
                foreach ($cotizaciones as $key => $cotizacion) {
                    $clave      = $requisicion["art_id"] . "-" . $cotizacion["prv_id"];
                    $posicion   = array_search($clave, $columna_clave);

                    if ($posicion !== false) {
                        $precio_unitario        = $destalles_cotizaciones[$posicion]["dco_precio_unitario"];
                        $detalle_cotizacion     = $destalles_cotizaciones[$posicion]["dco_id"];
                        $total_detalle          = $destalles_cotizaciones[$posicion]["dco_total"];
                        $descuento_porcentaje   = $destalles_cotizaciones[$posicion]["dco_descuento"];
                        $descuento              = (($precio_unitario * $cantidad) * $descuento_porcentaje) / 100;
                        $impuesto               = $destalles_cotizaciones[$posicion]["dco_impuesto"];
                        $checked                = "";

                        if (isset($destalles_cotizaciones[$posicion]["dpm_id_dco"])) {
                            $checked            = ($destalles_cotizaciones[$posicion]["dpm_id_dco"] != "") ? 'x' : '';
                            $global_sub_total[$key]    += ($precio_unitario * $cantidad);
                            $global_descuentos[$key]   += $descuento;
                            $global_impuestos[$key]    += $impuesto;
                            $global_totales[$key]      += $total_detalle;
                            $total_final               += $total_detalle;
                        }

                        $tbody     .= '<td style="text-align:left;">' . $simbolo;
                        $tbody     .= number_format($precio_unitario, $decimales, ".", ",");
                        $tbody     .= '</td>';
                        $tbody     .= '<td style="text-align:center;">' . $checked . '</td>';
                    } else {
                        $tbody     .= '<td style="text-align:left;">' . $simbolo . '0</td>';
                        $tbody     .= '<td style="text-align:center;"></td>';
                    }
                }
                $tbody .= '</tr>';
            }
        } else {
            $tbody = '<tr><td colsppan="3">No se encontraron resultados</td></tr>';
        }
        echo $tbody;
        ?>
    </tbody>
    <tfoot class="foot">
        <tr>
            <td colspan="5"><b>Sub Total</b></td>
            <?php
            $td_foot    = '';
            foreach ($cotizaciones as $key => $cotizacion) {
                $prv_id     = $cotizacion["prv_id"];
                $td_foot   .= '<td colspan = "2" style="text-align:left;" id="sub_input_proveedor_' . $prv_id . '" class="sub_totales">$' . number_format($global_sub_total[$key], $decimales, ".", ",") . '</td>';
            }
            echo $td_foot;
            ?>
        </tr>
        <tr>
            <td colspan="5"><b>Descuentos</b></td>
            <?php
            $td_foot    = '';
            foreach ($cotizaciones as $key => $cotizacion) {
                $prv_id     = $cotizacion["prv_id"];
                $td_foot   .= '<td colspan = "2" style="text-align:left;" id="des_input_proveedor_' . $prv_id . '" class="decuentos">$' . number_format($global_descuentos[$key], $decimales, ".", ",") . '</td>';
            }
            echo $td_foot;
            ?>
        </tr>
        <tr>
            <td colspan="5"><b>Impuestos</b></td>

            <?php
            $td_foot    = '';
            foreach ($cotizaciones as $key => $cotizacion) {
                $prv_id     = $cotizacion["prv_id"];
                $td_foot   .= '<td colspan = "2" style="text-align:left;" id="imp_nput_proveedor_' . $prv_id . '" class="impuestos">$' . number_format($global_impuestos[$key], $decimales, ".", ",") . '</td>';
            }
            echo $td_foot;
            ?>
        </tr>
        <tr>
            <td colspan="5"><b>Totales</b></td>
            <?php
            $td_foot    = '';
            foreach ($cotizaciones as $key => $cotizacion) {
                $prv_id     = $cotizacion["prv_id"];
                $td_foot   .= '<td colspan = "2" style="text-align:left;" id="input_proveedor_' . $prv_id . '" class="totales">$' . number_format($global_totales[$key], $decimales, ".", ",") . '</td>';
            }
            echo $td_foot;
            ?>
        </tr>
    </tfoot>
</table>

<?php if ($tipo_reporte == 'excel') { //Encabezado del Archivo Excel 
?>
    <table>
        <tr>
            <td colspan="2"></td>
        </tr>
        <tr>
            <td>
                <table class="table table-bordered contenedor" border="1">
                    <thead>
                        <tr>
                            <th colspan="3">DETALLES DE PROVEEDORES</th>
                        </tr>
                        <tr>
                            <th>Proveedores</th>
                            <th>Entrega</th>
                            <th>Condiciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $tbody = "";
                        if (count($cotizaciones) > 0) {
                            foreach ($cotizaciones as $cotizacion) {
                                $tbody .= '<tr>';
                                $tbody .= '<td>' . $cotizacion["prv_nombre"] . '</td>';
                                $tbody .= '<td>' . $cotizacion["coc_entrega"] . '</td>';
                                $tbody .= '<td>' . $cotizacion["coc_codiciones_entrega"] . '</td>';
                                $tbody .= '</tr>';
                            }
                        } else {
                            $tbody = '<tr><td colsppan="3">No se encontraron resultados</td></tr>';
                        }
                        echo $tbody;
                        ?>
                    </tbody>
                </table>

            </td>
            <td></td>
            <td>

                <table border="1">
                    <tr>
                        <td colspan="5"><b>OBSERVACIONES</b></td>
                    </tr>
                    <tr>
                        <td colspan="5" rowspan="3" valign="top"><?php echo $ultimo_comentario; ?></td>
                    </tr>
                </table>

            </td>
        </tr>
    </table>

    <table class="table table-bordered contenedor">
        <tbody>
            <tr>
                <td colspan="2"></td>
            </tr>
            <tr>
                <td><b>Total global:</b></td>
                <td><b>$<?php echo number_format($total_final, $decimales, ".", ","); ?></b></td>
            </tr>
            <tr>
                <td><b>Disponible del plan de compra:</b></td>
                <td><b>$<?php echo number_format($disponible_mensual, $decimales, ".", ","); ?></b></td>
            </tr>
        </tbody>
    </table>
    <br>
    <br>
<?php
    echo $firmas;
}
?>