<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Retaceo Consolidado
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
if ($tipo_reporte != '') {
    $dpv_numbers = implode(',', array_column($documentos, 'dpv_numero_documento'));
    $iva_docs = array_sum(array_column($documentos, 'dpv_impuesto'));
?>
    <table border="0">
        <tr>
            <td colspan="6"></td>
        </tr>
        <tr>
            <td style="width: 11%; text-align: left;"><b>No. Retaceo:</b></td>
            <td style="text-align: left;"><?php echo $numeroRetaceo; ?></td>
            <td colspan="4" style="width: 60%;"></td>
        </tr>
        <tr>
            <td style="width: 11%; text-align: left;"><b>Fecha Retaceo:</b></td>
            <td style="text-align: left;width: 29%;"><?php echo date('d-m-Y', strtotime($reporte[0]['rtd_fecha_registro'])); ?></td>
            <td colspan="4" style="width: 60%;"></td>
        </tr>
        <tr>
            <td style="width: 11%; text-align: left;"><b>Proveedor:</b></td>
            <td style="text-align: left; width: 29%;"><?php echo $nombreProveedor; ?></td>
            <td style="width: 5%;"></td>
            <td style="width: 15%;"><b>IVA:</b> <?php echo $simbolo . number_format($iva_docs, 2); ?></td>
            <td style="width: 5%;"></td>
            <td style="width: 35%;"><b>Documentos:</b> <?php echo $dpv_numbers; ?></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th><b>Código</b></th>
                <th><b>Producto</b></th>
                <th><b>Descripción</b></th>
                <th><b>UM</b></th>
                <th><b>Cantidad</b></th>
                <th><b>Precio(<?= $simbolo ?>)</b></th>
                <th><b>Subtotal(<?= $simbolo ?>)</b></th>
                <th>Retaceo(%)</th>
                <th>Retaceo(Peso)</th>
                <th>Retaceo(<?= $simbolo ?>)</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>


        <?php
        $i = 1;
        $subtotal = 0;
        $retaceo_porcentual = 0;
        $retaceo_peso = 0;
        $retaceo = 0;
        foreach ($reporte as $row) :
        ?>
            <tr class="dato">
                <td><?php echo $row['art_codigo']; ?></td>
                <td><?php echo $row['art_nombre']; ?></td>
                <td><?php echo $row['art_descripcion']; ?></td>
                <td><?php echo $row['mep_nombre']; ?></td>
                <td><?php echo number_format($row['drc_cantidad'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['drc_precio_unitario'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['drc_subtotal'], 2); ?></td>
                <td><?php echo number_format($row['drc_retaceo_porcentaje'], 2); ?>%</td>
                <td><?php echo number_format($row['drc_retaceo_peso'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['drc_retaceo'], 2); ?></td>
            </tr>
        <?php
            $i++;
            $subtotal = $subtotal + $row['drc_subtotal'];
            $retaceo_porcentual = $retaceo_porcentual + number_format($row['drc_retaceo_porcentaje'], 2, '.', '');
            $retaceo = $retaceo + number_format($row['drc_retaceo'], 2, '.', '');
            $retaceo_peso = $retaceo_peso + number_format($row['drc_retaceo_peso'], 2, '.', '');
        endforeach;
        ?>

        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
        ?>
        <tfoot>
            <tr>
                <td colspan="5"></td>
                <td>Total:</td>
                <td><?php echo $simbolo . number_format($subtotal, 2); ?></td>
                <td><?php echo number_format($retaceo_porcentual, 2); ?>%</td>
                <td><?php echo number_format($retaceo_peso, 2); ?></td>
                <td><?php echo $simbolo . number_format($retaceo, 2); ?></td>
            </tr>
        </tfoot>
        </tbody>
    </table><br><br>
    <br><?php
            $total_gastos = 0;
        ?><table border="1" width="45%">
        <thead>
            <tr>
                <th style="font-weight: bold;">Gastos</th>
                <th style="font-weight: bold;">Monto</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($gastos as $key => $value) : ?>
                <?php $total_gastos += number_format($value['grc_monto'], 2); ?>
                <tr>
                    <td><?php echo $value['gst_nombre']; ?></td>
                    <td style="text-align: right;"><?php echo $simbolo .  number_format($value['grc_monto'], 2); ?></td>
                </tr>
            <?php endforeach ?>
        </tbody>
        <tfoot>
            <tr>
                <th style="font-weight: bold;">Total</th>
                <th style="text-align: right;font-weight: bold;"><?php echo $simbolo . number_format($total_gastos, 2); ?></th>
            </tr>
        </tfoot>
    </table><br>
    <br>
    <br>
    <table border="1" width="49%">
        <thead>
            <tr>
                <th colspan="4"><b>Resumen</b></th>
            </tr>
            <tr>
                <th><b>Código</b></th>
                <th><b>Costo de la mercadería</b></th>
                <th><b>Cantidad</b></th>
                <th><b>Costo por Unidad</b></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($reporte as $key => $value) : ?>
                <?php
                $unitario = (number_format($value['rtd_retaceo'], 2, '.', '') / number_format($value['drc_cantidad'], 2, '.', ''));
                ?>
                <tr>
                    <td><?php echo $value['art_codigo'] ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($value['rtd_retaceo'], 2); ?></td>
                    <td style="text-align: right;"><?php echo number_format($value['drc_cantidad'], 2); ?></td>
                    <td style="text-align: right;"><?php echo $simbolo . number_format($unitario, 2); ?></td>
                </tr>
            <?php endforeach ?>
        </tbody>
    </table>
    <br><br><br><br>
    <br><br><br><br>
    <table>
        <tr>
            <td style="width:50px;"></td>
            <td style="width:150px;font-weight: bold;text-align: center;border-bottom:1px solid #000000;">
                <!-- Usuario que aprobo -->
                <?php
                if ($mostrar_usuario > 0) {
                    echo (trim($crea_usuario_retaceo) != "") ? $crea_usuario_retaceo : '';
                }
                ?>
            </td>
            <td></td>
            <td style="width:150px;font-weight: bold;">_______________________________</td>
            <td style="width:50px;"></td>
            <td></td>
        </tr>

        <tr>
            <td style="width:50px;"></td>
            <td style="text-align: center;width:150px;font-weight: bold;">Realizado</td>
            <td></td>
            <td style="text-align: center;width:150px;font-weight: bold;">Autorizado</td>
            <td style="width:50px;"></td>
            <td>Sello</td>
        </tr>
    </table>
<?php } ?>