<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Retaceo
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
?>

    <table class="">
        <tr>
            <td colspan="2"></td>
        </tr>
        <tr>
            <td style="width: 11%; text-align: left;"><b>No. Retaceo:</b></td>
            <td style="text-align: left;"><?php echo $numeroRetaceo; ?></td>
        </tr>
        <tr>
            <td style="width: 11%; text-align: left;"><b>Fecha Retaceo:</b></td>
            <td style="text-align: left;"><?php echo date('d-m-Y', strtotime($reporte[0]['rtd_fecha_registro'])); ?></td>
        </tr>
        <tr>
            <td style="width: 11%; text-align: left;"><b>Proveedor:</b></td>
            <td style="text-align: left;"><?php echo $nombreProveedor; ?></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th><b>Proveedor</b></th>
                <th><b>Documento Proveedor</b></th>
                <th><b>Fecha Retaceo</b></th>
                <th><b>Codigo Retaceo</b></th>
                <th><b>Código Producto</b></th>
                <th><b>Producto</b></th>
                <th><b>UM</b></th>
                <th><b>Cantidad</b></th>
                <th><b>Precio(<?= $simbolo ?>)</b></th>
                <th><b>Subtotal(<?= $simbolo ?>)</b></th>
                <th><b>Retaceo(%)</b></th>
                <th><b>Retaceo(<?= $simbolo ?>)</b></th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>


        <?php
        $i = 1;
        $subtotal = 0;
        $retaceo_porcentual = 0;
        $retaceo = 0;
        foreach ($reporte as $row) :
        ?>
            <tr class="dato">
                <td><?php echo $row['prv_nombre']; ?></td>
                <td><?php echo $row['dpv_numero_documento']; ?></td>
                <td><?php echo date('Y-m-d', strtotime($row['rtd_fecha_registro'])); ?></td>
                <td><?php echo $row['rtd_numero']; ?></td>
                <td><?php echo $row['art_codigo']; ?></td>
                <td><?php echo $row['art_nombre']; ?></td>
                <td><?php echo $row['mep_nombre']; ?></td>
                <td><?php echo number_format($row['drc_cantidad'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['drc_precio_unitario'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['drc_subtotal'], 2); ?></td>
                <td><?php echo number_format($row['drc_retaceo_porcentaje'], 2); ?>%</td>
                <td><?php echo $simbolo . number_format($row['drc_retaceo'], 2); ?></td>
            </tr>
        <?php
            $i++;
            $subtotal = $subtotal + $row['drc_subtotal'];
            $retaceo_porcentual = $retaceo_porcentual + $row['drc_retaceo_porcentaje'];
            $retaceo = $retaceo + $row['drc_retaceo'];
        endforeach;
        ?>

        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
        ?>
        <tfoot>
            <tr>
                <td colspan="8"></td>
                <td>Total:</td>
                <td><?php echo $simbolo . number_format($subtotal, 2); ?></td>
                <td><?php echo number_format($retaceo_porcentual, 2); ?>%</td>
                <td><?php echo $simbolo . number_format($retaceo, 2); ?></td>
            </tr>
        </tfoot>
        </tbody>
    </table>
    <br><br><br><br>
    <br><br><br><br>

    <table>
        <tr>
            <td style="width:50px;"></td>
            <td style="width:150px;font-weight: bold;text-align: center;border-bottom:1px solid #000000;">
                <!-- Usuario que aprobo -->
                <?php
                if ($mostrar_usuario > 0) {
                    echo (trim($crea_usuario_retaceo) != "") ? $crea_usuario_retaceo : '';
                }
                ?>
            </td>
            <td></td>
            <td style="width:150px;font-weight: bold;">_______________________________</td>
            <td style="width:50px;"></td>
            <td></td>
        </tr>

        <tr>
            <td style="width:50px;"></td>
            <td style="text-align: center;width:150px;font-weight: bold;">Realizado</td>
            <td></td>
            <td style="text-align: center;width:150px;font-weight: bold;">Autorizado</td>
            <td style="width:50px;"></td>
            <td>Sello</td>
        </tr>
    </table>
<?php } ?>