<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de requisiciones
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {

    if ($fecha_inicio != '') {
        $periodo = $fecha_inicio . " al " . $fecha_fin;
    }
    ?>

    <table class="">
        <tr><td colspan="3"></td></tr>
        <tr>
            <td style="width: 12%; text-align: left;"><b>Departamento:</b></td>
            <td style="text-align: left;"><?php echo $nombreDepartamento; ?></td>
            <td style="width: 10%; text-align: left;"><b>Período:</b></td>
            <td style="text-align: left;"><?php echo $periodo; ?></td>
        </tr>
        <tr>
            <td style="width: 12%; text-align: left;"><b>Estado:</b></td>
            <td style="text-align: left;"><?php echo $nombreEstado; ?></td>
            <td style="width: 10%; text-align: left;"><b>Sucursal:</b></td>
            <td style="text-align: left;"><?php echo $nombreSucursal; ?></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th>Fecha</th>
                <th>No. Req.</th>
                <th>Sucursal</th>
                <th>Departamento</th>
                <th>Solicitante</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i = 1;
        foreach ($reporte as $row):

            $estado_orden = "";
            switch ($row['rxi_estado']) {
                case 1:
                    $estado_orden = "Creada";
                    break;
                case 2 :
                    $estado_orden = "Pendiente de autorización";
                    break;

                case 3 :
                    $estado_orden = "Autorizada";
                    break;

                case 4 :
                    $estado_orden = "Rechazada";
                    break;

                case 5 :
                    $estado_orden = "Anulada";
                    break;
                case 6 :
                    $estado_orden = "Parciales";
                    break;
                case 0:
                    $estado_orden = "Despachada";
                    break;
            }
            ?>
            <tr>
                <td><?php echo date('d-m-Y', strtotime($row['rxi_fecha'])); ?></td>
                <td><?php echo $row['rxi_numero']; ?></td>
                <td><?php echo $row['suc_nombre']; ?></td>
                <td><?php echo $row['are_nombre']; ?></td>
                <td><?php echo $row['emp_nombre'] . " " . $row['emp_apellido']; ?></td>
                <td><?php echo $estado_orden; ?></td>
            </tr>
            <?php
            $i++;
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
            ?>
        </tbody> 
    </table>
<?php } ?>