<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                       Reporte de productos más comprados
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
        
        if($fecha_inicio!=''){
            $periodo = $fecha_inicio." al ".$fecha_fin;
        }
    ?>
    
    <table class="">
        <tr><td colspan="3"></td></tr>
        <tr>
            <td style="width: 20%; text-align: left;"><b>Período:</b></td>
            <td style="text-align: left;"><?php echo $periodo; ?></td>
            <td style="width: 12%; text-align: left;"><b>Categoría:</b></td>
            <td style="text-align: left;"><?php echo $nombreCategoria;?></td>
        </tr>
        <tr>
            <td style="width: 20%; text-align: left;"><b>N° productos a mostrar:</b></td>
            <td style="text-align: left;"><?php echo $cantidad;?></td>
            <td style="width: 12%; text-align: left;"></td>
            <td style="text-align: left;"></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th>#</th>
                <th>Código</th>
                <th>Producto</th>
                <th>Categoría</th>
                <th>Cant. comprada</th>
                <th>UM</th>
                <th>Última fecha de compra</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i = 1;
        foreach ($reporte as $row):
        ?>
            <tr class="dato">
                <td><?php echo $i; ?></td>
                <td><?php echo $row['art_codigo']; ?></td>
                <td><?php echo $row['art_nombre']; ?></td>
                <td><?php echo $row['tia_codigo'].' - '.$row['tia_nombre']; ?></td>
                <td><?php echo number_format($row['cantidad'], $this->gsatelite->get_parametro('NUMERO_DECIMALES'), '.', ','); ?></td>
                <td><?php echo $row['mep_nombre']; ?></td>
                <td><?php echo formatear_fecha('d-m-Y', $row['ultima_fecha']); ?></td>
            </tr>
            <?php
            $i++;
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
            ?>
        </tbody> 
    </table>
<?php } ?>

