<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            width: 50% !important;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Órdenes de Compra
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla


if ($fecha_inicio != '') {
    $periodo = $fecha_inicio . " al " . $fecha_fin;
}
$i = 1;
$registros = 1;
$subTotal = 0;
$impuestos = 0;
$descuentos = 0;
$otros = 0;
$total = 0;
foreach ($reporte as $row) :
    $estado_orden = "";
    switch ($row['orc_estado']) {
        case 0:
            $estado_orden = "Despachada";
            break;
        case 1:
            $estado_orden = "Creada";
            break;
        case 2:
            $estado_orden = "Pendiente de autorización";
            break;

        case 3:
            $estado_orden = "Autorizada";
            break;

        case 4:
            $estado_orden = "Rechazada";
            break;

        case 5:
            $estado_orden = "Anulada";
            break;
        case 6:
            $estado_orden = "Procesada";
            break;
    }
    if ($tipo_reporte != '') {
        if ($registros == 1) {
?>

            <table class="">
                <tr>
                    <td colspan="3"></td>
                </tr>
                <tr>
                    <td style="width: 10%;"><b>Período:</b></td>
                    <td style="text-align: left;"><?php echo $periodo; ?></td>
                    <td style="width: 12%;"><b>Departamento:</b></td>
                    <td style="text-align: left;"><?php echo $nombreDepartamento; ?></td>
                </tr>
                <tr>
                    <td style="width: 10%;"><b>Estado:</b></td>
                    <td style="text-align: left;"><?php echo $nombreEstado; ?></td>
                    <td style="width: 12%;"><b>Proveedor:</b></td>
                    <td style="text-align: left;"><?php echo $nombreProveedor; ?></td>
                </tr>
            </table>
            <div></div>
        <?php } ?>

        <?php if ($i == 1) { ?>
            <table class="tabla">
                <thead>
                    <tr>
                        <th style="width: 10%;">Fecha</th>
                        <th style="width: 5%;">Num.</th>
                        <!--<th>Proyecto</th>-->
                        <th style="width: 8%;">Prioridad</th>
                        <th>Proveedor</th>
                        <!--<th>Sucursal</th>-->
                        <th style="width: 10%;">Departamento</th>
                        <th>Solicitante</th>
                        <th>Estado</th>
                        <th>Sub-Total</th>
                        <th>Impuestos</th>
                        <th>Descuentos</th>
                        <th>Otros Gastos</th>
                        <th>Total</th>

                    </tr>
                </thead>
                <tbody>
            <?php
        }
    }
            ?>
            <?php
            $subTotal += $row['orc_subtotal'];
            $impuestos += $row['orc_impuesto'];
            $descuentos += $row['orc_descuento'];
            //  $otros += (isset($row['orc_otros_gastos'])?$row['orc_otros_gastos']:0.00;
            $total  += $row['orc_total'];

            ?>
            <tr <?php if ($row['prd_atencion'] == 1) {
                    echo 'style="background-color:#F2A1A1"';
                } ?>>
                <td style="width: 10%;"><?php echo date('d-m-Y', strtotime($row['orc_fecha_orden'])); ?></td>
                <td style="width: 5%;"><?php echo $row['orc_numero']; ?></td>
                <!--<td><?php ?></td>-->
                <td style="width: 8%;"><?php echo $row['prd_nombre']; ?></td>
                <td><?php if ($row['prv_tipo_pers'] == 1) {
                        echo $row['prv_nombre'] . ' ' . $row['prv_apellido'];
                    } else {
                        echo $row['prv_apellido'];
                    } ?></td>
                <!--<td><?php ?></td>-->
                <td style="width: 10%;"><?php echo $row['are_nombre']; ?></td>
                <td><?php echo $row['emp_nombre'] . " " . $row['emp_apellido']; ?></td>
                <td><?php echo $estado_orden; ?></td>
                <td><?php echo $simbolo . number_format($row['orc_subtotal'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['orc_impuesto'], 2); ?></td>
                <td><?php echo $simbolo . number_format($row['orc_descuento'], 2); ?></td>
                <td><?php if (isset($row['orc_otros_gastos'])) {
                        echo $simbolo . number_format($row['orc_otros_gastos'], 2);
                    } else {
                        echo $simbolo . '0.00';
                    } ?></td>
                <td><?php echo $simbolo . number_format($row['orc_total'], 2); ?></td>


            </tr>
            <?php
            $i++;
            ?>
            <?php

            //Si la variable tipo reporte existe se declara la tabla
            if ($tipo_reporte != '') {
                if ($i == 21) {
            ?>
                </tbody>
            </table>
            <br style="page-break-after: always;" />
        <?php
                    $i = 1;
                } else if ($registros == count($reporte)) {
        ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="7" style="text-align:center">Totales</td>
                    <td><?php echo $simbolo . number_format($subTotal, 2); ?></td>
                    <td><?php echo $simbolo . number_format($impuestos, 2); ?></td>
                    <td><?php echo $simbolo . number_format($descuentos, 2); ?></td>
                    <td><?php echo $simbolo . number_format($otros, 2); ?></td>
                    <td><?php echo $simbolo . number_format($total, 2); ?></td>
                </tr>
            </tfoot>
            </table>

            <br><br><br><br>
            <br><br><br><br>

            <table>
                <tr>
                    <td style="width:50px;"></td>
                    <td style="width:150px;font-weight: bold;">_______________________________</td>
                    <td></td>
                    <td style="width:150px;font-weight: bold;">_______________________________</td>
                    <td style="width:50px;"></td>
                    <td></td>
                </tr>
                <tr>
                    <td style="width:50px;"></td>
                    <td style="text-align: center;width:150px;font-weight: bold;">Realizada</td>
                    <td></td>
                    <td style="text-align: center;width:150px;font-weight: bold;">Autorizada</td>
                    <td style="width:50px;"></td>
                    <td>Sello</td>
                </tr>
            </table>
<?php
                }
            }
            $registros++;
        endforeach;
?>