<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Documentos por Proveedor
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {

    if ($fecha_inicio != '') {
        $periodo = $fecha_inicio . " al " . $fecha_fin;
    }
?>

    <table class="">
        <tr>
            <td colspan="5"></td>
        </tr>
        <tr>
            <td style="width: 10%;"><b>Período:</b></td>
            <td style="text-align: left;"><?php echo $periodo; ?></td>
            <td style="width: 12%;"><b>Proveedor:</b></td>
            <td style="text-align: left;"><?php echo $nombreProveedor; ?></td>
            <td style="width: 12%;"><b>Tipo Pago:</b></td>
            <td style="text-align: left;"><?php echo $nombretipopago; ?></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th>Proveedor</th>
                <th>No. Orden</th>
                <th>Tipo Doc.</th>
                <th>Tipo Pago.</th>
                <th>No. Doc</th>
                <th style="width: 10%;">Fecha Doc.</th>
                <th>Concepto</th>
                <th>Monto</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i = 1;
        $total_global = 0.00;
        foreach ($reporte as $row) :

            if ($row['dpv_pagado'] == 1) {
                $estado = 'Pagado';
            } elseif ($row['dpv_monto_abono'] == 0) {
                $estado = 'Pendiente';
            }
        ?>
            <tr>
                <td><?php if ($row['prv_tipo_pers'] == 1) {
                        echo $row['prv_nombre'] . ' ' . $row['prv_apellido'];
                    } else {
                        echo $row['prv_apellido'];
                    } ?></td>
                <td><?php echo $row['orc_numero']; ?></td>
                <td><?php echo $row['tif_nombre']; ?></td>
                <td><?php echo $row['tpg_nombre']; ?></td>
                <td><?php echo $row['dpv_numero_documento']; ?></td>
                <td style="width: 10%;"><?php echo date('d-m-Y', strtotime($row['dpv_fecha_documento'])); ?></td>
                <td><?php echo $row['dpv_concepto']; ?></td>
                <td><?php echo $simbolo . number_format($row['dpv_total'], 2); ?></td>
                <td><?php echo $estado ?></td>
            </tr>
        <?php
            $total_global = $total_global + $row['dpv_total'];
            $i++;
        endforeach;
        ?>
        <?php if ($tipo_reporte == 'pdf' || $tipo_reporte == 'excel') : ?>
            <tr>
                <td colspan="6"></td>
                <td style="text-align: center"><strong>Total</strong></td>
                <td><?php echo $simbolo . number_format($total_global, 2); ?></td>
                <td></td>
            </tr>
        <?php else : ?>
            <tr>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td style="text-align: center"><strong>Total</strong></td>
                <td><strong><?php echo $simbolo . number_format($total_global, 2); ?></strong></td>
                <td></td>
            </tr>
        <?php endif; ?>

        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
        ?>
        </tbody>
    </table>
<?php } ?>