<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte Resumen Orden de Compra proveedor
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {

    if ($fecha_inicio != '') {
        $periodo = $fecha_inicio . " al " . $fecha_fin;
    }
?>

    <table class="">
        <tr>
            <td colspan="2"></td>
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Período:</b></td>
            <td style="text-align: left;"><?php echo $periodo; ?></td>
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Proveedor:</b></td>
            <td style="text-align: left;"><?php echo $nombreProveedor; ?></td>
        </tr>
    </table>
    <div></div>

    <table class="tabla">
        <thead>
            <tr>
                <th>No. Orden</th>
                <th>Proveedor</th>
                <th>F. documento</th>
                <th>Monto</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php $i = 1;
        foreach ($reporte as $row) : ?>
            <tr class="dato">
                <td><?php echo $row['numero']; ?></td>
                <td><?php if ($row['prv_tipo_pers'] == 1) {
                        echo $row['prv_nombre'] . ' ' . $row['prv_apellido'];
                    } else {
                        echo $row['prv_apellido'];
                    } ?></td>
                <td><?php echo date('d-m-Y', strtotime($row['fecha_orden'])); ?></td>
                <td><?php echo $simbolo . number_format($row['total'], 2); ?></td>
            </tr>
        <?php
            $i++;
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
        ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="2"></td>
                <td>Total:</td>
                <td><?php echo $simbolo . number_format(round($total, 2), 2); ?></td>
            </tr>
        </tfoot>
    </table>
<?php } ?>