<?php
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Compras por producto
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
    if ($fecha_inicio != '') {
        $periodo = $fecha_inicio . " al " . $fecha_fin;
    }
?>
    <table class="">
        <tr>
            <td colspan="3"></td>
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Período:</b></td>
            <td style="text-align: left;"><?php echo $periodo; ?></td>
            <td style="width: 12%; text-align: left;"><b>Categoría:</b></td>
            <td style="text-align: left;"><?php echo $nombreCategoria; ?></td>
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Producto:</b></td>
            <td style="text-align: left;"><?php echo $nombreProducto; ?></td>
            <td style="width: 12%; text-align: left;"></td>
            <td style="text-align: left;"></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr style="font-weight: bold;">
                <th width="4%">No.</th>
                <th width="9%">Fecha doc.</th>
                <th width="15%">Producto</th>
                <th width="15%">Proveedor</th>
                <th width="9%">UM</th>
                <th width="8%">Cantidad</th>
                <th width="10%">Precio</th>
                <th width="10%">Sub-Total</th>
                <th width="10%">Impuestos</th>
                <th width="10%">Total</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i = 1;
        foreach ($reporte as $row) :
        ?>
            <tr class="dato">
                <td width="4%"><?php echo $row['dpv_numero_documento']; ?></td>
                <td width="9%"><?php echo date('d-m-Y', strtotime($row['dpv_fecha_documento'])); ?></td>
                <td width="15%"><?php echo $row['art_codigo'] . ' - ' .  $row['art_nombre']; ?></td>
                <td width="15%"><?php echo ($row['prv_tipo_pers'] == 1) ? $row['prv_nombre'] . ' ' . $row['prv_apellido'] : $row['prv_apellido']; ?></td>
                <td width="9%"><?php echo $row['mep_nombre']; ?></td>
                <td width="8%"><?php echo round($row['dxd_cantidad'], 2); ?></td>
                <td width="10%" style="text-align: right;"><?php echo $simbolo . number_format($row['dxd_precio_unitario'], 2); ?></td>
                <td width="10%" style="text-align: right;"><?php echo $simbolo . number_format($row['dxd_subtotal'], 2); ?></td>
                <td width="10%" style="text-align: right;"><?php echo $simbolo . number_format($row['dxd_impuesto'], 2); ?></td>
                <td width="10%" style="text-align: right;"><?php echo $simbolo . number_format($row['dxd_total'], 2); ?></td>
            </tr>
        <?php
            $i++;
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
        ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="9" width="90%" style="text-align: right; font-weight: bold;">Total:</td>
                <td width="10%" style="text-align: right;font-weight: bold;" id="total"><?php echo $simbolo . number_format(round($suma[0]['dxd_total'], 2), 2); ?></td>
            </tr>
        </tfoot>
    </table>
<?php } ?>