<?php
if($tipo_reporte == 'excel'){
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if($tipo_reporte != 'grid'){
    $p = ($tipo_reporte == 'pdf') ? true : false;
    ?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }
        th {
            font-weight: bold !important;
        }
        td {
            font-family: arial;
        }
        .fuente_titulo{
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <?php if ($tipo_reporte == 'excel'){
        ?>
        <table>
            <thead>
                <tr>
                    <th colspan="5">REPORTE DE LIQUIDACION DE CAJA CHICA</th>
                    <th></th>
                    <th colspan="3" style="border-bottom:1px">ARQUEO</th>
                </tr>
                <tr>
                    <th>Caja:</th>
                    <td><?php echo $nombre_caja; ?></td>
                    <td colspan="4"></td>
                    <td style="text-align:center">Fecha:</td>
                    <td style="text-align:center">Hora Inicio:</td>
                    <td style="text-align:center">Hora Fin:</td>
                </tr>
                <tr>
                    <th>Periodo:</th>
                    <td><?php echo $fecha_ini. ' a '.$fecha_fin;?></td>
                    <td colspan="4"></td>
                    <td><?php echo  date("d-m-Y H:i:s"); ?></td>
                    <td>_______________</td>
                    <td style="border:1px #000000 !important">_______________</td>
                </tr>
                <tr>
                    <th><b>Reintegro(s):</b></th><td>$<?= number_format($suma_reintego,2); ?></td><td colspan="7"></td>
                </tr>
                <tr>
                    <td colspan="9"></td>
                </tr>
            </thead>
        </table>
        <?php
    }
    if ($tipo_reporte == 'pdf'){
        ?>
        <table border="0">
            <thead>
                <tr>
                    <th colspan="5"></th>
                    <th></th>
                    <th colspan="3" style="text-align:center;border:1px #000000 !important">ARQUEO</th>
                </tr>
                <tr>
                    <th>Caja:</th>
                    <td><?php echo $nombre_caja; ?></td>
                    <td colspan="4"></td>
                    <td style="text-align:center;border:1px #000000 !important;">Fecha:</td>
                    <td style="text-align:center;border:1px #000000 !important">Hora Inicio:</td>
                    <td style="text-align:center;border:1px #000000 !important">Hora Fin:</td>
                </tr>
                <tr>
                    <th>Periodo:</th>
                    <td colspan="2"><?php echo $fecha_ini. ' a '.$fecha_fin;?></td>
                    <td colspan="3"></td>
                    <td style="border:1px #000000 !important"><?php echo  date("d-m-Y H:i:s"); ?></td>
                    <td style="border:1px #000000 !important"></td>
                    <td style="border:1px #000000 !important"></td>
                </tr>
                <tr>
                    <th><b>Reintegro(s):</b></th><td> $<?= number_format($suma_reintego, 2); ?></td><td colspan="7"></td>
                </tr>
                <tr>
                    <td colspan="9"></td>
                </tr>
            </thead>
        </table>
        <?php
    } ?>
    <table border="1" width="100%">
        <thead>
            <tr>
                <th <?= ($p) ? 'width="8%"' : ""; ?>>Fecha Documento</th>
                <th <?= ($p) ? 'width="16%"' : ""; ?>>Nombre Proveedor</th>
                <th>Tipo Doc.</th>
                <th>Numero Doc.</th>
                <th>Concepto</th>
                <th <?= ($p) ? 'width="9%"' : ""; ?> >Monto</th>
                <th>Impuesto</th>
                <th <?= ($p) ? 'width="9%"' : ""; ?>>Valor Imp.</th>
                <th <?= ($p) ? 'width="9%"' : ""; ?>>Retenciones</th>
                <th <?= ($p) ? 'width="9%"' : ""; ?>>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if(count($detalles)>0){
                $subtotal= 0;
                $impuestos = 0;
                $totales1 = 0;
                $retenciale = 0;
                $retenciones = 0;
                $rowspan = 1;
                foreach ($detalles as $key){
                    $flag = 1;
                    $fecha = formatear_fecha('d-m-Y',$key['fecha']);
                    $impuesto_name = explode(',',$key['impuesto']);
                    $impuesto_val = explode(',',$key['monto_imp']);
                    $retencion_val = $key['cqc_retencion'];
                    $rowspan = count($impuesto_name);
                    $imp_tmp = 0;
                    foreach ($impuesto_val as $z){
                        $imp_tmp += $z;
                    }
                    $impuestos += $imp_tmp;
                    $subtotal = $key['cqc_monto'] + $imp_tmp - $retencion_val;
                    $retenciones += $retencion_val;
                    $totales1 += $subtotal;
                    ?>
                    <tr nobr="true">
                        <td <?= ($p) ? 'width="8%"' : ""; ?> align="left" rowspan="<?php echo $rowspan; ?>" ><?php echo $fecha;?></td>
                        <td <?= ($p) ? 'width="16%"' : ""; ?> align="left" rowspan="<?php echo $rowspan; ?>" ><?=$key['nombre']?></td>
                        <td align="left" rowspan="<?php echo $rowspan; ?>"><?=$key['tif_nombre']?></td>
                        <td align="left" rowspan="<?php echo $rowspan; ?>"><?=$key['cqc_numero_documento']?></td>
                        <td align="left" rowspan="<?php echo $rowspan; ?>"><?=$key['cqc_concepto']?></td>
                        <td <?= ($p) ?'width="9%"':"";?> style="text-align: right;" rowspan="<?= $rowspan ?>">$<?= number_format($key['cqc_monto'], 2) ?></td>
                        <?php
                        $x = 0;
                        foreach ($impuesto_name as $y ){
                            echo ($flag != 1) ? '<tr nobr="true">' : "";
                            ?>
                            <td><?= $y ?></td>
                            <td <?= ($p) ? 'width="9%"':""; ?> style="text-align: right;">$<?=number_format($impuesto_val[$x], 2)?></td>
                            <?php if ($flag == 1){ ?>
                                <td <?= ($p) ? 'width="9%"':""; ?> style="text-align: right;" rowspan="<?= $rowspan ?>">$<?= number_format($retencion_val, 2) ?></td>
                                <td <?= ($p) ? 'width="9%"':""; ?> style="text-align: right;" rowspan="<?= $rowspan ?>">$<?= number_format($subtotal, 2) ?></td>
                                <?php
                            }
                            $flag ++;
                            $x ++;
                            echo "</tr>";
                        }
                }
            }
            ?>
        </tbody>
        <tfoot>
            <tr style="border-bottom: 1px solid #c4c4c4;">
                <td colspan="7" style="text-align:center">Total</td>
                <td align="right">$<?=number_format($impuestos,2)?></td>
                <td align="right">$<?=number_format($retenciones,2)?></td>
                <td align="right">$<?=number_format($totales1,2)?></td>
            </tr>
        </tfoot>
    </table>
    <br />
    <?php
    if ($tipo_reporte =='pdf'){
        ?>
        <br /><br /><br />
        <table>
            <tr>
                <td style="width:50px;"></td>
                <td style="width:150px;font-weight: bold;">_______________________________</td>
                <td></td>
                <td></td>
                <td style="width:150px;font-weight: bold;">_______________________________</td>
                <td style="width:50px;"></td>
                <td></td>
            </tr>
            <tr>
                <td style="width:50px;"></td>
                <td style="text-align: center;width:150px;font-weight: bold;">Solicitante</td>
                <td></td>
                <td></td>
                <td style="text-align: center;width:150px;font-weight: bold;">Revisado</td>
                <td style="width:50px;"></td>
                <td></td>
            </tr>
        </table>
        <?php
    }
}else{
    ?>
    <!--Datos de la grid-->
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
        <thead>
            <tr>
                <th>Fecha Documento</th>
                <th>Nombre Proveedor</th>
                <th>Tipo Comprobante</th>
                <th>Numero Documento</th>
                <th>Concepto</th>
                <th>Monto</th>
                <th>Nombre Imp.</th>
                <th>Valor Imp.</th>
                <th>Retenciones</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if(count($detalles)>0){
                $subtotal = 0;
                $impuestos = 0;
                $retenciones = 0;
                $totales1 = 0;
                $rowspan = 1;
                foreach ($detalles as $key){
                    $flag = 1;
                    $fecha = formatear_fecha('d-m-Y', $key['fecha']);
                    $impuesto_name = explode(',', $key['impuesto']);
                    $impuesto_val = explode(',', $key['monto_imp']);
                    $retencion_val = $key['cqc_retencion'];
                    $rowspan = count($impuesto_name);
                    $imp_tmp = 0;
                    foreach ($impuesto_val as $z){
                        $imp_tmp += $z;
                    }
                    $impuestos += $imp_tmp;
                    $subtotal = $key['cqc_monto'] + $imp_tmp - $retencion_val;
                    $retenciones += $retencion_val;
                    $totales1 += $subtotal;
                    ?>
                    <tr>
                        <td rowspan="<?php echo $rowspan; ?>"><?php echo $fecha;?></td>
                        <td rowspan="<?php echo $rowspan; ?>"><?=$key['nombre']?></td>
                        <td rowspan="<?php echo $rowspan; ?>"><?=$key['tif_nombre']?></td>
                        <td rowspan="<?php echo $rowspan; ?>"><?=$key['cqc_numero_documento']?></td>
                        <td rowspan="<?php echo $rowspan; ?>"><?=$key['cqc_concepto']?></td>
                        <td style="text-align: right;" rowspan="<?php echo $rowspan; ?>">$<?= number_format($key['cqc_monto'], 2)?></td>
                        <?php
                        $x = 0;
                        foreach ($impuesto_name as $y ){
                            if ($flag!=1){
                                echo "<tr>";
                            }
                            ?>
                            <td><?=$y?></td>
                            <td style="text-align: right;">$<?=number_format($impuesto_val[$x], 2)?></td>
                            <?php
                            if ($flag==1){
                                ?>
                                <td style="text-align: right;" rowspan="<?= $rowspan ?>"><?= ($retencion_val > 0) ? "($" . number_format($retencion_val, 2) . ")" : "--"; ?></td>
                                <td style="text-align: right;" rowspan="<?= $rowspan ?>">$<?= number_format($subtotal, 2) ?></td>
                                <?php
                            }
                            $flag ++;
                            $x ++;
                        } ?>
                    </tr>
                    <?php
                }
            } ?>
        </tbody>
        <tfoot>
            <tr style="border-bottom: 1px solid #c4c4c4;">
                <td colspan="7" style="text-align:center">Total</td>
                <td style="text-align: right;">$<?=number_format($impuestos,2)?></td>
                <td style="text-align: right;">$<?=number_format($retenciones,2)?></td>
                <td style="text-align: right;">$<?=number_format($totales1,2)?></td>
            </tr>
        </tfoot>
    </table>
    <br />
    <?php
} ?>
